# Laravel Application Setup

## Background Operations

To ensure smooth functionality and task scheduling within the Laravel application, it's essential to run two background operations:

1. **Queue Worker:**
   - Run the following command in your terminal:
     ```
     php artisan queue:work
     ```
   - This command processes jobs from the queue.
   - It's recommended to run this command in a terminal session or as a background process using tools like Supervisor.

2. **Task Scheduler:**
   - Run the following command in your terminal:
     ```
     php artisan schedule:work
     ```
   - This command executes the scheduled tasks defined in the Laravel application.
   - Similar to the queue worker, it's recommended to run this command in a separate terminal session or as a background process using Supervisor.

## Environment Configuration

In your `.env` file, ensure that the `QUEUE_CONNECTION` variable is set to `database` to utilize the database as the queue driver. If it's not already set, add or modify the line as follows:

QUEUE_CONNECTION=database


By configuring the queue connection to use the database, your application will utilize the database as the storage mechanism for queued jobs, ensuring reliability and scalability.

For more information on Laravel queue and task scheduling, refer to the [official documentation](https://laravel.com/docs/). 
