<?php

namespace App\Console\Commands;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Http;
use App\Models\OrderDetails;
use App\Http\Controllers\Api\OrderController;
use App\Models\CompanyDetail;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Request;

class CheckOrderDetails extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:check-order-details';
    protected $description = 'Check order details for status = 0  and rp_order_id is null';

    public function __construct()
    {
        parent::__construct();
    }  
    
    public function handle()
    {
        $rows = OrderDetails::whereIn('Status', [0])->whereNull('rp_order_id')->get('id');
       
        if ($rows->isNotEmpty()) {  
           
          $baseUrl = URL::to('', [], true); 
            foreach($rows as $row){
                $order_ids[]=$row->id;
            }             
            $company_details = CompanyDetail::where('id', 1)->first(
                'company_shortcode'
              );
              
              if ($company_details) {
                if ($company_details->company_shortcode == 'MAYAR') {
                    $apiUrl = 'https://connect.mayar.com/api/public/api/update-rootpro-orderId';
                }
                if ($company_details->company_shortcode == 'NADEC') {
                    $apiUrl = 'https://b2bcustomerportal.azurewebsites.net/api/update-rootpro-orderId';
                }
              }
           
              $client = new \GuzzleHttp\Client([
                'verify' => false
            ]);
        
            $response = $client->post($apiUrl, [
                'json' => [
                    'order_ids' => $order_ids              
                ]
            ]);
 
            
            // $response = Http::post('http://localhost:8000/api/update-rootpro-orderId',[
            //     'order_ids' => $order_ids              
            // ]);        
            $body = $response->getBody()->getContents();

            $this->info('API Response Content: ' . $body);
            $this->info('API Response Headers: ' . json_encode($response->getHeaders()));      
  
            // $this->info('API Response Content: ' . $response->body());
            // $this->info('API Response Headers: ' . json_encode($response->headers()));       

}
    }
}
