<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Promotion;

class DeletePromotionsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    //protected $signature = 'app:delete-promotions-command';
    protected $signature = 'promotion:delete';
    protected $description = 'Delete promotions with status 0';


    /**
     * The console command description.
     *
     * @var string
     */
   
    /**
     * Execute the console command.
     */
    public function handle()
    {
        Promotion::where('status', 0)->delete();        
        $this->info('Promotions with status 0 have been deleted.');    
    }
}
