<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Banner;
use App\Http\Requests\StoreBannerRequest;
use App\Http\Requests\UpdateBannerRequest;
use App\Http\Resources\JsonResponseArrayResource;
use Illuminate\Support\Facades\Validator as FacadesValidator;
use Intervention\Image\ImageManagerStatic as Image;

class BannerController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function index()
  {
    $banner = banner::where('is_active', '=', '1')
      ->orderBy('from_date', "desc")
      ->get();
    return new JsonResponseArrayResource(true, 'banner list', $banner);
  }
  public function deleteBanner($id)
  {
    $active = 0;
    $banner_exist = Banner::where('id', $id)->first();
    if ($banner_exist) {
      $banner = Banner::find($id);
      $banner->is_active = $active;
      $banner->update();
      return new JsonResponseArrayResource(true, 'banner delete', $banner);
    }
  }

  /**
   * Show the form for creating a new resource.
   */
  public function create()
  {
    //
  }

  /**
   * Store a newly created resource in storage.
   */
  public function store(StoreBannerRequest $request)
  {
    $validator = FacadesValidator::make($request->all(), [
      'Banner_title' => 'required',
      'Banner_url' => 'required',
      'To_date' => 'required',
    ]);
    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }
    $banner_exist = Banner::where('id', $request->id)->first();
    if ($banner_exist) {
      $banner = Banner::find($banner_exist->id);
      $message = "banner updated";
      if ($request->hasFile('Banner_url')) {
        $value = $request->file('Banner_url');
        $rand = rand(100000, 1000000);
        $imageName = $request->Banner_name . $rand . '.' . $value->extension();

        $image = Image::make(file_get_contents($value));

        $image->resize(null, 600, function ($constraint) {
            $constraint->aspectRatio();
          });

        if (!file_exists('images/')) {
          mkdir('images/');
        }
        if (!file_exists('images/banner/')) {
          mkdir('images/banner/');
        }
        $img_name = 'images/banner/banner_' . $imageName;
        $image->save(public_path($img_name), 70);
        $banner->banner_url = $img_name;
      }
      $banner->banner_title = $request->Banner_title;
      if ($request->From_date) {
        $banner->from_date = $request->From_date;
      }
      $banner->to_date = $request->To_date;
      if ($request->Is_active) {
        $banner->is_active = $request->Is_active;
      }
      $banner->update();
      return new JsonResponseArrayResource(true, $message, $banner);
    } else {
      $banner = new Banner();
      $message = "banner Added";
      if ($request->hasFile('Banner_url')) {
        $value = $request->file('Banner_url');
        $rand = rand(100000, 1000000);
        $imageName = strtolower(
          str_replace(
            " ",
            "-",
            $request->Banner_title . '-' . $rand . '.' . $value->extension()
          )
        );
        $img = Image::make(file_get_contents($value));
        $img->resize(null, 600, function ($constraint) {
          $constraint->aspectRatio();
        });
        // $img->heighten(600, function ($constraint) {
        //   $constraint->upsize();
        // });
        if (!file_exists('images/')) {
          mkdir('images/');
        }
        if (!file_exists('images/banner/')) {
          mkdir('images/banner/');
        }
        $img_name = 'images/banner/' . $imageName;
        $img->save(public_path($img_name), 70);
        $banner->banner_url = $img_name;
      } else {
        return response()->json($validator->errors(), 422);
      }
      $banner->banner_title = $request->Banner_title;
      if ($request->From_date) {
        $banner->from_date = $request->From_date;
      }
      $banner->to_date = $request->To_date;
      if ($request->Is_active) {
        $banner->is_active = $request->Is_active;
      }
      if ($banner->save()) {
        return new JsonResponseArrayResource(true, $message, $banner);
      } else {
        return response()->json($validator->errors(), 422);
      }
    }
  }

  /**
   * Display the specified resource.
   */
  public function show($id)
  {
    $banner = Banner::where('id', '=', $id)->first();
    return new JsonResponseArrayResource(true, 'banner details', $banner);
  }

  /**
   * Show the form for editing the specified resource.
   */
  public function edit(Banner $banner)
  {
    //
  }

  /**
   * Update the specified resource in storage.
   */
  public function update(UpdateBannerRequest $request, Banner $banner)
  {
    //
  }

  /**
   * Remove the specified resource from storage.
   */
  public function destroy(Banner $banner)
  {
    //
  }
}
