<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\cart;
use App\Http\Requests\StorecartRequest;
use App\Http\Requests\UpdatecartRequest;
use App\Http\Resources\JsonResponseArrayResource;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class CartController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function index()
  {
    //
  }

  /**
   * Show the form for creating a new resource.
   */
  public function create()
  {
    //
  }

  /**
   * Store a newly created resource in storage.
   */
  // public function store(StorecartRequest $request)
  // {
  //   $validator = FacadesValidator::make($request->all(), [
  //     'user_id' => 'required',
  //     'customer_id' => 'required',
  //     'product_id' => 'required',
  //     'unit_price' => 'required',
  //     'qty' => 'required',
  //     'vat' => 'required',
  //   ]);
  //   if ($validator->fails()) {
  //     return response()->json($validator->errors(), 422);
  //   }

  //   $cart_exit = cart::where('user_id', $request->user_id)
  //     ->where('customer_id', $request->customer_id)
  //     ->where('product_id', $request->product_id)
  //     ->where('uom', $request->uom)
  //     ->where('active', 1)
  //     ->first();
  //   if ($cart_exit) {
  //     $cart = cart::find($cart_exit->id);
  //     $message = "Cart Item updated";
  //     $cart->user_id = $request->user_id;
  //     $cart->customer_id = $request->customer_id;
  //     $cart->product_id = $request->product_id;
  //     $cart->uom = $request->uom;
  //     $cart->unit_price = $request->unit_price;
  //     $cart->qty = $cart->qty + $request->qty;
  //     $cart->vat = $request->vat;
  //     $cart->active = $request->active ?? 1;

  //     if ($cart->update()) {
  //       return new JsonResponseArrayResource(true, $message, $cart);
  //     } else {
  //       return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
  //     }
  //   } else {
  //     $cart = new cart();
  //     $message = "Cart Item Added!";
  //     $cart->user_id = $request->user_id;
  //     $cart->customer_id = $request->customer_id;
  //     $cart->product_id = $request->product_id;
  //     $cart->uom = $request->uom;
  //     $cart->unit_price = $request->unit_price;
  //     $cart->qty = $request->qty;
  //     $cart->vat = $request->vat;
  //     $cart->active = $request->active ?? 1;
  //     if ($cart->save()) {
  //       return new JsonResponseArrayResource(true, $message, $cart);
  //     } else {
  //       return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
  //     }
  //   }
  // }

  public function store(StorecartRequest $request){
    $validator = FacadesValidator::make($request->all(), [
        'user_id' => 'required',
        'customer_id' => 'required',
        'product_id' => 'required',
        'unit_price' => 'required',
        'qty' => 'required',
        'vat' => 'required',
    ]);

    if ($validator->fails()) {
        return response()->json($validator->errors(), 422);
    }
    
      // Check if the item already exists in the cart
      $cart = Cart::where('user_id', $request->user_id)
          ->where('customer_id', $request->customer_id)
          ->where('product_id', $request->product_id)
          ->where('uom', $request->uom)
          ->where('active', 1)
          ->first();

      if ($cart) {
        if($request->qty > 0){
          // Update the quantity
          $cart->qty = $request->qty;
          $cart->update();
        }
        else{
          Cart::where('id', $cart->id)->forcedelete();
          $cart = Cart::find($cart->id);
        }  
      } 
      else {
        if($request->qty > 0){
          // Create a new cart item      
            $cart = new Cart();
            $cart->user_id = $request->user_id;
            $cart->customer_id = $request->customer_id;
            $cart->product_id = $request->product_id;
            $cart->uom = $request->uom;
            $cart->unit_price = $request->unit_price;
            $cart->qty = $request->qty;
            $cart->vat = $request->vat;
            $cart->active = $request->active ?? 1;
            $cart->save();
          } 
      }   

      // Calculate the total number of distinct items in the cart
      $totalItems = Cart::where('user_id', $request->user_id)
          ->where('customer_id', $request->customer_id)
          ->where('active', 1)
          ->distinct('product_id')
          ->count();

      // Calculate the total price in the cart
      $totalPrice = Cart::where('user_id', $request->user_id)
          ->where('customer_id', $request->customer_id)
          ->where('active', 1)
          ->sum(DB::raw('unit_price * qty'));

      return response()->json([
          'success' => true,
          'message' => 'Cart Item Added/Updated!',
          'cart' => $cart,
          'total_items' => $totalItems,
          'total_price' => $totalPrice,
      ]);
  
}

  

  public function getCartItems($user, $customer)
  {
    $cartitems = cart::where('cart.active', 1)
      ->where('cart.user_id', $user)
      ->where('cart.customer_id', $customer)
      ->leftJoin(
        'product',
        'product.item_code',
        '=',
        'cart.product_id'
      )->select([
        'cart.*',        
        'cart.unit_price AS Unit_Price',
        'product.item_name AS item_name',
        'product.thumbnail_product_image AS product_image',
         
      ])
      ->get();

    return new JsonResponseArrayResource(true, 'Cart items', $cartitems);
  }

  /**
   * Display the specified resource.
   */
  public function show(cart $cart)
  {
    //
  }

  /**
   * Show the form for editing the specified resource.
   */
  public function edit(cart $cart)
  {
    //
  }

  /**
   * Update the specified resource in storage.
   */
  public function update(UpdatecartRequest $request, cart $cart)
  {
    //
  }

  /**
   * Remove the specified resource from storage.
   */
  public function destroy($id)
  {
      // Find the cart item by ID
      $cartItem = Cart::find($id);
  
      // Check if the cart item exists
      if (!$cartItem) {
          return response()->json(['message' => 'Cart item not found'], 404);
      }
  
      // Delete the cart item
      $cartItem->forcedelete();
  
      return response()->json(['message' => 'Cart item deleted'], 200);
  }
}
