<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Http\Requests\StoreCategoryRequest;
use App\Http\Requests\UpdateCategoryRequest;
use App\Http\Resources\JsonResponseArrayResource;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator as FacadesValidator;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Support\Facades\App;

class CategoryController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function index()
  {
    $category = category::where('status', '=', '1')
      ->orderBy('id', "asc")
      ->get();

    return new JsonResponseArrayResource(true, 'category list', $category);
  }

  public function categoryByCustomer($cus_id){ 
      $validator = FacadesValidator::make(['cus_id' => $cus_id], [
        'cus_id' => 'required',
      ]);
      if ($validator->fails()) {
          return response()->json($validator->errors(), 422);
      }
    
    $options = [];
    if (App::environment('local')) {
        $options = ['verify' => false];
    }
    $url = "https://salesproapidev.azurewebsites.net/B2BItem/CategoryItems/{$cus_id}";

    $response = Http::timeout(500)
      ->withOptions($options)
      ->get($url, [
        'headers' => [
          'Content-Type' => 'application/json',
        ],
      ]);

    if ($response->successful()) {
        $categoryData = $response->json();
        $categoryValues = collect($categoryData)
          ->pluck('category_value')
          ->toArray();
        $externalCategories = Category::whereIn('value', $categoryValues)
          ->where('status', '=', '1')          
          ->get();
        $otherCategories = Category::whereNotIn('value', $categoryValues)
        ->where('status', '=', '1')
        ->orderBy('id', 'asc')
        ->get();
        $categories = $externalCategories->merge($otherCategories);
        return new JsonResponseArrayResource(
          true,
          'category list',
          $categories->toArray()
        );
    }
    else {
        return new JsonResponseArrayResource(
          false,
          'Failed to fetch categories',
          null
        );
    }
  }

  /**
   * Show the form for creating a new resource.
   */
  public function create()
  {
    //
  }

  /**
   * Store a newly created resource in storage.
   */
  public function store(StoreCategoryRequest $request)
  {
    $validator = FacadesValidator::make($request->all(), [
      'Category_name' => 'required',
      'Value' => 'required',
      'Category_name_ar' => 'required',
      'Category_img_url' => 'required',
    ]);
    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }

    $category_exit = Category::where('value', $request->Value)->first();
    if ($category_exit) {
      $category = Category::find($category_exit->id);
      $message = "category updated";
      if ($request->hasFile('Category_img_url')) {
        $value = $request->file('Category_img_url');
        $rand = rand(100000, 1000000);
        $imageName =
          $request->Category_name . $rand . '.' . $value->extension();
        $width = 1000; // your max width
        $height = 1000; // your max height
        $img = Image::make(file_get_contents($value));
        $img->height() > $img->width() ? ($width = null) : ($height = null);
        $image = $img->resize($width, $height, function ($constraint) {
          $constraint->aspectRatio();
        });
        if (!file_exists('images/')) {
          mkdir('images/');
        }
        if (!file_exists('images/category/')) {
          mkdir('images/category/');
        }
        $img_name =
          'images/category/category_' .
          strtolower(str_replace(' ', '_', $imageName));
        $image->save(public_path($img_name), 70);
        $category->category_img_url = $img_name;
      }
      $category->value = $request->Value;
      $category->category_name = $request->Category_name;
      $category->category_name_ar = $request->Category_name_ar;
      $category->category_desc = $request->Category_desc;
      $category->status = $request->Status ?? 1;
      $category->update();
      return new JsonResponseArrayResource(true, $message, $category);
    } else {
      $category = new Category();
      $message = "Status Added!";
      $value = $request->file('Category_img_url');
      $rand = rand(100000, 1000000);
      $imageName = $request->Category_name . $rand . '.' . $value->extension();
      $width = 1000; // your max width
      $height = 1000; // your max height
      $img = Image::make(file_get_contents($value));
      $img->height() > $img->width() ? ($width = null) : ($height = null);
      $image = $img->resize($width, $height, function ($constraint) {
        $constraint->aspectRatio();
      });
      if (!file_exists('images/')) {
        mkdir('images/');
      }
      if (!file_exists('images/category/')) {
        mkdir('images/category/');
      }
      $img_name =
        'images/category/category_' .
        strtolower(str_replace(' ', '_', $imageName));
      $image->save(public_path($img_name), 70);

      $category->value = $request->Value;
      $category->category_name = $request->Category_name;
      $category->category_name_ar = $request->Category_name_ar;
      $category->category_desc = $request->Category_desc;
      $category->category_img_url = $img_name;
      $category->status = $request->Status ?? 1;
      if ($category->save()) {
        return new JsonResponseArrayResource(true, $message, $category);
      } else {
        return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
      }
    }
  }

  /**
   * Display the specified resource.
   */
  public function show($id)
  {
    $cat = Category::where('id', '=', $id)->first();
    return new JsonResponseArrayResource(true, 'Category Details', $cat);
  }

  /**
   * Show the form for editing the specified resource.
   */
  public function edit(Category $category)
  {
    //
  }

  /**
   * Update the specified resource in storage.
   */
  public function update(UpdateCategoryRequest $request, Category $category)
  {
    //
  }

  /**
   * Remove the specified resource from storage.
   */
  public function destroy(Category $category)
  {
    //
  }
}
