<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\JsonResponseArrayResource;
use App\Models\ContractModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator as FacadesValidator;
class ContractController extends Controller
{
  public function index()
  {
    $contracts = ContractModel::where('Is_active', '=', '1')
      ->orderBy('created_at', "desc")
      ->get();
    return new JsonResponseArrayResource(true, 'List of Contracts', $contracts);
  }

  /**
   * Store a newly created resource in storage.
   */
  public function store(Request $request)
  {
    //define validation rules
    $validator = FacadesValidator::make($request->all(), [
      'Customer_id' => 'required',
      'Product_code' => 'required',
      'Price' => 'required',
      'Uom' => 'required',
    ]);
    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }
    $contracts = ContractModel::where('Is_active', '=', '1')
      ->where('customer', '=', $request->Customer_id)
      ->where('product_id', '=', $request->Product_code)
      ->count();
    //check if validation fails
    $contract = [
      'customer' => $request->Customer_id,
      'product_id' => $request->Product_code,
      'from_date' => $request->From_date ?? null,
      'to_date' => $request->To_date ?? null,
      'UPC' => $request->UPC ?? null,
      'product_uom' => strval($request->Uom),
      'price' => $request->Price,
      'Is_active' => $request->Is_active ?? 1,
    ];
    if ($contracts <= 0) {
      
      $contractindb = ContractModel::create($contract);
      return new JsonResponseArrayResource(
        true,
        'Contract Added!',
        $contractindb
      );
    } else {
      $contracts = ContractModel::where('Is_active', '=', '1')
        ->where('customer', '=', $request->Customer_id)
        ->where('product_id', '=', $request->Product_code)
        ->pluck('id')
        ->toArray();
      $contractFound = ContractModel::find(end($contracts));
      $contractFound->To_date = $request->From_date;
      $contractFound->save();
      $contractindb = ContractModel::create($contract);
      return new JsonResponseArrayResource(
        true,
        'Contract Updated!',
        $contractindb
      );
    }
  }

  public function show($id)
  {
    $contract = ContractModel::where('Is_active', '=', '1')
      ->where('id', '=', $id)
      ->get();

    return new JsonResponseArrayResource(true, 'Single Customer!', $contract);
  }

  /**
   * Show the form for editing the specified resource.
   */
}
