<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Customer;
use App\Http\Requests\StorecustomersRequest;
use App\Http\Requests\UpdatecustomersRequest;
use App\Http\Resources\JsonResponseArrayResource;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class CustomersController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function index()
  {

     
    
    // $customers = Customer::where('Is_active', '=', '1')->get();
    // return new JsonResponseArrayResource(true, 'List of Customers', $customers);
  }

  /**
   * Store a newly created resource in storage.
   */
  public function store(StorecustomersRequest $request)
  {
    //define validation rules
    $validator = FacadesValidator::make($request->all(), [
      'Code' => 'required',
      'Name' => 'required', 
    ]);
    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }
    $customers = Customer::where('Code', '=', $request->Code)
      ->count();
    //check if validation fails
    $customer = [
      'code' => $request->Code,
      'name' => $request->Name,
      'name_ar' => $request->Name_ar,
      'address1' => $request->Address1,
      'address2' => $request->Address2,
      'address1_ar' => $request->Address1_ar,
      'address2_ar' => $request->Address2_ar,
      'phone_num' => $request->Phone_num,
      'contact_email' => $request->Contact_email,
      'city' => $request->City,
      'city_ar' => $request->City_ar,
      'branch_id' => $request->Branch_ID,
      'zip' => $request->Zip,
      'customer_type' => $request->customertype,
      'payment_type' => $request->Payment_type,
      'credit_limit' => $request->Credit_limit,
      'credit_days' => $request->Credit_days,
      'credit_balance' => $request->Credit_balance,
      'vat_number' => $request->Vat_number,
      'ho_code' => $request->Ho_code,
      'contact_person' => $request->Contact_person,
      'contact_mobile' => $request->Contact_mobile,
      'customer_tax_id' => $request->Customer_tax_id,
      'route' => $request->Route,
      'subarea' => $request->Subarea,
      'area' => $request->Area,
      'branch' => $request->Branch,
      'pricegroup_id' => $request->PricegroupID,
      'Is_active' => $request->Is_active ?? 1,
      'country_code'=> $request->Country_code ?? "SAU",
      'currency'=> $request->Currency ?? "SR",
      'rounding'=> $request->Rounding ?? 2,
      'tax_applicable'=> $request->Tax_applicable ?? 1,
    ];
    if ($customers <= 0) {
      $customer = customer::create($customer);
      return new JsonResponseArrayResource(true, 'Customer Added!', $customer);
    } else {
      $customers = customer::where('Is_active', '=', '1')
        ->where('Code', '=', $request->Code)
        ->pluck('id')
        ->toArray();

      $customerFound = customer::find($customers[0]);

      $customerFound->update($customer);

      return new JsonResponseArrayResource(
        true,
        'Customer Updated!',
        $customerFound
      );
    }
  }


  /**
   * Store a newly created resource in storage.
   */
  public function customerStoreFromRoutePro(StorecustomersRequest $request)
  {
    //define validation rules
    $validator = FacadesValidator::make($request->all(), [
      'Code' => 'required',
      'Name' => 'required', 
    ]);

   // Log::info(json_encode($request));
    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }
    $customers = Customer::where('Code', '=', $request->Code)
      ->count();
    //check if validation fails
    $customer = [
      'code' => $request->Code,
      'name' => $request->Name,
      'name_ar' => $request->Name_ar,
      'address1' => $request->Address1,
      'address2' => $request->Address2,
      'address1_ar' => $request->Address1_ar,
      'address2_ar' => $request->Address2_ar,
      'phone_num' => $request->Phone_num,
      'contact_email' => $request->Contact_email,
      'city' => $request->City,
      'city_ar' => $request->City_ar,
      'branch_id' => $request->Branch_ID,
      'zip' => $request->Zip,
      'customer_type' => $request->customertype,
      'payment_type' => $request->Payment_type,
      'credit_limit' => $request->Credit_limit,
      'credit_days' => $request->Credit_days,
      'credit_balance' => $request->Credit_balance,
      'vat_number' => $request->Vat_number,
      'ho_code' => $request->Ho_code,
      'contact_person' => $request->Contact_person,
      'contact_mobile' => $request->Contact_mobile,
      'customer_tax_id' => $request->Customer_tax_id,
      'route' => $request->Route,
      'subarea' => $request->Subarea,
      'area' => $request->Area,
      'branch' => $request->Branch,
      'pricegroup_id' => $request->PricegroupID,
      'Is_active' => $request->Is_active ?? 1,
      'country_code'=> $request->Country_code ?? "SAU",
      'currency'=> $request->Currency ?? "SR",
      'rounding'=> $request->Rounding ?? 2,
      'tax_applicable'=> $request->Tax_applicable ?? 1,
    ];
    if ($customers <= 0) {
      $customer = customer::create($customer);
      return new JsonResponseArrayResource(true, 'Customer Added!', $customer);
    } else {
      $customers = customer::where('Is_active', '=', '1')
        ->where('Code', '=', $request->Code)
        ->pluck('id')
        ->toArray();

      $customerFound = customer::find($customers[0]);

      $customerFound->update($customer);

      return new JsonResponseArrayResource(
        true,
        'Customer Updated!',
        $customerFound
      );
    }
  }

  public function customerWithAdditionalDetails(StorecustomersRequest $request)
  {
    //define validation rules
    $validator = FacadesValidator::make($request->all(), [
      'Code' => 'required',
      'Name' => 'required', 
    ]);
    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }
    $customers = Customer::where('Code', '=', $request->Code)
      ->count();
    //check if validation fails
    $customer = [
      'code' => $request->Code,
      'name' => $request->Name,
      'name_ar' => $request->Name_ar,
      'address1' => $request->Address1,
      'address2' => $request->Address2,
      'address1_ar' => $request->Address1_ar,
      'address2_ar' => $request->Address2_ar,
      'phone_num' => $request->Phone_num,
      'contact_email' => $request->Contact_email,
      'city' => $request->City,
      'city_ar' => $request->City_ar,
      'branch_id' => $request->Branch_ID,
      'zip' => $request->Zip,
      'customer_type' => $request->customertype,
      'payment_type' => $request->Payment_type,
      'credit_limit' => $request->Credit_limit,
      'credit_days' => $request->Credit_days,
      'credit_balance' => $request->Credit_balance,
      'vat_number' => $request->Vat_number,
      'ho_code' => $request->Ho_code,
      'customer_groupkey' => $request->Customer_groupkey,
      'depot_name' => $request->Depot_name,
      'contact_person' => $request->Contact_person,
      'contact_mobile' => $request->Contact_mobile,
      'customer_tax_id' => $request->Customer_tax_id,
      'route' => $request->Route,
      'subarea' => $request->Subarea,
      'area' => $request->Area,
      'branch' => $request->Branch,
      'pricegroup_id' => $request->PricegroupID,
      'Is_active' => $request->Is_active ?? 1,
      'country_code'=> $request->Country_code ?? "SAU",
      'currency'=> $request->Currency ?? "SR",
      'rounding'=> $request->Rounding ?? 2,
      'tax_applicable'=> $request->Tax_applicable ?? 1,
    ];
    if ($customers <= 0) {
      $customer = customer::create($customer);
      return new JsonResponseArrayResource(true, 'Customer Added!', $customer);
    } else {
      $customers = customer::where('Is_active', '=', '1')
        ->where('Code', '=', $request->Code)
        ->pluck('id')
        ->toArray();

      $customerFound = customer::find($customers[0]);

      $customerFound->update($customer);

      return new JsonResponseArrayResource(
        true,
        'Customer Updated!',
        $customerFound
      );
    }
  }
  public function show($id)
  {
    $customer = Customer::where('Is_active', '=', '1')
      ->where('code', '=', $id)
      ->first();

    return new JsonResponseArrayResource(true, 'Single Customer!', $customer);
  }

  /**
   * Show the form for editing the specified resource.
   */
}
