<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\JsonResponseArrayResource;
use App\Models\CompanyDetail;
use App\Models\OrderDetails;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function getCountOfCustomersUsing()
    {
        $count = User::where('role', '=', 'USER')
            ->where('branches', 'NOT LIKE', '%[]%')
            ->where('branches', 'NOT LIKE', '')
            ->distinct('branches')
            ->count('branches');
        return new JsonResponseArrayResource(true, 'Number of distinct customers using the app',$count);
    }

    public function numberOfOrdersFromAppLast30Days()
    {
        // Get the current date
        $currentDate = Carbon::now();
        
        // Calculate the date 30 days ago
        $thirtyDaysAgo = $currentDate->subDays(30);
        
        // Retrieve the number of orders from the database
        $numberOfOrders = OrderDetails::where('Is_customer_portal_order', 1)
            ->where('order_date', '>', $thirtyDaysAgo)
            ->whereNotIn('Status', [998, 999]) // Exclude orders with status 998 and 999
            ->count();
        
        return new JsonResponseArrayResource(true, 'Number of orders from App in last 30 days',$numberOfOrders);
    }

    public function monthOnMonthCustomer6Months()
    {
        // Get the current date
        $currentDate = Carbon::now();
    
        // Calculate the date 6 months ago
        $sixMonthsAgo = $currentDate->subMonths(6);
    
        // Query to get month-on-month customer count for the last 6 months
        $monthOnMonthCustomers = OrderDetails::selectRaw('COUNT(DISTINCT customer_id) as customer_count, MONTH(order_date) as month, YEAR(order_date) as year')
            ->where('Is_customer_portal_order', 1)
            ->where('order_date', '>', $sixMonthsAgo)
            ->whereNotIn('Status', [998, 999]) // Exclude orders with status 998 and 999
            ->groupByRaw('MONTH(order_date), YEAR(order_date)')
            ->orderBy('year', 'ASC')
            ->orderBy('month', 'ASC')
            ->get();
    
            return new JsonResponseArrayResource(true, 'Month on month customer using app - for 6 months',$monthOnMonthCustomers);
    }

    public function monthOnMonthOrder6Months()
    {
        // Get the current date
        $currentDate = Carbon::now();
    
        // Calculate the date 6 months ago
        $sixMonthsAgo = $currentDate->subMonths(6);
    
        // Query to get month-on-month customer count for the last 6 months
        $monthOnMonthOrders = OrderDetails::selectRaw('COUNT(id) as order_count, MONTH(order_date) as month, YEAR(order_date) as year')
            ->where('Is_customer_portal_order', 1)
            ->where('order_date', '>', $sixMonthsAgo)
            ->whereNotIn('Status', [998, 999]) // Exclude orders with status 998 and 999
            ->groupByRaw('MONTH(order_date), YEAR(order_date)')
            ->orderBy('year', 'ASC')
            ->orderBy('month', 'ASC')
            ->get();
    
            return new JsonResponseArrayResource(true, 'Month on month orders from App - for 6 months',$monthOnMonthOrders);
    }


    function getOrderCountByStatusLast30Days() {

        $thirtyDaysAgo = Carbon::now()->subDays(30);
    
        $orderCounts = OrderDetails::leftJoin('order_status', 'order_status.value', '=', 'order_details.Status')
                                ->where('order_details.Is_customer_portal_order', 1)
                                ->whereNotIn('order_details.Status', ['998', '999'])
                                ->where('order_details.order_date', '>', $thirtyDaysAgo)
                                ->selectRaw('COUNT(DISTINCT order_details.id) as count, order_status.status AS orderstatus, order_details.STATUS as status')
                                ->groupBy('order_details.Status', 'order_status.status')
                                ->get();
     return new JsonResponseArrayResource(true, 'Status wise order count for last 30 days',$orderCounts);
    }
}
