<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class DataController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function store(Request $request)
  {
    $rules = [
      'sql' => 'required',
    ];

    $validator = FacadesValidator::make($request->all(), $rules);

    if ($validator->fails()) {
      return response()->json(
        [
          'success' => false,
          'message' => $validator->errors(),
        ],
        401
      );
    } else {
      $query = $request->sql;

      if (str_starts_with(strtolower($query), 'select')) {
        $results = DB::select($query);
      } elseif (str_starts_with(strtolower($query), 'insert')) {
        $results = DB::insert($query);
        $results =
          $results === true
            ? DB::connection()
              ->getPdo()
              ->lastInsertId()
            : $results;
      } elseif (str_starts_with(strtolower($query), 'update')) {
        $results = DB::update($query);
      } elseif (str_starts_with(strtolower($query), 'delete')) {
        $results = DB::delete($query);
      } else {
        $results = DB::statement($query);
      }

      return response()->json(
        [
          'success' => true,
          'result' => $results,
        ],
        200
      );
    }
  }
}
