<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Document;
use App\Http\Requests\StoreDocumentRequest;
use App\Http\Requests\UpdateDocumentRequest;
use App\Http\Resources\JsonResponseArrayPaginateResource;
use App\Http\Resources\JsonResponseArrayResource;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class DocumentController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $document = document::with("customer")->where('Is_active', '=', '1')
            ->orderBy('id', "desc")
            ->customPaginate();

        return new JsonResponseArrayPaginateResource(true, 'documents list', $document);
    }

    public function getUniqueCustomer()
    {
        $document = document::select('customer_id')->distinct()->with("customer")->where('Is_active', '=', '1')
            ->orderBy('id', "desc")
            ->get();
        return new JsonResponseArrayResource(true, 'documents list', $document);
    }

    public function getDocumentByCustomer($cust_id)
    {
        $document = document::with("customer")->where('customer_id', '=', $cust_id)->where('Is_active', '=', '1')
            ->orderBy('id', "desc")
            ->get();
        return new JsonResponseArrayResource(true, 'documents list', $document);
    }
    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreDocumentRequest $request)
    {
        $validator = FacadesValidator::make($request->all(), [
            'Created_by' => 'required',
            'Customer_id' => 'required',
            'Document_name' => 'required',
            'Document_url' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }

        $document_exit = Document::where('id', $request->Id)->first();
        if ($document_exit) {
            $document = Document::find($document_exit->id);
            $message = "Document updated";
            $rand = rand(100000, 1000000);
            $file = $request->file('Document_url');
            $fileName = 'document_' . $request->Customer_id . '-' . $request->Created_by . '-' . $rand . '.' .  $file->extension();
            $destinationPath = '/documents';
            $path = $file->storeAs($destinationPath, $fileName, ['disk' => 'public_uploads']);

            $document->document_url = $path;
            $document->created_by = $request->Created_by;
            $document->customer_id = $request->Customer_id;
            $document->document_name = $request->Document_name;
            $document->is_active = $request->Is_active ?? 1;
            $document->viewed_admin = $request->Viewed_admin ?? 0;
            if ($document->update())
                return new JsonResponseArrayResource(true, $message, $document);
        } else {

            $document = new Document();
            $message = "Document Added!";
            $rand = rand(100000, 1000000);
            $file = $request->file('Document_url');
            $fileName = 'document_' . $request->Customer_id . '-' . $request->Created_by . '-' . $rand . '.' .  $file->extension();
            $destinationPath = '/documents';
            $path = $file->storeAs($destinationPath, $fileName, ['disk' => 'public_uploads']);

            $document->document_url = $path;
            $document->created_by = $request->Created_by;
            $document->customer_id = $request->Customer_id;
            $document->document_name = $request->Document_name;
            if ($document->save()) {
                return  new  JsonResponseArrayResource(true, $message, $document);
            } else {
                return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
            }
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $document_exit = Document::where('id', '=', $id)->first();
        if ($document_exit) {
            $document = Document::find($document_exit->id);
            $document->viewed_admin = 1;
            if ($document->update()) {
                $documentGet = Document::with('customer')->find($document_exit->id);
                return new JsonResponseArrayResource(true, 'document', $documentGet);
            }
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Document $document)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateDocumentRequest $request, Document $document)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Document $document)
    {
        //
    }
}
