<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\FaqQuestion;
use App\Http\Requests\StoreFaqQuestionRequest;
use App\Http\Requests\UpdateFaqQuestionRequest;
use App\Http\Resources\JsonResponseArrayPaginateResource;
use App\Http\Resources\JsonResponseArrayResource;
use Illuminate\Support\Facades\Validator as FacadesValidator;
class FaqQuestionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $faq = FaqQuestion::leftJoin(
            'faq_category_master',
            'faq_questions.category_id',
            '=',
            'faq_category_master.id'
        )
        ->select([
            'faq_questions.id AS id',
            'faq_questions.question AS question',
            'faq_category_master.category_name AS category_name',
            'faq_questions.sort_order AS sort_order',
            'faq_questions.is_active AS active',

        ])->orderBy('faq_category_master.sort_order')
        ->customPaginate();

        return new JsonResponseArrayPaginateResource(true, 'faq  list', $faq);
      }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreFaqQuestionRequest $request)
    {
        $validator = FacadesValidator::make($request->all(), [
            'Category_id' => 'required',
            'Question' => 'required',
            'Answer' => 'required',
            'Sort_order' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }

        $faq_exit = FaqQuestion::where('id', $request->Id)->first();
        if ($faq_exit) {
            $faq = FaqQuestion::find($faq_exit->id);

            $faq->category_id = $request->Category_id;
            $faq->question = $request->Question;
            $faq->answer = $request->Answer;
            $faq->sort_order = $request->Sort_order;
            $faq->is_active = $request->Is_active ?? 1;
            if ($faq->update())
            $message = "Faq updated";
                return new JsonResponseArrayResource(true, $message, $faq);
        } else {
            $message = "Faq added";
            $faq = new FaqQuestion();
         
            $faq->category_id = $request->Category_id;
            $faq->question = $request->Question;
            $faq->answer = $request->Answer;
            $faq->sort_order = $request->Sort_order;
            $faq->is_active = $request->Is_active ?? 1;
            if ($faq->save()) {
                return  new  JsonResponseArrayResource(true, $message, $faq);
            } else {
                return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
            }
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $faq = FaqQuestion::where('faq_questions.category_id',$id)->leftJoin(
            'faq_category_master',
            'faq_questions.category_id',
            '=',
            'faq_category_master.id'
        )
        ->select([
            'faq_questions.id AS id',
            'faq_questions.question AS question',
            'faq_questions.answer AS answer',
            'faq_category_master.category_name AS category_name',
            'faq_questions.sort_order AS sort_order',
            'faq_questions.is_active AS active',

        ])->orderBy('faq_category_master.sort_order')
        ->customPaginate();

        return new JsonResponseArrayPaginateResource(true, 'faq  list', $faq);
      }
public function getFaqById($id){
    
    $faq = FaqQuestion::where('faq_questions.id',$id)->where('faq_questions.is_active',1)->leftJoin(
        'faq_category_master',
        'faq_questions.category_id',
        '=',
        'faq_category_master.id'
    )
    ->select([
        'faq_questions.id AS id',
        'faq_questions.question AS question',
        'faq_questions.answer AS answer',
        'faq_questions.category_id AS category_id',
        'faq_category_master.category_name AS category_name',
        'faq_questions.sort_order AS sort_order',
        'faq_questions.is_active AS active',

    ])->orderBy('faq_category_master.sort_order')
    ->first();

    return new JsonResponseArrayResource(true, 'faq', $faq);

}
public function UpdateStatusFaq($id,$active){
    $faq_exist = FaqQuestion::where('id', $id)->first();
    if ($faq_exist) {
    $faq = FaqQuestion::find($id);
    $faq->is_active = $active;
    $faq->update();
    return new JsonResponseArrayResource(true, 'Faq status changed', $faq);
    }
}
    /**
     * Show the form for editing the specified resource.
     */
    public function edit(FaqQuestion $faqQuestion)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateFaqQuestionRequest $request, FaqQuestion $faqQuestion)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(FaqQuestion $faqQuestion)
    {
        //
    }
}
