<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Feedback;
use App\Http\Requests\StoreFeedbackRequest;
use App\Http\Requests\UpdateFeedbackRequest;
use App\Http\Resources\JsonResponseArrayPaginateResource;
use App\Http\Resources\JsonResponseArrayResource;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class FeedbackController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(StoreFeedbackRequest $request)
    {
        $feedbacks = Feedback::leftJoin(
            'customer',
            'feedback.customer',
            '=',
            'customer.code'
          )->leftJoin(
            'users',
            'feedback.user',
            '=',
            'users.id'
          )->where('feedback.active', '=', '1')->select(['feedback.*', 'customer.name AS customer_name', 'users.name AS user_name']);

          $fromDate = $request->input('from_date');
          $toDate = $request->input('to_date');

      if ($fromDate !== null && strtolower($fromDate) !== 'null') {
        $feedbacks->where('feedback.created_at', '>=', $fromDate);
      }
      if ($toDate !== null && strtolower($toDate) !== 'null') {
        $feedbacks->where('feedback.created_at', '<=', $toDate);
      }
        $result = $feedbacks->orderBy('feedback.created_at', 'desc')->customPaginate(); 
        return new JsonResponseArrayPaginateResource(true, 'Feedbacks!', $result);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreFeedbackRequest $request)
    {
        $validator = FacadesValidator::make($request->all(), [
            'user' => 'required',
            'customer' => 'required',
            'orderId' => 'required',              
        ]);
    
    if ($validator->fails()) {
        return response()->json($validator->errors(), 422);
    }
   
        $feedback = new Feedback();
        $message = "Feedback Created!";
        $feedback->user = $request->user;
        $feedback->customer = $request->customer;
        $feedback->prodqualrating = $request->prodqualrating;
        $feedback->orddelrating = $request->orddelrating;
        $feedback->salesmanrating = $request->salesmanrating;
        $feedback->order_id = $request->orderId;
        $feedback->feedback = $request->feedback ?? null;
        $feedback->active = $request->active ?? 1;
         
        if ($feedback->save()) {
            return  new  JsonResponseArrayResource(true, $message, $feedback);
        } else {
            return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
        }
    
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $feedback = Feedback::where('feedback.id', '=', $id)->
        leftJoin(
            'customer',
            'feedback.customer',
            '=',
            'customer.code'
          )->leftJoin(
            'users',
            'feedback.user',
            '=',
            'users.id'
          )->where('feedback.active', '=', '1')
          ->select(['feedback.*', 'customer.name AS customer_name', 'users.name AS user_name'])
          ->first();
        return new JsonResponseArrayResource(true, 'Feedback Details!', $feedback);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Feedback $feedback)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateFeedbackRequest $request, Feedback $feedback)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Feedback $feedback)
    {
        //
    }
}
