<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\JsonResponseArrayResource;
use App\Models\Product;
use App\Models\ProductImage;
use Illuminate\View\View;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Intervention\Image\ImageManagerStatic as Image;

class ImageController extends Controller
{
  /**
   * Display a listing of the resource.
   *
   * @return \Illuminate\Http\Response
   */
  public function index() 
  {
    // return view('imageUpload');
  }

  public function store(Request $request)
  {
    $validator = Validator::make($request->all(), [
      'image' => 'required',
      'product_id' => 'required',
    ]);

    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }
    $product_exist = Product::where('item_code', $request->product_id)->first();
    if (!$product_exist) {
      $err['error'] = 'Product Id does not exist';
      return response()->json($err, 422);
    }
    $imgList = [];
    if (!$request->thumb) {
      $currentImages = ProductImage::where(
        'product_id',
        '=',
        $request->product_id
      )->update(['Is_active' => 0]);
    }
    foreach ($request->file('image') as $value) {
      $rand = rand(100000, 1000000);
      $imageName = $request->product_id . $rand . '.' . $value->extension();
      $width = 600; // your max width
      $height = 400; // your max height
      $img = Image::make(file_get_contents($value));
      $img->height() > $img->width() ? ($width = null) : ($height = null);
      $image = $img->resize($width, $height, function ($constraint) {
        $constraint->aspectRatio();
      });
      if (!file_exists('images/')) {
        mkdir('images/');
      }
      if (!file_exists('images/products/')) {
        mkdir('images/products/');
      }
      $image->save(public_path('images/products/product_' . $imageName), 70);
      if (!$request->thumb) {
        $product_image = new ProductImage();
        $product_image->product_id = $request->product_id;
        $product_image->file_path = 'images/products/product_' . $imageName;
        if ($product_image->save()) {
          array_push($imgList, $product_image);
        } else {
          return new JsonResponseArrayResource(
            false,
            "Something went wrong!",
            500
          );
        }
      } else {
        $product_exist = Product::where(
          'item_code',
          $request->product_id
        )->update([
          "thumbnail_product_image" => 'images/products/product_' . $imageName,
        ]);
        array_push($imgList, $imageName);
      }
    }
    if (count($imgList) > 0) {
      return new JsonResponseArrayResource(true, 'imageUploaded', $imgList);
    } else {
      return new JsonResponseArrayResource(false, "Something went wrong!", 500);
    }
  }

  public function storeSurveyImage(Request $request)
  {
    $validator = Validator::make($request->all(), [
      'image' => 'required',
    ]);

    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }

    $value = $request->file('image');
    $rand = rand(100000, 1000000);
    $imageName = $request->product_id . $rand . '.' . $value->extension();
    $width = 1000; // your max width
    $height = 1000; // your max height
    $img = Image::make(file_get_contents($value));
    $img->height() > $img->width() ? ($width = null) : ($height = null);
    $image = $img->resize($width, $height, function ($constraint) {
      $constraint->aspectRatio();
    });
    if (!file_exists('images/')) {
      mkdir('images/');
    }
    if (!file_exists('images/survey/')) {
      mkdir('images/survey/');
    }
    $img_name = 'images/survey/survey_' . $imageName;
    $image->save(public_path($img_name), 70);
    return new JsonResponseArrayResource(true, "imageName!", $img_name);
  }

  public function storePaymentImage(Request $request)
  {
    $validator = Validator::make($request->all(), [
      'image' => 'required',
    ]);

    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }

    $value = $request->file('image');
    $rand = rand(100000, 1000000);
    $imageName = $request->product_id . $rand . '.' . $value->extension();
    $width = 1000; // your max width
    $height = 1000; // your max height
    $img = Image::make(file_get_contents($value));
    $img->height() > $img->width() ? ($width = null) : ($height = null);
    $image = $img->resize($width, $height, function ($constraint) {
      $constraint->aspectRatio();
    });
    if (!file_exists('images/')) {
      mkdir('images/');
    }
    if (!file_exists('images/payment/')) {
      mkdir('images/payment/');
    }
    $img_name = 'images/payment/payment_' . $imageName;
    $image->save(public_path($img_name), 70);
    return new JsonResponseArrayResource(true, "imageName!", $img_name);
  }

  public function show($id)
  {
    $images = ProductImage::where('product_id', '=', $id)
      ->where('Is_active', '=', 1)
      ->get();
    return new JsonResponseArrayResource(true, "Images for product", $images);
  }
}
