<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\InvoiceDetails;
use App\Http\Resources\JsonResponseArrayPaginateResource;
use App\Http\Resources\JsonResponseArrayResource;
use App\Models\CompanyDetail;
use App\Models\InvoiceItems;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Response as FacadesResponse;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class InvoiceDetailsController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function index()
  {
    // $invoices = InvoiceDetails::with("invoiceItems")
    //   ->orderBy('created_at', 'desc')
    //   ->customPaginate();
    // return new JsonResponseArrayPaginateResource(
    //   true,
    //   'Invoice list!',
    //   $invoices
    // );

    $invoices = InvoiceDetails::orderBy('created_at', 'desc')
    ->customPaginate();
  return new JsonResponseArrayPaginateResource(
    true,
    'Invoice list!',
    $invoices
  );
  }

  public function invoiceStoreFromRoutePro(Request $request)
  {


    //define validation rules
    $validator = FacadesValidator::make($request->all(), [
      'invoice_number' => 'required',
    ]);

    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }
    try {
      DB::beginTransaction();
      $invoice_exist = InvoiceDetails::where(
        'invoice_number',
        $request->invoice_number
      )->first();
      if ($invoice_exist) {
        $invoice = InvoiceDetails::find($invoice_exist->id);
        $message = "Invoice Updated";
      } else {
        $invoice = new InvoiceDetails();
        $message = "Invoice Created";
      }
      $invoice->invoice_date = date(
        'Y-m-d',
        strtotime(str_replace('-', '/', $request->invoice_date))
      );

      $invoice->invoice_time = $request->invoice_time;
      $invoice->invoice_number = $request->invoice_number;
      $invoice->clear_tax_billing = $request->ClearTaxBilling;
      $invoice->order_number = $request->order_number;
      $invoice->sales_rep_name = $request->sales_rep_name;
      $invoice->invoice_amount = $request->invoice_amount;
      $invoice->o_or_b = $request->o_or_b;
      $invoice->status = $request->status;
      $invoice->legal = $request->legal;
      $invoice->customer_id = $request->customer_id;
      $invoice->branch = $request->branch;
      $invoice->ship_to = $request->ship_to;
      $invoice->route = $request->route;
      $invoice->sales_date = $request->sales_date;
      $invoice->given_disc = $request->given_disc;
      $invoice->total_amt = $request->total_amt;
      $invoice->total = $request->total;
      $invoice->VAT = $request->VAT;
      $invoice->amount_paid = $request->amount_paid;
      $invoice->balance_amt = $request->balance_amt;

      if ($invoice->save()) {
        if (
          isset($request->invoice_items) &&
          count($request->invoice_items) > 0
        ) {
          if ($invoice_exist) {
            InvoiceItems::where('invoice_id', $invoice->id)->forcedelete();
          }
          foreach ($request->invoice_items as $items) {
            $invoice_items = new InvoiceItems();
            $invoice_items->invoice_id = $invoice->id;
            $invoice_items->item_id = $items['item_id'];
            $invoice_items->UPC = $items['UPC'];
            $invoice_items->case_unit = $items['case_unit'];
            $invoice_items->case_price = $items['case_price'];
            $invoice_items->Unit_Price = $items['Unit_Price'];
            $invoice_items->given_disc = $items['given_disc'];
            $invoice_items->total = $items['total'];
            $invoice_items->VAT_per = $items['VAT_per'];
            $invoice_items->VAT_AMT = $items['VAT_AMT'];
            $invoice_items->total_amount = $items['total_amount'];
            if (!$invoice_items->save()) {
              DB::rollback();
              return new JsonResponseArrayResource(
                false,
                "Something went wrong!",
                500
              );
            }
          }
          DB::commit();
          $invoice->invoice_details = InvoiceItems::where(
            'invoice_id',
            $invoice->id
          )->get();

          return new JsonResponseArrayResource(true, $message, $invoice);
        } else {
          DB::rollback();
          return new JsonResponseArrayResource(
            false,
            "Something went wrong!",
            500
          );
        }
      }
    } catch (Exception $ex) {
      DB::rollback();
      return new JsonResponseArrayResource(false, $ex->getMessage(), 500);
    }
  }

  public function storeInvoiceHeader(request $request)
  {
    $validator = FacadesValidator::make($request->all(), [
      'Invoice_number' => 'required',
    ]);
    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }

    $invoice_exist = InvoiceDetails::where(
      'invoice_number',
      $request->Invoice_number
    )->first();
    if ($invoice_exist) {
      $message = "Invoice updated successfully";
      $invoice = InvoiceDetails::find($invoice_exist->id);

      $invoice->invoice_date = date(
        'Y-m-d',
        strtotime(str_replace('-', '/', $request->Invoice_date))
      );

      $invoice->invoice_number = $request->Invoice_number;
      $invoice->order_number = $request->Order_number;
      $invoice->invoice_amount = $request->Invoice_amount;
      $invoice->status = $request->Status;
      $invoice->customer_id = $request->Customer_id;
      $invoice->given_disc = $request->Given_disc;
      $invoice->total_amt = $request->Total_amt;
      $invoice->VAT = $request->VAT;
      $invoice->amount_paid = $request->Amount_paid;
      $invoice->balance_amt = $request->Balance_amt;
      if ($invoice->update()) {
        return new JsonResponseArrayResource(true, $message, $invoice);
      } else {
        return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
      }
    } else {
      $message = "Invoice Created Successfully";
      $invoice = new InvoiceDetails();

      $invoice->invoice_date = date(
        'Y-m-d',
        strtotime(str_replace('-', '/', $request->Invoice_date))
      );

      $invoice->invoice_number = $request->Invoice_number;
      $invoice->order_number = $request->Order_number;
      $invoice->invoice_amount = $request->Invoice_amount;
      $invoice->status = $request->Status;
      $invoice->customer_id = $request->Customer_id;
      $invoice->given_disc = $request->Given_disc;
      $invoice->total_amt = $request->Total_amt;
      $invoice->total = $request->total;
      $invoice->VAT = $request->VAT;
      $invoice->amount_paid = $request->Amount_paid;
      $invoice->balance_amt = $request->Balance_amt;

      if ($invoice->save()) {
        return new JsonResponseArrayResource(true, $message, $invoice);
      } else {
        return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
      }
    }
  }

  public function show($id)
  {
    $invoice = InvoiceDetails::with("invoiceItems")
      ->where('id', '=', $id)
      ->get();

    return new JsonResponseArrayResource(true, 'Single Invoice!', $invoice);
  }
  public function getClearTaxInvoice(Request $request)
  {
    
    $company_detail = new CompanyDetail();

    $vat_headers = $company_detail->CompanyInvoiceData();
    $params = [
      'invoiceType' => 'INV',
      'vat' => $vat_headers->vat,
    ];
    

    if ($request->invoiceNumber) {
      $params['invoiceNumber'] = $request->invoiceNumber;
    }
    if ($request->issueDate) {
      $params['issueDate'] = $request->issueDate;
    }
    $response = Http::withHeaders([
      'Content-Type' => 'application/pdf',
      'x-cleartax-auth-token' => $vat_headers->ct_token,
      'x-request-id' => $vat_headers->ct_req_id,
      'vat' => $vat_headers->vat,
    ])->get(
      'https://api.cleartax.com/middle-east/ksa/einvoicing/v2/einvoices/print',
      $params
    );
    $filename = 'invoice_' . $request->invoiceNumber;
    return FacadesResponse::make($response, 200, [
      'Content-Type' => 'application/pdf',
      'Content-Disposition' => 'inline; filename=' . $filename . '.pdf',
    ]);
  }
  public function getInvoiceListByCustomer($customer, Request $request)
  {
    $invoices = InvoiceDetails::where('customer_id', '=', $customer)
      ->leftJoin(
        'customer',
        'invoice_details.customer_id',
        '=',
        'customer.code'
      )
      ->select(['invoice_details.*', 'customer.name AS customer_name']);

    if ($request->invoice_number) {
      $invoices->where(
        'invoice_details.invoice_number',
        'like',
        '%' . $request->invoice_number . '%'
      );
    }

    if ($request->from_invoice_date) {
      $invoices->where(
        'invoice_details.invoice_date',
        '>=',
        $request->from_invoice_date
      );
    }
    if ($request->to_invoice_date) {
      $invoices->where(
        'invoice_details.invoice_date',
        '<=',
        $request->to_invoice_date
      );
    }

    $result = $invoices->get();
    // Calculate the total count of OrderItems for each order
    $result->each(function ($invoice) {
      $invoice->total_invoice_items = InvoiceDetails::where(
        'id',
        $invoice->id
      )->count();
    });
    return new JsonResponseArrayResource(true, 'Invoice List!', $result);
  }

  public function getInvoiceListByCustomerForOrder($customer, Request $request)
  {
    $invoices = InvoiceDetails::leftJoin(
      'customer',
      'invoice_details.customer_id',
      '=',
      'customer.code'
    )
      ->join('order_details', function ($join) use ($request) {
        $join
          ->on('invoice_details.order_number', '=', 'order_details.rp_order_id')
          ->where('order_details.Status', '=', $request->status);
          $rpOrderId = ($request->input('rporderid'));
          $fromOrderDate = ($request->input('from_order_date'));
          $toOrderDate = ($request->input('to_order_date'));
          if ($rpOrderId !== null && strtolower($rpOrderId) !== 'null') {
            $join->where('order_details.rp_order_id', 'like', '%' . $rpOrderId . '%');
        }
        if ($fromOrderDate !== null && strtolower($fromOrderDate) !== 'null') {
            $join->where('order_details.order_date', '>=', $fromOrderDate);
        }
        if ($toOrderDate !== null && strtolower($toOrderDate) !== 'null') {
            $join->where('order_details.order_date', '<=', $toOrderDate);
        }
      })
      ->select(
        'invoice_details.*',
        'order_details.Status AS status',
        'order_details.rp_order_id AS order_number',
        'order_details.order_date AS order_date',        
        'customer.name AS customer_name'
      )
      ->where('invoice_details.customer_id', '=', $customer);

    $result = $invoices->customPaginate();
    // Calculate the total count of OrderItems for each order
    $result->each(function ($invoice) {
      $invoice->total_invoice_items = InvoiceDetails::where( 'id', $invoice->id )->count();
    }); 
    return new JsonResponseArrayPaginateResource( true, 'Invoice List!',  $result);
  }



  public function getAllInvoiceListForAdmin(Request $request)
  {
    $invoice = InvoiceDetails::leftJoin(
      'customer',
      'invoice_details.customer_id',
      '=',
      'customer.code'
    )->select(['invoice_details.*', 'customer.name AS customer_name', 'customer.depot_name AS customer_depot_code', 'customer.route AS customer_route']);
    $code = $request->input('code');
    $customer = $request->input('customer');
    $depot = $request->input('depot');
    $route = $request->input('route');
    $fromInvoiceDate = $request->input('from_invoice_date');
    $toInvoiceDate = $request->input('to_invoice_date');

    if ($code !== null && strtolower($code) !== 'null') {
      $invoice->where('invoice_details.customer_id', 'like', '%' . $code . '%');
    }

    if ($customer !== null && strtolower($customer) !== 'null') {
      $invoice->where('customer.name', 'like', '%' . $customer . '%');
    }

    if ($depot !== null && strtolower($depot) !== 'null') {
      $invoice->where('customer.depot_name', 'like', '%' . $depot . '%');
       
    }

    if ($route !== null && strtolower($route) !== 'null') {
      $invoice->where('customer.route', 'like', '%' . $route . '%');
       
    }

    if ($fromInvoiceDate !== null && strtolower($fromInvoiceDate) !== 'null') {
      $invoice->where('invoice_details.invoice_date', '>=', $fromInvoiceDate);
    }
    if ($toInvoiceDate !== null && strtolower($toInvoiceDate) !== 'null') {
      $invoice->where('invoice_details.invoice_date', '<=', $toInvoiceDate);
    }
  
    $result = $invoice->orderBy('invoice_date', 'desc')->customPaginate(); 

    return new JsonResponseArrayPaginateResource(true, 'Invoice list!', $result); 
  }

  
}
