<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;

use App\Models\Notification;
use App\Http\Requests\StoreNotificationRequest;
use App\Http\Requests\UpdateNotificationRequest;
use App\Http\Resources\JsonResponseArrayPaginateResource;
use App\Http\Resources\JsonResponseArrayResource;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class NotificationController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $notification = Notification::where('Is_active', '=', '1')
            ->leftJoin(
                'users',
                'notifications.created_by_id',
                '=',
                'users.id'
            )
            ->select([
                'notifications.id AS id',
                'notifications.customer_category AS customer_category',
                'users.name AS created_by',
                'notifications.created_at AS created_on',
                'notifications.schedule_time AS schedule_time',

            ])->orderBy('notifications.id', "desc")
            ->customPaginate();

        return new JsonResponseArrayPaginateResource(true, 'notifications list', $notification);
    }
    public function getNotificationByCategory($id, $customer_id)
    {

        $date = Carbon::now('Asia/Kolkata');
        $formattedDate = $date->format('Y-m-d H:i:s'); 

        $message = Notification::where('is_active', '=', '1')
            ->leftJoin('notification_customer_mappings', function ($join) use ($customer_id) {
                $join->on('notifications.id', '=', 'notification_customer_mappings.notification_id')
                    ->where('notification_customer_mappings.customer_id', $customer_id);
            })
            ->where(function ($query) use ($id) {
                $query
                    ->where('notifications.customer_category', 'like', '%,' . $id . ',%')
                    ->orWhere('notifications.customer_category', 'like', '' . $id . ',%')
                    ->orWhere('notifications.customer_category', 'like', '%,' . $id . '')
                    ->orWhere('notifications.customer_category', 'like', '' . $id . '')
                    ->orWhere('notifications.customer_category', 'like', '1');
            })
            ->where(function ($query) {
                $query
                    ->where('notification_customer_mappings.status', '!=', 1)
                    ->orWhereNull('notification_customer_mappings.status');
            })
            ->where("notifications.schedule_time", "<=", $formattedDate)
            ->orderBy('notifications.schedule_time', 'desc')
            ->select([
                'notifications.id AS id',
                'notifications.customer_category AS customer_category',
                'notifications.message_tittle AS message_tittle',
                'notifications.message_desc AS message_desc',
                'notifications.schedule_time AS schedule_time',
                'notification_customer_mappings.status AS status'
            ])
            ->customPaginate();

        return new JsonResponseArrayPaginateResource(
            true,
            'message list!',
            $message
        );
    }
    public function getAllNotificationByCategory($id,$customer_id)
    {

        $date = Carbon::now('Asia/Kolkata');
        $formattedDate = $date->format('Y-m-d H:i:s'); 

        $message = Notification::where('is_active', '=', '1')
            ->leftJoin('notification_customer_mappings', function ($join) use ($customer_id) {
                $join->on('notifications.id', '=', 'notification_customer_mappings.notification_id')
                    ->where('notification_customer_mappings.customer_id', $customer_id);
            })
            ->where(function ($query) use ($id) {
                $query
                    ->where('notifications.customer_category', 'like', '%,' . $id . ',%')
                    ->orWhere('notifications.customer_category', 'like', '' . $id . ',%')
                    ->orWhere('notifications.customer_category', 'like', '%,' . $id . '')
                    ->orWhere('notifications.customer_category', 'like', '' . $id . '')
                    ->orWhere('notifications.customer_category', 'like', '1');
            })
            ->where("notifications.schedule_time", "<=", $formattedDate)
            ->select([
                'notifications.id AS id',
                'notifications.customer_category AS customer_category',
                'notifications.message_tittle AS message_tittle',
                'notifications.message_desc AS message_desc',
                'notifications.schedule_time AS schedule_time',
                'notification_customer_mappings.status AS status'
            ])
            ->orderBy('notifications.schedule_time', 'desc')
            ->customPaginate();

        return new JsonResponseArrayPaginateResource(
            true,
            'message list!',
            $message
        );
    }
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreNotificationRequest $request)
    {
        $validator = FacadesValidator::make($request->all(), [
            'Created_by_id' => 'required',
            'Message_tittle' => 'required',
            'Message_desc' => 'required',
            'Customer_category' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        try {

            DB::beginTransaction();

            $notification_exit = Notification::where('id', $request->id)->first();
            if ($notification_exit) {
                $notification = Notification::find($notification_exit->id);
                $notification->created_by_id = $request->Created_by_id;
                $notification->message_tittle = $request->Message_tittle;
                $notification->message_desc = $request->Message_desc;
                $notification->customer_category =  $request->Customer_category;
                $notification->status = $request->Status ?? 1;
                $notification->is_active = $request->Active ?? 1;
                if ($request->schedule_time) {
                    $notification->schedule_time = $request->schedule_time;
                }
                if ($notification->update())
                DB::commit();
                $message = "notification updated";
                return new JsonResponseArrayResource(true, $message, $notification);
         
            } else {
                $notification = new Notification();
                $message = "notification added";
            }
            $notification->created_by_id = $request->Created_by_id;
            $notification->message_tittle = $request->Message_tittle;
            $notification->message_desc = $request->Message_desc;
            $notification->customer_category =  $request->Customer_category;
            $notification->status = $request->Status ?? 1;
            $notification->is_active = $request->Active ?? 1;
            if ($request->schedule_time) {
                $notification->schedule_time = $request->schedule_time;
            }
            if ($notification->save()) {
                DB::commit();
                return  new  JsonResponseArrayResource(true, $message, $notification);
            } else {
                return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
            }
        } catch (Exception $ex) {
            DB::rollback();
            return new JsonResponseArrayResource(false, $ex->getMessage(), 500);
        }
    }

    public function show($id)
    {
        $notification = Notification::where('id', '=', $id)
            ->first();
        return new JsonResponseArrayResource(true, 'message', $notification);
    }

    public function edit(Notification $notification)
    {
        //
    }

    public function update(UpdateNotificationRequest $request, Notification $notification)
    {
        //
    }


    public function destroy(Notification $notification)
    {
    }
}
