<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\NotificationCustomerMapping;
use App\Http\Requests\StoreNotificationCustomerMappingRequest;
use App\Http\Requests\UpdateNotificationCustomerMappingRequest;
use App\Http\Resources\JsonResponseArrayResource;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class NotificationCustomerMappingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $status = NotificationCustomerMapping::orderBy('created_at', 'desc')->get();;
        return new JsonResponseArrayResource(true, 'Status list!', $status);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreNotificationCustomerMappingRequest $request)
    {
        $validator = FacadesValidator::make($request->all(), [
            'Notification_id' => 'required',
            'Customer_id' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        
        $messagestatus_exit = NotificationCustomerMapping::where('notification_id', $request->Notification_id)->where('customer_id', $request->Customer_id)
        ->first();
        if ($messagestatus_exit) {
            return new JsonResponseArrayResource(false, 'Status Already Added!', 200);
        }else {
            $messagestatus = new NotificationCustomerMapping();
            $message = "Status Added!";
       
        $messagestatus->notification_id = $request->Notification_id;
        $messagestatus->customer_id = $request->Customer_id;
        $messagestatus->status = $request->Status;
        if ($messagestatus->save()) {
            return  new  JsonResponseArrayResource(true,$message, $messagestatus);
        } else {
            return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
        }}
    }

    /**
     * Display the specified resource.
     */
    public function show(NotificationCustomerMapping $notificationCustomerMapping)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(NotificationCustomerMapping $notificationCustomerMapping)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateNotificationCustomerMappingRequest $request, NotificationCustomerMapping $notificationCustomerMapping)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(NotificationCustomerMapping $notificationCustomerMapping)
    {
        //
    }
}
