<?php
namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;
use App\Http\Resources\JsonResponseArrayPaginateResource;
use App\Models\FocEligibility;
use App\Models\OrderDetails;
use Illuminate\Http\Request;
use App\Http\Resources\JsonResponseArrayResource;
use App\Models\cart;
use App\Models\OrderItems;
use Illuminate\Support\Facades\Validator as FacadesValidator;
use Illuminate\Support\Facades\DB;
use Exception;
use App\Jobs\GetRootproOrderIdJob;
use App\Jobs\GetRootproOrderIdJobForNadec;
use App\Models\CompanyDetail;
use App\Models\Customer;
use App\Models\Product;
use App\Models\Promotion;
use App\Models\Transaction;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Http;
use App\Services\OrderNotificationService;

class OrderController extends Controller
{
  /**
   * Display a listing of the resource.
   */


  protected $ordernotificationservice;
   //
   public function __construct(OrderNotificationService $ordernotificationservice)
   {
       $this->ordernotificationservice = $ordernotificationservice;
   }
  public function index()
  {
    $orders = OrderDetails::with("orderDetails")
      ->where('Is_active', '=', '1')
      ->orderBy('created_at', 'desc')
      ->customPaginate();
    return new JsonResponseArrayPaginateResource(true, 'Order list!', $orders);
  }

  public function orderStoreFromRoutePro(Request $request)
  {
    //define validation rules
    $validator = FacadesValidator::make($request->all(), [
      'Order_id' => 'required',
    ]);

    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }
    try {
      DB::beginTransaction();
      $order_exist = OrderDetails::where(
        'rp_order_id',
        $request->Order_id
      )->first();
      if ($order_exist) {
        $order = OrderDetails::find($order_exist->id);
        $message = "Order Updated";

       if( $request->Status == 1){

          $this->ordernotificationservice->sendEmailtoUser($order->rp_order_id);
         // $notificationController = app()->make(OrderNotificaionController::class);
         //$notificationController->testEmail();

        }

      } else {
        $order = new OrderDetails();
        $message = "Order Created";
      }
      $order->rp_order_id = $request->Order_id;
      $order->po_number = $request->Po_number;
      $order->created_by = $request->Created_by;
      $order->delivery_route_code = $request->Route_code;
      $order->delivery_route_name = $request->Route_name;
      $order->order_date = date(
        'Y-m-d',
        strtotime(str_replace('-', '/', $request->Order_date))
      );
      $order->ship_to = $request->Ship_to;
      $order->sales_man = $request->Sales_man;
      $order->Status = $request->Status;

      
      $order->total_order_value = $request->Total_order_value;
      $order->delivery_slot = $request->Delivery_slot;
      $order->remarks = $request->Remarks;
      $order->vat_amt = $request->Vat;
      $order->net_amt = $request->Net_amount;
      $order->Is_active = $request->Is_active ?? 1;
      $order->customer_id = $request->customercode;
      if ($order_exist) {
        $order->Is_customer_portal_order = 1;

        //************Order Items and promotion recalculation */
        if ($order->save()) {
          //DB::commit();
          $order_id = $order->id;
          $customer_id = $request->customercode;
          $rounding = $this->getRounding($request->customer_id);

          if (
            isset($request->order_details) &&
            count($request->order_details) > 0
          ) {
            if ($order_exist) {
              OrderItems::where('order_id', $order->id)->forcedelete();
            }
            foreach ($request->order_details as $items) {
              $odr_items = new OrderItems();
              $odr_items->order_id = $order->id;
              $odr_items->product_id = $items['Product_id'];
              $odr_items->Unit_Price = isset($items['CASE_Price'])
                ? round($items['CASE_Price'], $rounding)
                : null;
              $odr_items->case_Price = isset($items['CASE_Price'])
                ? round($items['CASE_Price'], $rounding)
                : null;
              $prod_upc_details = Product::where(
                'item_code',
                $items['Product_id']
              )
                ->select('upc', 'VAT')
                ->first();
              $net_qty = $items['Qty'] / $prod_upc_details->upc;
              $odr_items->qty = $net_qty;
              $odr_items->total_Price = round(
                $items['CASE_Price'] * $net_qty,
                $rounding
              );
              $odr_items->vat = $prod_upc_details->VAT;
              $odr_items->vat_amt =
                $odr_items->total_Price * ($odr_items->vat / 100);
              //$odr_items->total_amount = round($items['Total_amount'],$rounding);
              $odr_items->total_amount =
                $odr_items->total_Price + $odr_items->vat_amt;
              $odr_items->active = $items['active'] ?? 1;
              $odr_items->direction = $items['direction'] ?? "CP-RP";
              $odr_items->uom = $items['uom'] ?? "Master Bag";
              $odr_items->remarks = $items['remarks'] ?? null;
              $odr_items->is_qty_updated = $items['Is_qty_updated'] ?? null;
              $odr_items->uom_quantity = $items['Qty'];
              $odr_items->uom_price = round($items['Unit_price'], $rounding);

              if (!$odr_items->save()) {
                DB::rollback();
                return new JsonResponseArrayResource(
                  false,
                  "Something went wrong!",
                  500
                );
              }
              //}
            }
            DB::commit();

            $order->order_details = OrderItems::where(
              'order_id',
              $order->id
            )->get();

            //*********Eligible Promotion starts here
            $order_id = $order->id;
            $promotions = Promotion::where('customer', $customer_id)
              ->where('promotions.status', 1)
              ->join(
                'promotion_type_master',
                'promotions.type',
                '=',
                'promotion_type_master.value'
              )
              ->get([
                'promotions.id',
                'promotions.qual_group',
                'promotions.assign_group',
                'promotions.range_basis',
                'promotions.low',
                'promotions.high',
                'promotions.rep_range',
                'promotions.promo_value',
                'promotion_type_master.promotion_type',
                'promotion_type_master.short_code',
                'promotion_type_master.value',
                'promotions.promo_type',
                'promotions.type',
              ]);
            $data = [];
            if ($promotions->isEmpty()) {
              DB::select('CALL UpdateOrderDetails(?)', [$order_id]);
              //Send to routepro
              $order_details = OrderDetails::where(
                'id',
                '=',
                $order->id
              )->first();
              if (isset($order_details)) {
                GetRootproOrderIdJob::dispatch($order_details);
              }
              return new JsonResponseArrayResource(true, $message, $order);
            } else {
              $allProducts = [];
              $company_details = CompanyDetail::where('id', 1)->first(
                'company_shortcode'
              );
              if ($company_details) {
                $company_shortcode = $company_details->company_shortcode;
              }

              foreach ($promotions as $promo) {
                $productIds = json_decode($promo->qual_group);
                $assignGroupId = json_decode($promo->assign_group);

                if ($productIds !== null) {
                  if ($promo->range_basis == 'QA' && !empty($productIds)) {
                    if (is_array($productIds) && count($productIds) > 1) {
                      $order_total_price = OrderItems::whereIn(
                        'product_id',
                        $productIds
                      )
                        ->where('active', 1)
                        ->where('order_id', $order_id)
                        ->sum('total_Price');

                      $flag_1 = 0;
                      if (
                        $order_total_price > $promo->low &&
                        $order_total_price < $promo->high &&
                        $promo->rep_range == 0
                      ) {
                        $flag_1 = 1;
                        $promo_value = $promo->promo_value;
                      }
                      if (
                        $order_total_price > $promo->low &&
                        $promo->rep_range == 1 &&
                        ($promo->promo_type == 'SLABPROMO' || $promo->type == 3)
                      ) {
                        $flag_1 = 1;
                        if ($promo->low > 0) {
                          $promo_value =
                            $promo->promo_value *
                            intval($order_total_price / $promo->low);
                        } else {
                          $promo_value = $promo->promo_value;
                        }
                      }
                      if ($flag_1 == 1) {
                        $product_details = Product::whereIn(
                          'item_code',
                          $productIds
                        )->get(['item_code', 'item_name']);
                        $assignGroup_details = Product::whereIn(
                          'item_code',
                          $assignGroupId
                        )->get(['item_code', 'item_name']);
                        $data[] = [
                          'customer' => $customer_id,
                          'promotion_id' => $promo->id,
                          'promotion_value' => $promo_value,
                          'promotion_type' => $promo->promotion_type,
                          'promotion_short_code' => $promo->short_code,
                          'qual_group' => $product_details,
                          'assign_group' => $assignGroup_details,
                          'range_basis' => $promo->range_basis,
                          'low' => $promo->low,
                          'high' => $promo->high,
                          'rep_range' => $promo->rep_range,
                          'promotion_master_value' => $promo->value,
                        ];
                      }
                    } else {
                      $order_total_price = OrderItems::whereIn(
                        'product_id',
                        $productIds
                      )
                        ->where('active', 1)
                        ->where('order_id', $request->Order_id)
                        ->sum('total_Price');

                      if ($promo->rep_range == 0) {
                        $promo_value = $promo->promo_value;
                        $products = OrderItems::whereIn(
                          'product_id',
                          $productIds
                        )
                          ->where(function ($query) use ($promo) {
                            $query
                              ->whereRaw(' ? <= total_Price', [$promo->low])
                              ->WhereRaw('? >= total_Price', [$promo->high]);
                          })
                          ->where('active', 1)
                          ->where('order_id', $order_id)
                          ->get();
                      }
                      if (
                        $promo->rep_range == 1 &&
                        ($promo->promo_type == 'SLABPROMO' || $promo->type == 3)
                      ) {
                        if ($promo->low > 0) {
                          $promo_value =
                            $promo->promo_value *
                            intval($order_total_price / $promo->low);
                        } else {
                          $promo_value = $promo->promo_value;
                        }

                        $products = OrderItems::whereIn(
                          'product_id',
                          $productIds
                        )
                          ->where(function ($query) use ($promo) {
                            $query->whereRaw(' ? <= total_Price', [
                              $promo->low,
                            ]);
                          })
                          ->where('active', 1)
                          ->where('order_id', $order_id)
                          ->get();
                      }

                      if ($products->isNotEmpty()) {
                        $product_details = Product::whereIn(
                          'item_code',
                          $productIds
                        )->get(['item_code', 'item_name']);
                        $assignGroup_details = Product::whereIn(
                          'item_code',
                          $assignGroupId
                        )->get(['item_code', 'item_name']);
                        $data[] = [
                          'customer' => $customer_id,
                          'promotion_id' => $promo->id,
                          'promotion_value' => $promo_value,
                          'promotion_type' => $promo->promotion_type,
                          'promotion_short_code' => $promo->short_code,
                          'qual_group' => $product_details,
                          'assign_group' => $assignGroup_details,
                          'range_basis' => $promo->range_basis,
                          'low' => $promo->low,
                          'high' => $promo->high,
                          'rep_range' => $promo->rep_range,
                          'promotion_master_value' => $promo->value,
                        ];
                      }
                    }
                  } elseif (
                    $promo->range_basis == 'QQ' &&
                    !empty($productIds)
                  ) {
                    if ($promo->rep_range == 0) {
                      if ($company_shortcode == 'MAYAR') {
                        $products = OrderItems::whereIn(
                          'product_id',
                          $productIds
                        )
                          ->where(function ($query) use ($promo) {
                            $query
                              ->whereRaw('? <= qty', [$promo->low])
                              ->WhereRaw('? >= qty', [$promo->high]);
                          })
                          ->where('order_id', $order_id)
                          ->get();
                      } else {
                        $products = OrderItems::whereIn(
                          'product_id',
                          $productIds
                        )
                          ->where(function ($query) use ($promo) {
                            $query
                              ->whereRaw('? <= uom_quantity', [$promo->low])
                              ->WhereRaw('? >= uom_quantity', [$promo->high]);
                          })
                          ->where('order_id', $order_id)
                          ->get();
                      }
                    }
                    if (
                      $promo->rep_range == 1 &&
                      ($promo->promo_type == 'SLABPROMO' || $promo->type == 3)
                    ) {
                      if ($company_shortcode == 'MAYAR') {
                        $products = OrderItems::whereIn(
                          'product_id',
                          $productIds
                        )
                          ->where(function ($query) use ($promo) {
                            $query->whereRaw('? <= qty', [$promo->low]);
                          })
                          ->where('order_id', $order_id)
                          ->get();
                      } else {
                        $products = OrderItems::whereIn(
                          'product_id',
                          $productIds
                        )
                          ->where(function ($query) use ($promo) {
                            $query->whereRaw('? <= uom_quantity', [
                              $promo->low,
                            ]);
                          })
                          ->where('order_id', $order_id)
                          ->get();
                      }
                    }
                    if (is_array($productIds) && count($productIds) > 1) {
                      if ($company_shortcode == 'MAYAR') {
                        $order_total_qty = OrderItems::whereIn(
                          'product_id',
                          $productIds
                        )
                          ->where('active', 1)
                          ->where('order_id', $order_id)
                          ->sum('qty');
                      } else {
                        $order_total_qty = OrderItems::whereIn(
                          'product_id',
                          $productIds
                        )
                          ->where('active', 1)
                          ->where('order_id', $order_id)
                          ->sum('uom_quantity');
                      }
                      // if ($products->isNotEmpty()) {
                      $flag_2 = 0;
                      if (
                        $order_total_qty >= $promo->low &&
                        $order_total_qty <= $promo->high &&
                        $promo->rep_range == 0
                      ) {
                        $flag_2 = 1;
                        $promo_value = $promo->promo_value;
                      }
                      if (
                        $order_total_qty >= $promo->low &&
                        $promo->rep_range == 1 &&
                        ($promo->promo_type == 'SLABPROMO' || $promo->type == 3)
                      ) {
                        $flag_2 = 1;
                        if ($promo->low > 0) {
                          $promo_value =
                            $promo->promo_value *
                            intval($order_total_qty / $promo->low);
                        } else {
                          $promo_value = $promo->promo_value;
                        }
                      }
                      if ($flag_2 == 1) {
                        $product_details = Product::whereIn(
                          'item_code',
                          $productIds
                        )->get(['item_code', 'item_name']);
                        $assignGroup_details = Product::whereIn(
                          'item_code',
                          $assignGroupId
                        )->get(['item_code', 'item_name']);
                        $data[] = [
                          'customer' => $customer_id,
                          'promotion_id' => $promo->id,
                          'promotion_value' => $promo_value,
                          'promotion_type' => $promo->promotion_type,
                          'promotion_short_code' => $promo->short_code,
                          'qual_group' => $product_details,
                          'assign_group' => $assignGroup_details,
                          'range_basis' => $promo->range_basis,
                          'low' => $promo->low,
                          'high' => $promo->high,
                          'rep_range' => $promo->rep_range,
                          'promotion_master_value' => $promo->value,
                        ];
                      }
                      // }
                    } else {
                      if ($products->isNotEmpty()) {
                        if ($company_shortcode == 'MAYAR') {
                          $order_total_qty = OrderItems::whereIn(
                            'product_id',
                            $productIds
                          )
                            ->where('active', 1)
                            ->where('order_id', $order_id)
                            ->sum('qty');
                        } else {
                          $order_total_qty = OrderItems::whereIn(
                            'product_id',
                            $productIds
                          )
                            ->where('active', 1)
                            ->where('order_id', $order_id)
                            ->sum('uom_quantity');
                        }
                        if ($promo->rep_range == 0) {
                          $promo_value = $promo->promo_value;
                        } elseif (
                          $promo->rep_range == 1 &&
                          ($promo->promo_type == 'SLABPROMO' ||
                            $promo->type == 3)
                        ) {
                          if ($promo->low > 0) {
                            $promo_value =
                              $promo->promo_value *
                              intval($order_total_qty / $promo->low);
                          } else {
                            $promo_value = $promo->promo_value;
                          }
                        }
                        $product_details = Product::whereIn(
                          'item_code',
                          $productIds
                        )->get(['item_code', 'item_name']);
                        $assignGroup_details = Product::whereIn(
                          'item_code',
                          $assignGroupId
                        )->get(['item_code', 'item_name']);
                        $data[] = [
                          'customer' => $customer_id,
                          'promotion_id' => $promo->id,
                          'promotion_value' => $promo_value,
                          'promotion_type' => $promo->promotion_type,
                          'promotion_short_code' => $promo->short_code,
                          'qual_group' => $product_details,
                          'assign_group' => $assignGroup_details,
                          'range_basis' => $promo->range_basis,
                          'low' => $promo->low,
                          'high' => $promo->high,
                          'rep_range' => $promo->rep_range,
                          'promotion_master_value' => $promo->value,
                        ];
                      }
                    }
                  }
                } else {
                  $invoice_total = OrderItems::where('active', 1)
                    ->where('order_id', $order_id)
                    ->sum('total_Price');

                  if (
                    $invoice_total > $promo->low &&
                    $invoice_total < $promo->high
                  ) {
                    $data[] = [
                      'customer' => $customer_id,
                      'promotion_id' => $promo->id,
                      'promotion_value' => $promo->promo_value,
                      'promotion_type' => $promo->promotion_type,
                      'promotion_short_code' => $promo->short_code,
                      'qual_group' => [],
                      'assign_group' => [],
                      'range_basis' => $promo->range_basis,
                      'low' => $promo->low,
                      'high' => $promo->high,
                      'rep_range' => $promo->rep_range,
                      'promotion_master_value' => $promo->value,
                    ];
                  }
                }
              }

              //   return new JsonResponseArrayResource(true, 'Promotion List', $data);
              //***********promotion calculations starts here */

              $promotions = $data;
              $qty = null;

              $check_transaction = Transaction::where(
                'order_id',
                $order_id
              )->count();
              if ($check_transaction > 0) {
                DB::select('CALL UpdationAfterProductChange(?)', [$order_id]);
              }

              if (!empty($promotions)) {
                $success = 0;
                $laPromotions = [];
                $lDPPromotions = [];
                $fgPromotions = [];

                foreach ($promotions as $promotion) {
                  if (
                    $promotion['promotion_short_code'] === 'LA' ||
                    $promotion['promotion_short_code'] === 'LP'
                  ) {
                    $laPromotions[] = $promotion;
                  } elseif ($promotion['promotion_short_code'] === 'IDP') {
                    $lDPPromotions[] = $promotion;
                  } elseif ($promotion['promotion_short_code'] === 'FG') {
                    $fgPromotions[] = $promotion;
                  }
                }
                if (!empty($laPromotions)) {
                  foreach ($laPromotions as $promo) {
                    $assign_group = $promo['assign_group'];

                    if (!empty($assign_group)) {
                      $item_code = [];
                      foreach ($assign_group as $group) {
                        // Access and print the "item_code" value for each object in the "assign_group" array
                        $item_code[] = $group['item_code'];
                      }

                      $product = OrderItems::whereIn('product_id', $item_code)
                        ->where('active', 1)
                        ->where('order_id', $order_id)
                        ->get();
                    } else {
                      $product = OrderItems::where('active', 1)
                        ->where('order_id', $order_id)
                        ->get();
                    }
                    if ($product->isNotEmpty()) {
                      foreach ($product as $prod) {
                        // $check = Transaction::where('product_id', $prod->product_id)->where('la_id', $prod->id)->where('order_id',$request->order_id)->first();
                        if ($company_shortcode == 'MAYAR') {
                          $qty = $prod->qty;
                        } else {
                          $qty = $prod->uom_quantity;
                        }
                        $promotion_value = $promo['promotion_value'];
                        if ($promo['promotion_short_code'] == 'LA') {
                          $discount = $qty * $promo['promotion_value'];
                        }
                        if ($promo['promotion_short_code'] == 'LP') {
                          $discount =
                            ($prod->total_Price * $promo['promotion_value']) /
                            100;
                        }
                        $transaction = new Transaction();

                        $TransArray = [
                          'promo_id' => $promo['promotion_id'],
                          'product_id' => $prod->product_id,
                          'la_id' => $prod->id,
                          'order_id' => $order_id,
                          'discount' => round($discount, $rounding),
                        ];
                        //$orderitemsObj->update(array('product_id' =>$prod->product_id,'order_id' => $request->order_id));
                        Transaction::create($TransArray);
                        DB::select('CALL CalculateAndUpdateDiscount(?, ?)', [
                          $order_id,
                          $prod->id,
                        ]);
                        $success = 1;
                      }
                    }
                  }
                }

                if (!empty($lDPPromotions)) {
                  $success = 0;
                  foreach ($lDPPromotions as $promo) {
                    $assign_group = $promo['assign_group'];
                    // product = (unitprice*qty) total_price - litemtotaldiscount = resultamount*promotion_value/100=discount
                    if (!empty($assign_group)) {
                      $item_code = [];
                      foreach ($assign_group as $group) {
                        $item_code[] = $group['item_code'];
                      }
                      $product = OrderItems::whereIn('product_id', $item_code)
                        ->where('active', 1)
                        ->where('order_id', $order_id)
                        ->get();
                    } else {
                      $product = OrderItems::where('active', 1)
                        ->where('order_id', $order_id)
                        ->get();
                    }
                    if ($product->isNotEmpty()) {
                      foreach ($product as $prod) {
                        $other_total_discount = Transaction::where(
                          'la_id',
                          $prod->id
                        )
                          ->where('order_id', $order_id)
                          ->sum('discount');
                        $total_priceArray = OrderItems::where('id', $prod->id)
                          ->where('order_id', $order_id)
                          ->first();
                        $total_price = $total_priceArray->total_Price;
                        $result_amount = $total_price - $other_total_discount;
                        $discount_amt =
                          ($result_amount * $promo['promotion_value']) / 100;

                        $transaction = new Transaction();

                        $TransArray = [
                          'promo_id' => $promo['promotion_id'],
                          'product_id' => $prod->product_id,
                          'la_id' => $prod->id,
                          'order_id' => $order_id,
                          'discount' => round($discount_amt, $rounding),
                        ];

                        Transaction::create($TransArray);

                        // Call the stored procedure with parameters
                        DB::select('CALL CalculateAndUpdateDiscount(?, ?)', [
                          $order_id,
                          $prod->id,
                        ]);
                        $success = 1;
                      }
                    }
                  }
                }

                //Free good promotions need to save
                if (!empty($fgPromotions)) {
                  $success = 0;
                  foreach ($fgPromotions as $promo) {
                    $existingPromo = FocEligibility::where(
                      'foc_promo_id',
                      $promo['promotion_id']
                    )
                      ->where('order_id', $order_id)
                      ->first();
                    if ($existingPromo) {
                      $existingPromo->update([
                        'status' => 1,
                        'rep_range' => $promo['rep_range'],
                        'product_count' => $promo['promotion_value'],
                      ]);
                    } else {
                      $focArray = [
                        'foc_promo_id' => $promo['promotion_id'],
                        'order_id' => $order_id,
                        'status' => 1,
                        'rep_range' => $promo['rep_range'],
                        'product_count' => $promo['promotion_value'],
                      ];
                      FocEligibility::create($focArray);
                    }
                  }
                  $success = 1;
                }

                if ($success == 1) {
                  DB::select('CALL UpdateOrderDetails(?)', [$order_id]);
                  $message = 'Order Saved & Promotions Calculated';
                  //Send to routepro
                  $order_details = OrderDetails::where(
                    'id',
                    '=',
                    $order->id
                  )->first();
                  if (isset($order_details)) {
                    GetRootproOrderIdJob::dispatch($order_details);
                  }
                  return new JsonResponseArrayResource(true, $message, $order);
                }
              } else {
                DB::select('CALL UpdateOrderDetails(?)', [$order_id]);
                //Send to routepro
                $order_details = OrderDetails::where(
                  'id',
                  '=',
                  $order->id
                )->first();
                if (isset($order_details)) {
                  GetRootproOrderIdJob::dispatch($order_details);
                }
                return new JsonResponseArrayResource(true, $message, $order);
              }
            }
          } else {
            //Update order_details
            OrderDetails::where('customer_id', '=', $order->customer_id)
              ->where('Status', '=', 999)
              ->where('id', '=', $order_id)
              ->update([
                'Status' => 0,
                'total_order_value' => 0,
                'vat_amt' => 0,
                'net_amt' => 0,
                'advance_amount' => 0,
                'total_discount' => 0,
              ]);

            return new JsonResponseArrayResource(true, $message, $order);
          }
        }
      } else {
        $order->Is_customer_portal_order = 0;
        if ($order->save()) {
          if (
            isset($request->order_details) &&
            count($request->order_details) > 0
          ) {
            if ($order_exist) {
              OrderItems::where('order_id', $order->id)->forcedelete();
            }
            foreach ($request->order_details as $items) {
              $odr_items = new OrderItems();
              $odr_items->order_id = $order->id;
              $odr_items->product_id = $items['Product_id'];
              $odr_items->Unit_Price = $items['Unit_price'];
              $odr_items->case_Price = $items['CASE_Price'];
              $odr_items->qty = $items['Qty'];
              $odr_items->total_Price = $items['Total_price'];
              $odr_items->vat_amt = $items['Vat'];
              $odr_items->total_amount = $items['Total_amount'];
              if (!$odr_items->save()) {
                DB::rollback();
                return new JsonResponseArrayResource(
                  false,
                  "Something went wrong!",
                  500
                );
              }
            }
            DB::commit();
            $order->order_details = OrderItems::where(
              'order_id',
              $order->id
            )->get();

            return new JsonResponseArrayResource(true, $message, $order);
          } else {
            DB::rollback();
            return new JsonResponseArrayResource(
              false,
              "Something went wrong!",
              500
            );
          }
        }
      }
    } catch (Exception $ex) {
      DB::rollback();
      return new JsonResponseArrayResource(false, $ex->getMessage(), 500);
    }
  }

  public function show($id)
  {
    $order = OrderDetails::with("orderDetails")
      ->where('order_details.id', '=', $id)
      ->leftJoin(
        'order_status',
        'order_details.Status',
        '=',
        'order_status.value'
      )
      ->leftJoin('customer', 'order_details.customer_id', '=', 'customer.code')
      ->select([
        'order_details.*',
        'customer.name AS customer_name',
        'customer.customer_tax_id AS customer_tax_id',
        'order_status.edit_permission AS edit_permission',
      ])
      ->first();

    return new JsonResponseArrayResource(true, 'Order Details!', $order);
  }

  public function storeOrder(Request $request)
  {
    //define validation rules
    $validator = FacadesValidator::make($request->all(), [
      'customer_id' => 'required',
    ]);

    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }
    try {
      DB::beginTransaction();
      $order_exist = OrderDetails::where('id', $request->id)->first();
      if ($order_exist) {
        $order = OrderDetails::find($order_exist->id);
        $message = "Order Updated";
      } else {
        $order = new OrderDetails();
        $message = "Order Created";
        $cart_exit = cart::where('user_id', $request->user_id)
          ->where('customer_id', $request->customer_id)
          ->get();
        if ($cart_exit) {
          foreach ($cart_exit as $cart_item) {
            $cartitem = cart::find($cart_item->id);
            $cartitem->active = 2;
            $cartitem->update();
          }
        }
      }

      $order->order_date = date(
        'Y-m-d',
        strtotime(str_replace('-', '/', $request->order_date))
      );
      $order->po_number = $request->po_number;
      $order->ship_to = $request->ship_to;
      $order->salesman_code = $request->salesman_code;
      $order->sales_man = $request->sales_man;
      $order->delivery_route_code = $request->delivery_route_code;
      $order->delivery_route_name = $request->delivery_route_name;
      $order->customer_id = $request->customer_id;
      $order->Status = $request->Status;
      $order->delivery_rep_name = $request->delivery_rep_name;
      $order->tentative_delivery_date = $request->tentative_delivery_date;
      $order->delivery_slot = $request->delivery_slot;
      $order->net_amt = $request->net_amt;
      $order->vat_amt = $request->vat_amt;
      $order->advance_amount = $request->advance_amount;
      $order->remarks = $request->remarks;
      $order->total_order_value = $request->total_order_value;
      $order->direction = $request->direction ?? "CP-RP";
      $order->synced = $request->synced;
      $order->created_timestamp = $request->created_timestamp;
      $order->updated_timestamp = $request->updated_timestamp;
      $order->Is_customer_portal_order =
        $request->Is_customer_portal_order ?? 1;
      $order->promotion_applied = $request->promotion_applied ?? 0;
      $order->Is_active = $request->Is_active ?? 1;
      if ($order->save()) {
        if (
          isset($request->order_details) &&
          count($request->order_details) > 0
        ) {
          if ($order_exist) {
            OrderItems::where('order_id', $order->id)->forcedelete();
          }
          foreach ($request->order_details as $items) {
            $odr_items = new OrderItems();
            $odr_items->order_id = $order->id;
            $odr_items->product_id = $items['product_id'];
            $odr_items->Unit_Price = $items['Unit_Price'];
            $odr_items->case_Price = $items['case_Price'] ?? null;
            $odr_items->qty = $items['qty'];
            $odr_items->total_Price = $items['total_Price'];
            $odr_items->vat = $items['vat'];
            $odr_items->vat_amt = $items['vat_amt'];
            $odr_items->total_amount = $items['total_amount'];
            $odr_items->active = $items['active'] ?? 1;
            $odr_items->direction = $items['direction'] ?? "CP-RP";
            $odr_items->uom = $items['uom'];
            $odr_items->upc = $items['upc'] ?? null;
            $odr_items->remarks = $items['remarks'] ?? null;
            if (!$odr_items->save()) {
              DB::rollback();
              return new JsonResponseArrayResource(
                false,
                "Something went wrong!",
                500
              );
            }
          }
          DB::commit();
          $order->order_details = OrderItems::where(
            'order_id',
            $order->id
          )->get();

          return new JsonResponseArrayResource(true, $message, $order);
        } else {
          DB::rollback();
          return new JsonResponseArrayResource(
            false,
            "Something went wrong!",
            500
          );
        }
      }
    } catch (Exception $ex) {
      DB::rollback();
      return new JsonResponseArrayResource(false, $ex->getMessage(), 500);
    }
  }
  public function updateOrderStatus(Request $request)
  {
    //define validation rules
    $validator = FacadesValidator::make($request->all(), [
      'OrderNumber' => 'required',
      'OrderStatus' => 'required',
    ]);

    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }

    $order_exist = OrderDetails::where('id', $request->OrderNumber)->first();
    if ($order_exist) {
      $order = OrderDetails::find($order_exist->id);
      $message = "Order Status Updated";
      $order->Status = $request->OrderStatus;
    } else {
      return new JsonResponseArrayResource(
        false,
        "Order Id " . $request->OrderNumber . " not found",
        ""
      );
    }

    if ($order->update()) {
      return new JsonResponseArrayResource(true, $message, $order);
    } else {
      return new JsonResponseArrayResource(false, "Something went wrong!", 500);
    }
  }

  public function getOrderListByCustomer($customer, Request $request)
  {


    $company_details = CompanyDetail::where('id', 1)->first();

    if ($company_details->company_shortcode == 'MAYAR') {
 
      //SAP Order Upddate start
    $orders = OrderDetails::where('customer_id', $customer)
    ->whereIn('Status', [1, 2])
    ->pluck('rp_order_id')
    ->toArray();
  //  $jsonString = json_encode($orders, JSON_PRETTY_PRINT);
  //  echo $jsonString; exit;

  $options = [];
  if (App::environment('local')) {
    $options = ['verify' => false];
  }
  $json = [];
  foreach ($orders as $order_id) {
    $json[] = [
      "VBELN" => $order_id,
    ];
  }

  $json_to_str = "'" . json_encode($json) . "'";

  $params = [
    '$filter' => 'ZvInput eq  ' . $json_to_str,
    '$format' => 'json',
  ];

  // $username = env('GT_DATA_USERNAME');
  // $password = env('GT_DATA_PASSWORD');
 

  $username =  $company_details->sap_user;
  $password = $company_details->sap_password;
 

  $credentials = base64_encode($username . ':' . $password);

  $response = Http::withHeaders([
    'Authorization' => 'Basic ' . $credentials,
  ])
    ->withOptions($options)
    ->get(
      'https://172.18.1.61:8001/sap/opu/odata/sap/ZSD_ORDER_DETAILS_GT_SRV_01/OderStatusSet',
      $params
    ); // https://172.18.1.61:8001 - production link

    if ($response->successful()) {       
      //  $jsonString = json_encode($data, JSON_PRETTY_PRINT);
      // echo $jsonString;    exit;   

  if (!is_null($response) && isset($response['d']['results'])) { 

    foreach ($response['d']['results'] as $result) {
      $rp_order_id = $result['Vbeln'];
      $status = $result['Status']; 
      if ($status === 'Being Processed') {
        $status_code = 2;
      } elseif ($status === 'Invoiced') {
        $status_code = 3;
      } 
 
      // Update the Status column in the order_details table
      OrderDetails::where('rp_order_id', $rp_order_id)->update([
        'Status' => $status_code,
      ]);
    }
  }
}
    }
    
  //SAP Order Upddate End
    

    $orders = OrderDetails::where('order_details.customer_id', '=', $customer)
      ->leftJoin('customer', 'order_details.customer_id', '=', 'customer.code')
      ->select(['order_details.*', 'customer.name AS customer_name']);

    $rpOrderId = $request->input('rporderid');
    $fromOrderDate = $request->input('from_order_date');
    $toOrderDate = $request->input('to_order_date');
    $fromDeliveryDate = $request->input('from_delivery_date');
    $toDeliveryDate = $request->input('to_delivery_date');

    if (isset($request->status)) {
      $orders->where('order_details.Status', '=', $request->status);
    }
    if ($request->orderid) {
      $orders->where('order_details.id', 'like', '%' . $request->orderid . '%');
    }

    if ($rpOrderId !== null && strtolower($rpOrderId) !== 'null') {
      $orders->where(
        'order_details.rp_order_id',
        'like',
        '%' . $rpOrderId . '%'
      );
    }

    if ($fromOrderDate !== null && strtolower($fromOrderDate) !== 'null') {
      $orders->where('order_details.order_date', '>=', $fromOrderDate);
    }
    if ($toOrderDate !== null && strtolower($toOrderDate) !== 'null') {
      $orders->where('order_details.order_date', '<=', $toOrderDate);
    }

    if (
      $fromDeliveryDate !== null &&
      strtolower($fromDeliveryDate) !== 'null'
    ) {
      $orders->where(
        'order_details.tentative_delivery_date',
        '>=',
        $fromDeliveryDate
      );
    }

    if ($toDeliveryDate !== null && strtolower($toDeliveryDate) !== 'null') {
      $orders->where(
        'order_details.tentative_delivery_date',
        '<=',
        $toDeliveryDate
      );
    }

    $result = $orders->orderBy('order_date', 'desc')->customPaginate();
    // Calculate the total count of OrderItems for each order
    $result->each(function ($order) {
      $order->total_order_items = OrderItems::where(
        'order_id',
        $order->id
      )->count();
    });

    return new JsonResponseArrayPaginateResource(true, 'Order list!', $result);
  }

 

  public function getAllOrderListForAdmin_17_12_2024(Request $request)
  {
    request()->per_page = 20;
    $orders = OrderDetails::leftJoin(
      'customer',
      'order_details.customer_id',
      '=',
      'customer.code'
    )->select(['order_details.*', 'customer.name AS customer_name', 'customer.depot_name AS depot_code', 'customer.route AS route']);
    $code = $request->input('code');
    $customer = $request->input('customer');
    $depot = $request->input('depot');
    $route = $request->input('route');
    $fromOrderDate = $request->input('from_order_date');
    $toOrderDate = $request->input('to_order_date');

    if ($code !== null && strtolower($code) !== 'null') {
      $orders->where('order_details.customer_id', 'like', '%' . $code . '%');
    }

    if ($customer !== null && strtolower($customer) !== 'null') {
      $orders->where('customer.name', 'like', '%' . $customer . '%');
    }

    if ($depot !== null && strtolower($depot) !== 'null') {
      $orders->where('customer.depot_name', 'like', '%' . $depot . '%');
       
    }

    if ($route !== null && strtolower($route) !== 'null') {
      $orders->where('customer.route', 'like', '%' . $route . '%');
       
    }

    if ($fromOrderDate !== null && strtolower($fromOrderDate) !== 'null') {
      $orders->where('order_details.order_date', '>=', $fromOrderDate);
    }
    if ($toOrderDate !== null && strtolower($toOrderDate) !== 'null') {
      $orders->where('order_details.order_date', '<=', $toOrderDate);
    }

    $orders->whereNotIn('order_details.Status', [999, 998]);  
    $result = $orders->orderBy('order_date', 'desc')->customPaginate(); 
    return new JsonResponseArrayPaginateResource(true, 'Order list!', $result); 
  }

 

   public function getAllOrderListForAdmin(Request $request)
   {
   

    $company_details = CompanyDetail::where('id', 1)->first();

    if ($company_details->company_shortcode == 'MAYAR') {
 
      //SAP Order Upddate start
    $orders = OrderDetails::whereIn('Status', [1, 2])
    ->pluck('rp_order_id')
    ->toArray();
    //  $jsonString = json_encode($orders, JSON_PRETTY_PRINT);
    //  echo $jsonString; exit;

    $options = [];
    if (App::environment('local')) {
      $options = ['verify' => false];
    }
    $json = [];
    foreach ($orders as $order_id) {
      $json[] = [
        "VBELN" => $order_id,
      ];
    }

    $json_to_str = "'" . json_encode($json) . "'";

    $params = [
      '$filter' => 'ZvInput eq  ' . $json_to_str,
      '$format' => 'json',
    ];

    // $username = env('GT_DATA_USERNAME');
    // $password = env('GT_DATA_PASSWORD');
 
      /*
        $username =  $company_details->sap_user;
        $password = $company_details->sap_password;
      

        $credentials = base64_encode($username . ':' . $password);

        $response = Http::withHeaders([
          'Authorization' => 'Basic ' . $credentials,
        ])
          ->withOptions($options)
          ->get(
            'https://172.18.1.61:8001/sap/opu/odata/sap/ZSD_ORDER_DETAILS_GT_SRV_01/OderStatusSet',
            $params
          ); // https://172.18.1.61:8001 - production link

          if ($response->successful()) {       
            //  $jsonString = json_encode($data, JSON_PRETTY_PRINT);
            // echo $jsonString;    exit;   

        if (!is_null($response) && isset($response['d']['results'])) { 

          foreach ($response['d']['results'] as $result) {
            $rp_order_id = $result['Vbeln'];
            $status = $result['Status']; 
            if ($status === 'Being Processed') {
              $status_code = 2;
            } elseif ($status === 'Invoiced') {
              $status_code = 3;
            } 
      
            // Update the Status column in the order_details table
            OrderDetails::where('rp_order_id', $rp_order_id)->update([
              'Status' => $status_code,
            ]);
          }
        }
      }*/
    }
    
    //SAP Order Upddate End
    

    $orders = OrderDetails::Join('customer', 'order_details.customer_id', '=', 'customer.code')
      ->select(['order_details.*', 'customer.name AS customer_name']);

    $rpOrderId = $request->input('rporderid');
    $fromOrderDate = $request->input('from_order_date');
    $toOrderDate = $request->input('to_order_date');
    $fromDeliveryDate = $request->input('from_delivery_date');
    $toDeliveryDate = $request->input('to_delivery_date');

    if (isset($request->status)) {
      $orders->where('order_details.Status', '=', $request->status);
    }
    if ($request->orderid) {
      $orders->where('order_details.id', 'like', '%' . $request->orderid . '%');
    }

    if ($rpOrderId !== null && strtolower($rpOrderId) !== 'null') {
      $orders->where(
        'order_details.rp_order_id',
        'like',
        '%' . $rpOrderId . '%'
      );
    }

    if ($fromOrderDate !== null && strtolower($fromOrderDate) !== 'null') {
      $orders->where('order_details.order_date', '>=', $fromOrderDate);
    }
    if ($toOrderDate !== null && strtolower($toOrderDate) !== 'null') {
      $orders->where('order_details.order_date', '<=', $toOrderDate);
    }

    if (
      $fromDeliveryDate !== null &&
      strtolower($fromDeliveryDate) !== 'null'
    ) {
      $orders->where(
        'order_details.tentative_delivery_date',
        '>=',
        $fromDeliveryDate
      );
    }

    if ($toDeliveryDate !== null && strtolower($toDeliveryDate) !== 'null') {
      $orders->where(
        'order_details.tentative_delivery_date',
        '<=',
        $toDeliveryDate
      );
    }

    $result = $orders->orderBy('order_date', 'desc')->customPaginate();
    // Calculate the total count of OrderItems for each order
    $result->each(function ($order) {
      $order->total_order_items = OrderItems::where(
        'order_id',
        $order->id
      )->count();
    });

    return new JsonResponseArrayPaginateResource(true, 'Order list!', $result);
   }

  public function getLatestSavedOrderByCustomer($customer)
  {
    $order = OrderDetails::where('order_details.customer_id', '=', $customer)
      ->where('order_details.Status', '=', 999)
      ->orderBy('order_details.id', 'desc')
      ->first();

    if ($order) {
      return new JsonResponseArrayResource(true, 'Lates Saved Order', $order);
    } else {
      return new JsonResponseArrayResource(false, 'No order found', 422);
    }
  }
  public function getLatestSavedOrderByCustomerAndUser($user, $customer)
  {
    $order = OrderDetails::where('order_details.customer_id', '=', $customer)
      ->where('order_details.user_id', '=', $user)
      ->where('order_details.Status', '=', 999)
      ->orderBy('order_details.id', 'desc')
      ->first();

    if ($order) {
      return new JsonResponseArrayResource(true, 'Lates Saved Order', $order);
    } else {
      return new JsonResponseArrayResource(false, 'No order found', 422);
    }
  }

  public function updateRootproOrderId(Request $request)
  {
    if ($request->has('order_ids')) {
      $order_ids = $request->input('order_ids');
    } else {
      $validator = FacadesValidator::make($request->all(), [
        'order_id' => 'required',
      ]);

      if ($validator->fails()) {
        return response()->json($validator->errors(), 422);
      }
      $order_ids[] = $request->order_id;
    }

    foreach ($order_ids as $order_id) {
      $order_details = OrderDetails::where('id', '=', $order_id)->first();
      if (isset($order_details)) {
        if ($order_details['Status'] == '999') {
          OrderDetails::where('id', $order_id)->update(['Status' => 0]);
        }
        // Dispatch the rootpro order get job
        $company_details = CompanyDetail::where('id', 1)->first(
          'company_shortcode'
        );

        if ($company_details) {
          if ($company_details->company_shortcode == 'MAYAR') {
            GetRootproOrderIdJob::dispatch($order_details);
          }
          if ($company_details->company_shortcode == 'NADEC') {
            GetRootproOrderIdJobForNadec::dispatch($order_details);
          }
        }

        $data = [];
        return new JsonResponseArrayResource(true, 'Success', $data);
      } else {
        $errors = [];
        $errors['error'] = 'Order details not found!';
        return response()->json($errors, 401);
      }
    }
  }

  public function cancelOrder($orderid)
  {
    try {
      // Find the OrderDetail by ID

      OrderDetails::where('id', '=', $orderid)->update([
        'Status' => 6,
        'rp_order_id' => null,
      ]);
      // $orderDetail = OrderDetails::find($orderid);

      // // Update the fields
      // $orderDetail->Status = 6;
      //       $orderDetail->rp_order_id = null;
      //       $orderDetail->save();

      return new JsonResponseArrayResource(true, 'Order Cancelled', $orderid);
    } catch (\Exception $e) {
      return new JsonResponseArrayResource(false, $e->getMessage(), 500);
    }
  }

  function getRounding($customer_id)
  {
    $customer = Customer::where('code', $customer_id)->first('rounding');
    if (!empty($customer)) {
      $rounding = $customer->rounding;
    } else {
      $rounding = 2;
    }
    return $rounding;
  }
}
