<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\OrderItems;
use App\Models\cart;
use Illuminate\Http\Request;
use App\Http\Resources\JsonResponseArrayResource;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class OrderItemController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validator = FacadesValidator::make($request->all(), [
            'order_id' => 'required', 
            'product_id' => 'required',
            'Unit_Price' => 'required',
            'qty' => 'required',
            'vat' => 'required',
            'vat_amt' => 'required',
            'total_Price' => 'required',
            'total_amount' => 'required',            
          ]);
          if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
          }          
            $cart_exit = OrderItems::where('order_id', $request->order_id) 
              ->where('product_id', $request->product_id)
              ->where('uom', $request->uom)
              ->where('active', 1)
              ->first();  
            if ($cart_exit) { 
              if($request->qty > 0){              
                $cart = OrderItems::find($cart_exit->id);
                $message = "Cart Item updated"; 
                $cart->order_id =$request->order_id;
                $cart->product_id = $request->product_id;
                $cart->uom = $request->uom;
                $cart->Unit_Price = $request->Unit_Price;
                $cart->qty =  $request->qty;
                $cart->vat = $request->vat;
                $cart->vat_amt = $request->vat_amt;
                $cart->total_Price = $request->total_Price;
                $cart->total_amount = $request->total_amount;
                $cart->direction = $request->direction ?? "CP-RP";
                $cart->active = $request->active ?? 1;
                $cart->update();
                $status=1;
              }
              else{
                OrderItems::where('id', $cart_exit->id)->forcedelete();
                $cart = OrderItems::find($cart_exit->id);
                $message = "Cart Item updated"; 
                $status=1;
              }
          
              if ($status==1) {
                // Calculate the total number of distinct items in the cart
                $totalItems = OrderItems::where('order_id', $request->order_id)
                ->where('active', 1)
                ->distinct('product_id')
                ->count();

            // Calculate the total price in the cart
            $totalPrice = OrderItems::where('order_id', $request->order_id)
                ->where('active', 1)
                ->sum(DB::raw('Unit_Price * qty'));

            return response()->json([
                'success' => true,
                'message' => 'Cart Item Updated!',
                'cart' => $cart,
                'total_items' => $totalItems,
                'total_price' => $totalPrice,
            ]);
              } else {
                return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
              }
            }
            else {
              $status=0;
              if($request->qty > 0){  
                $cart = new OrderItems();
                $message = "Cart Item Added!";
                $cart->order_id =$request->order_id;
                $cart->product_id = $request->product_id;
                $cart->uom = $request->uom;
                $cart->Unit_Price = $request->Unit_Price;
                $cart->qty = $request->qty;
                $cart->vat = $request->vat;
                $cart->vat_amt = $request->vat_amt;
                $cart->total_Price = $request->total_Price;
                $cart->total_amount = $request->total_amount;
                $cart->direction = $request->direction ?? "CP-RP";
                $cart->active = $request->active ?? 1;
                $cart->save();  
                $status=1;                              
              }  
              else{
                $cart=[];
                $status=1;
              } 
              if ($status==1) {
                  // Calculate the total number of distinct items in the cart
                        $totalItems = OrderItems::where('order_id', $request->order_id)
                        ->where('active', 1)
                        ->distinct('product_id')
                        ->count();

                    // Calculate the total price in the cart
                    $totalPrice = OrderItems::where('order_id', $request->order_id)
                        ->where('active', 1)
                        ->sum(DB::raw('Unit_Price * qty'));

                    return response()->json([
                        'success' => true,
                        'message' => 'Cart Item Added!',
                        'cart' => $cart,
                        'total_items' => $totalItems,
                        'total_price' => $totalPrice,
                    ]);
                } else {
                  return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
                }               
            }          
    }
    public function postFocOrderItem(Request $request)
    {
       
        $payload = $request->json()->all();
        $message = "FOC Items Added!";

        $cartItems = [];

        foreach ($payload as $item) {
            $cart = new OrderItems();
            $cart->order_id = $item['order_id'];
            $cart->product_id = $item['product_id'];
            $cart->uom = $item['uom']?? "Pcs";
            $cart->Unit_Price = $item['Unit_Price'] ?? 0;
            $cart->qty = $item['qty'];
            $cart->uom_quantity = $item['qty'];
            $cart->is_foc = $item['is_foc'] ?? 1;
            $cart->foc_promotion_id = $item['foc_promotion_id'];
            $cart->vat = $item['vat'] ?? 0;
            $cart->vat_amt = $item['vat_amt'] ?? 0;
            $cart->total_Price = $item['total_Price'] ?? 0;
            $cart->total_amount = $item['total_amount']  ?? 0;
            $cart->direction = $item['direction'] ?? "CP-RP";
            $cart->active = $item['active'] ?? 1;

            $cart->save();
            $cartItems[] = $cart;
        }

        return response()->json(['message' => $message, 'data' => $cartItems], 201);
    } 

    /**
     * Display the specified resource.
     */
    public function show(OrderItems $orderItems)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, OrderItems $orderItems)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
         // Find the order item by ID
      $ordeItem = OrderItems::find($id);
  
      // Check if the order item exists
      if (!$ordeItem) {
          return response()->json(['message' => 'Order item not found'], 404);
      }
  
      // Delete the order item
      $ordeItem->forcedelete();
  
      return response()->json(['message' => 'Order item deleted'], 200);
    }

    public function getCountOfProductsInCart($user , $customer)
    {
      
            $countWithOrderDetails = OrderItems::join('order_details', 'order_items.order_id', '=', 'order_details.id')
            ->where('order_details.status', 999)
            ->where('order_details.customer_id', $customer)
            ->where('order_details.user_id', $user)
            ->count();

        $countWithCarts = cart::where('cart.active', 1)
            ->where('cart.customer_id', $customer)
            ->where('cart.user_id', $user)            
            ->count();

        $combinedCount = $countWithOrderDetails + $countWithCarts;

        return new JsonResponseArrayResource(true, 'Count of Items In Cart', $combinedCount);
        
       
    }




}
