<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Orderstatus;
use App\Http\Requests\StoreOrderstatusRequest;
use App\Http\Requests\UpdateOrderstatusRequest;
use App\Http\Resources\JsonResponseArrayResource;
use App\Models\CompanyDetail;
use App\Models\OrderDetails;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Http;

class OrderstatusController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function index()
  {
    $orderstatus = Orderstatus::where('active', '=', '1')->get();

    return new JsonResponseArrayResource(
      true,
      'Order Status list',
      $orderstatus
    );
  }

  /**
   * Show the form for creating a new resource.
   */
  public function create()
  {
    //
  }

  /**
   * Store a newly created resource in storage.
   */
  public function store(StoreOrderstatusRequest $request)
  {
    //
  }

  /**
   * Display the specified resource.
   */
  public function show(Orderstatus $orderstatus)
  {
    //
  }

  /**
   * Show the form for editing the specified resource.
   */
  public function edit(Orderstatus $orderstatus)
  {
    //
  }

  /**
   * Update the specified resource in storage.
   */
  public function update(
    UpdateOrderstatusRequest $request,
    Orderstatus $orderstatus
  ) {
    //
  }

  /**
   * Remove the specified resource from storage.
   */
  public function destroy(Orderstatus $orderstatus)
  {
    //
  }

    public function getOrderStatusFromSap($customer)
    {
        //https://172.18.1.61:8001/sap/opu/odata/sap/ZSD_ORDER_DETAILS_GT_SRV_01/OderStatusSet?$filter=ZvInput eq '[{"VBELN":"3009100002"}]'&$format=json

        $orders = OrderDetails::where('customer_id', $customer)
                ->whereIn('Status', [1, 2])
                ->pluck('rp_order_id')
                ->toArray();
                //  $jsonString = json_encode($orders, JSON_PRETTY_PRINT);
                //  echo $jsonString; exit;
        
        
        $options = [];
        if (App::environment('local')) {
        $options = ['verify' => false];
        }
        $json = [];
        foreach ($orders as $order_id) {
            $json[] = [
                "VBELN" => $order_id
            ];
        } 

        $json_to_str = "'" . json_encode($json) . "'";

        $params = [
        '$filter' => 'ZvInput eq  ' . $json_to_str,
        '$format' => 'json',
        ];

        // $username = env('GT_DATA_USERNAME');
        // $password = env('GT_DATA_PASSWORD');
        $company_details = CompanyDetail::where('id', 1)->first();

              $username =  $company_details->sap_user;
              $password = $company_details->sap_password;
        
        $credentials = base64_encode($username . ':' . $password);

        $response = Http::withHeaders([
        'Authorization' => 'Basic ' . $credentials,
        ])
        ->withOptions($options)
        ->get(
            'https://172.18.1.61:8001/sap/opu/odata/sap/ZSD_ORDER_DETAILS_GT_SRV_01/OderStatusSet',
            $params
        ); // https://172.18.1.61:8001 - production link

        
        if (!is_null($response) && isset($response['d']['results'])) {

           foreach ($response['d']['results'] as $result) {
            $rp_order_id = $result['Vbeln'];
            $status = $result['Status'];
 
            if ($status === 'Being Processed') {
                $status = 2;
            } elseif ($status === 'Invoiced') {
                $status = 3;
            }
            
            // Update the Status column in the order_details table
            OrderDetails::where('rp_order_id', $rp_order_id)->update(['Status' => $status]);
        }

          
        return new JsonResponseArrayResource(
            true,
            'Order Status',
            $response['d']['results']
        );
        } else {
        return response()->json('SAP error!', 422);
        }
    }
}
