<?php

namespace App\Http\Controllers\Api;
use App\Models\Payment;
use App\Http\Controllers\Controller;
use App\Http\Requests\StorePaymentRequest;
use App\Http\Requests\UpdatePaymentRequest;
use App\Http\Resources\JsonResponseArrayPaginateResource;
use App\Http\Resources\JsonResponseArrayResource;
use App\Models\PaymentMethod;
use App\Models\PaymentType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class PaymentController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request  $request)
    {
        $payments = payment::leftJoin(
            'customer',
            'payment.customer_id',
            '=',
            'customer.code'
          )->leftJoin(
            'payment_method',
            'payment.payment_mode',
            '=',
            'payment_method.id'
          )->leftJoin(
            'payment_type',
            'payment.payment_type',
            '=',
            'payment_type.id'
          )
          ->select(['payment.*', 'customer.name AS customer_name', 'payment_method.description AS payment_mode_name' ,'payment_type.description AS payment_type_name' ]);

          $cuscode = $request->input('customer');
          $cusname = $request->input('customer_name');
          $fromDate = $request->input('from_date');
          $toDate = $request->input('to_date');

          if ($cuscode !== null && strtolower($cuscode) !== 'null') {
            $payments->where('payment.customer_id', 'like', '%' . $cuscode . '%');
        }
        if ($cusname !== null && strtolower($cusname) !== 'null') {
            $payments->where('customer.name', 'like', '%' . $cusname . '%');
        }
        if ($fromDate !== null && strtolower($fromDate) !== 'null') {
            $payments->where('payment.date', '>=', $fromDate);
        }
        if ($toDate !== null && strtolower($toDate) !== 'null') {
            $payments->where('payment.date', '<=', $toDate);
        }
        $result = $payments->orderBy('payment.date', 'desc')->customPaginate(); 
        return new JsonResponseArrayPaginateResource(true, 'Feedbacks!', $result);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StorePaymentRequest $request)
    {
        $validator = FacadesValidator::make($request->all(), [
            'payment_mode' => 'required',
            'date' => 'required',
            'amount' => 'required', 
            'paid_for' => 'required',
        ]);
    
    if ($validator->fails()) {
        return response()->json($validator->errors(), 422);
    }

    $payment_exit = payment::where('id', $request->id)->first();
    if ($payment_exit) {
        $payment = payment::find($payment_exit->id);
        $message = "payment updated";
         $payment->payment_id = $request->payment_id;
        $payment->customer_id = $request->customer_id;
        $payment->payment_mode = $request->payment_mode;
        $payment->date = $request->date;
        $payment->amount = $request->amount;
        $payment->payment_type = $request->payment_type;
        $payment->paid_for = $request->paid_for;
        $payment->allocation_details = $request->allocation_details;
        $payment->remarks = $request->remarks;
        $payment->rp_receipt_num = $request->rp_receipt_num;
        $payment->transaction_details = $request->transaction_details;
        $payment->status = $request->status ?? 1;
        $payment->payment_doc = $request->payment_doc ?? null;
        $payment->direction = $request->direction ?? "CP-RP";
        $payment->bank_code = $request->bank_code;
        $payment->check_date = $request->check_date;
        $payment->currency = $request->currency;
        if ($payment->update()) {
            return  new  JsonResponseArrayResource(true, $message, $payment);
        } else {
            return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
        }
    } else {
        $payment = new payment();
        $message = "payment Added!";
        $payment->payment_id = $request->payment_id;
        $payment->customer_id = $request->customer_id;
        $payment->payment_mode = $request->payment_mode;
        $payment->date = $request->date;
        $payment->amount = $request->amount;
        $payment->payment_type = $request->payment_type;
        $payment->paid_for = $request->paid_for;
        $payment->allocation_details = $request->allocation_details;
        $payment->remarks = $request->remarks;
        $payment->rp_receipt_num = $request->rp_receipt_num;
        $payment->transaction_details = $request->transaction_details;
        $payment->status = $request->status ?? 1;
        $payment->payment_doc = $request->payment_doc;
        $payment->direction = $request->direction ?? "CP-RP";
        $payment->bank_code = $request->bank_code;
        $payment->check_date = $request->check_date;
        $payment->currency = $request->currency;
        if ($payment->save()) {
            return  new  JsonResponseArrayResource(true, $message, $payment);
        } else {
            return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
        }
    }
    }
    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $payment = payment::where('id', '=', $id)->first();
  
      return new JsonResponseArrayResource(true, 'Payment Details!', $payment);
    }
    public function paymentsByCustomer($customer)
    {
        $payment = payment::where('customer_id', '=', $customer)->orderBy('id', 'desc')->get();
  
        return new JsonResponseArrayResource(true, 'Payment List!', $payment);
    }
    public function paymentsModes()
    {
        $paymentmode = PaymentMethod::get();
  
        return new JsonResponseArrayResource(true, 'Payment Modes!', $paymentmode);
    }
    public function paymentsTypes()
    {
        $paymentmode = PaymentType::get();
  
        return new JsonResponseArrayResource(true, 'Payment Types!', $paymentmode);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Payment $payment)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdatePaymentRequest $request, Payment $payment)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Payment $payment)
    {
        //
    }
}
