<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\ProductCategoryPriceMapping;
use App\Http\Requests\StoreProductCategoryPriceMappingRequest;
use App\Http\Requests\UpdateProductCategoryPriceMappingRequest;
use App\Http\Resources\JsonResponseArrayResource;

class ProductCategoryPriceMappingController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function index()
  {
    //
  }

  /**
   * Show the form for creating a new resource.
   */
  public function create()
  {
    //
  }

  /**
   * Store a newly created resource in storage.
   */
  public function store(StoreProductCategoryPriceMappingRequest $request)
{
    $jsonData = $request->json(); // Assuming you're sending the JSON data in the request
    $successMessages = [];
    $errorMessages = [];

    foreach ($jsonData as $item) {
        $existingRecord = ProductCategoryPriceMapping::where('category_id', $item['category_id'])
            ->where('product_id', $item['product_id'])
            ->first();

        if ($existingRecord) {
            // If a record with the same category_id and product_id exists, update the price.
            $existingRecord->price = $item['price'];
            $existingRecord->depot_code = $item['depot_code'];
            if ($existingRecord->save()) {
                $successMessages[] = "Product Category Price Mapping Updated Successfully";
            } else {
                $errorMessages[] = 'Some Error Occurred';
            }
        } else {
            // If no record exists, create a new one.
            $newRecord = new ProductCategoryPriceMapping();
            $newRecord->category_id = $item['category_id'];
            $newRecord->product_id = $item['product_id'];
            $newRecord->price = $item['price'];
            $newRecord->depot_code = $item['depot_code'];

            if ($newRecord->save()) {
                $successMessages[] = "Product Category Price Mapping Added or Updated Successfully";
            } else {
                $errorMessages[] = 'Some Error Occurred';
            }
        }
    }

    if (count($errorMessages) === 0) {
        return new JsonResponseArrayResource(true, "All Product Category Price Mappings Updated/Added Successfully", []);
    } else {
        return new JsonResponseArrayResource(false, 'Some Error Occurred', 422);
    }
}


  /**
   * Display the specified resource.
   */
  public function show(ProductCategoryPriceMapping $productCategoryPriceMapping)
  {
    //
  }

  /**
   * Show the form for editing the specified resource.
   */
  public function edit(ProductCategoryPriceMapping $productCategoryPriceMapping)
  {
    //
  }

  /**
   * Update the specified resource in storage.
   */
  public function update(
    UpdateProductCategoryPriceMappingRequest $request,
    ProductCategoryPriceMapping $productCategoryPriceMapping
  ) {
    //
  }

  /**
   * Remove the specified resource from storage.
   */
  public function destroy(
    ProductCategoryPriceMapping $productCategoryPriceMapping
  ) {
    //
  }
}
