<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\JsonResponseArrayResource;
use App\Models\Product;
use App\Models\SubCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class ProductController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function index()
  {
    // $products = Product::where('Active', '=', '1')->get();
    // return new JsonResponseArrayResource(true, 'List of Products', $products);
  }
  
  /**
   * Store a newly created resource in storage.
   */
  public function productStoreFromRoutePro(Request $request)
  {
    // //define validation rules
    // $validator = FacadesValidator::make($request->all(), [
    //   'Item_name' => 'required',
    //   'Item_code' => 'required',
    //   'Item_group' => 'required',
    // ]);
    // if ($validator->fails()) {
    //   return response()->json($validator->errors(), 422);
    // }
    // $products = Product::where('Active', '=', '1')
    //   ->where('item_code', '=', $request->Item_code)
    //   ->count();
    // //check if validation fails
    // $product = [
    //   'item_name' => $request->Item_name,
    //   'item_code' => $request->Item_code,
    //   'item_group' => $request->Item_group,
    //   'item_sub_group' => $request->Item_sub_group,
    //   'detailed_desc_en' => $request->detailed_desc_en,
    //   'detailed_desc_ar' => $request->detailed_desc_ar,
    //   'VAT' => $request->VAT ?? 0,
    //   'upc' => $request->UPC ?? 0,
    //   'Active' => $request->Active ?? 1,
    // ];
    // if ($products <= 0) {
    //   $product = Product::create($product);
    //   return new JsonResponseArrayResource(true, 'Product Added!', $product);
    // } else {
    //   $products = Product::where('Active', '=', '1')
    //     ->where('item_code', '=', $request->Item_code)
    //     ->pluck('item_code')
    //     ->toArray();
    //   $productFound = Product::firstOrFail()->where('item_code', $products[0]);
    //   $productFound->update($product);
    //   $order = Product::where('item_code', $products[0])->get();
    //   return new JsonResponseArrayResource(true, 'Product Updated!', $order);
    // }












    // Define validation rules
    $validator = FacadesValidator::make($request->all(), [
      'Item_name' => 'required',
      'Item_code' => 'required',
      'Item_group' => 'required',
  ]);

  if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
  }

  $products = Product::where('item_code', '=', $request->Item_code)
      ->count();

  // Create or update product based on availability
  $productData = [
      'item_name' => $request->Item_name,
      'item_code' => $request->Item_code,
      'item_group' => $request->Item_group,
      'item_sub_group' => $request->Item_sub_group,
      'detailed_desc_en' => $request->detailed_desc_en,
      'detailed_desc_ar' => $request->detailed_desc_ar,
      'VAT' => $request->VAT ?? 0,
      'upc' => $request->UPC ?? 0,
      'Active' => $request->Active ?? 1,
  ];

  if ($products <= 0) {
      $product = Product::create($productData);


      $productSubCategory = SubCategory::where('subcategory', $request->Item_sub_group)->first();

      if ($productSubCategory) {
          // If subcategory exists, update product with existing value
          $productData['item_sub_group'] = $productSubCategory->value;
          $product = Product::where('item_code', '=', $request->Item_code)->firstOrFail();
          $product->update($productData);
      } else {
          // If subcategory does not exist, create a new one and update product
          $uniqueValue =SubCategory::count() + 1; // You can modify this as needed
          $sortOrder = SubCategory::count() + 1;

          $newSubCategory = SubCategory::create([
              'value' => $uniqueValue,
              'subcategory' => $request->Item_sub_group,
              'subcategory_ar' => $request->Item_sub_group,
              'category' => 1,
              'img_url' => null,
              'status' => 1,
              'sort_order' => $sortOrder,
          ]);

          $productData['item_sub_group'] = $newSubCategory->value;
          $product = Product::where('item_code', '=', $request->Item_code)->firstOrFail();
          $product->update($productData);
      }

      
      return new JsonResponseArrayResource(true, 'Product Added!', $product);
  } else {

      $productSubCategory = SubCategory::where('subcategory', $request->Item_sub_group)->first();

      if ($productSubCategory) {
          // If subcategory exists, update product with existing value
          $productData['item_sub_group'] = $productSubCategory->value;
          $product = Product::where('item_code', '=', $request->Item_code)->firstOrFail();
          $product->update($productData);
      } else {
          // If subcategory does not exist, create a new one and update product
          $uniqueValue =SubCategory::count() + 1; // You can modify this as needed
          $sortOrder = SubCategory::count() + 1;

          $newSubCategory = SubCategory::create([
              'value' => $uniqueValue,
              'subcategory' => $request->Item_sub_group,
              'subcategory_ar' => $request->Item_sub_group,
              'category' => 1,
              'img_url' => null,
              'status' => 1,
              'sort_order' => $sortOrder,
          ]);

          $productData['item_sub_group'] = $newSubCategory->value;
          $product = Product::where('item_code', '=', $request->Item_code)->firstOrFail();
          $product->update($productData);
      }

      return new JsonResponseArrayResource(true, 'Product Updated!', $product);
  }



    
  }
  // public function productWithAdditionalDetails(Request $request)
  // {
  //   //define validation rules
  //   $validator = FacadesValidator::make($request->all(), [
  //     'Item_name' => 'required',
  //     'Item_code' => 'required',
  //     'Item_group' => 'required',
  //   ]);
  //   if ($validator->fails()) {
  //     return response()->json($validator->errors(), 422);
  //   }
  //   $products = Product::where('Active', '=', '1')
  //     ->where('item_code', '=', $request->Item_code)
  //     ->count();
  //   //check if validation fails
  //   $product = [
  //     'item_name' => $request->Item_name,
  //     'item_code' => $request->Item_code,
  //     'item_group' => $request->Item_group,
  //     'item_sub_group' => $request->Item_sub_group,
  //     'detailed_desc_en' => $request->detailed_desc_en,
  //     'detailed_desc_ar' => $request->detailed_desc_ar,
  //     'main_depot_name'=> $request->Main_depot_name,
  //     'item_tax_group'=> $request->Item_TaxGroup,
  //     'VAT' => $request->VAT ?? 0,
  //     'upc' => $request->UPC ?? 0,
  //     'Active' => $request->Active ?? 1,
  //   ];
  //   if ($products <= 0) {
  //     $product = Product::create($product);
  //     return new JsonResponseArrayResource(true, 'Product Added!', $product);
  //   } else {
  //     $products = Product::where('Active', '=', '1')
  //       ->where('item_code', '=', $request->Item_code)
  //       ->pluck('item_code')
  //       ->toArray();
  //     $productFound = Product::firstOrFail()->where('item_code', $products[0]);
  //     $productFound->update($product);
  //     $order = Product::where('item_code', $products[0])->get();
  //     return new JsonResponseArrayResource(true, 'Product Updated!', $order);
  //   }
  // }
  public function productWithAdditionalDetails(Request $request)
  {
    //define validation rules
    $validator = FacadesValidator::make($request->all(), [
      'Item_name' => 'required',
      'Item_code' => 'required',
      'Main_depot_name' => 'required',
    ]);
    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }
    $product_exit = Product::where('item_code', '=', $request->Item_code)->where('main_depot_name', '=', $request->Main_depot_name)
      ->first();
      

      if ($product_exit) {
        $product = Product::where('item_code', '=', $request->Item_code)->where('main_depot_name', '=', $request->Main_depot_name)
        ->first();
        $message = "Product updated"; 
         $product->item_name = $request->Item_name;
         $product->item_code = $request->Item_code;
         $product->item_group = $request->Item_group;
         $product->price = $request->Price;
         $product->item_sub_group = $request->Item_sub_group;
         $product->detailed_desc_en = $request->detailed_desc_en;
         $product->detailed_desc_ar = $request->detailed_desc_ar;
         $product->main_depot_name = $request->Main_depot_name;
         $product->item_tax_group = $request->Item_TaxGroup;
         $product->VAT = $request->VAT ?? 0;
         $product->upc = $request->UPC ?? 0;
         $product->Active = $request->Active ?? 1;
        
  
        if ($product->update()) {
          return new JsonResponseArrayResource(true, $message, $product);
        } else {
          return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
        }
      } else {
        $product = new Product();
        $message = "Product Added!";
        $product->item_name = $request->Item_name;
         $product->item_code = $request->Item_code;
         $product->item_group = $request->Item_group;
         $product->price = $request->Price;
         $product->item_sub_group = $request->Item_sub_group;
         $product->detailed_desc_en = $request->detailed_desc_en;
         $product->detailed_desc_ar = $request->detailed_desc_ar;
         $product->main_depot_name = $request->Main_depot_name;
         $product->item_tax_group = $request->Item_TaxGroup;
         $product->VAT = $request->VAT ?? 0;
         $product->upc = $request->UPC ?? 0;
         $product->Active = $request->Active ?? 1;
         
        if ($product->save()) {
          return new JsonResponseArrayResource(true, $message, $product);
        } else {
          return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
        }
      }

 
  }

  public function show($id)
  {
    $products = Product::where('Active', '=', '1')
      ->where('id', '=', $id)
      ->get();
    return new JsonResponseArrayResource(true, 'Single Product!', $products);
  }
}
