<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\JsonResponseArrayResource;
use App\Models\cart;
use App\Models\Customer;
use App\Models\OrderItems;
use App\Models\ProductUomCustomerMappingModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Product;
use App\Models\ProductImage;
use Carbon\Carbon;

class ProductUomByCustomerIdController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function getByPriceUom($cust_id, $product_id)
  {
    $customer_price_group_id = Customer::where('code', '=', $cust_id)->first();

    $products = ProductUomCustomerMappingModel::leftJoin(
      'product',
      'product_uom_customer_mapping.product_id',
      '=',
      'product.item_code'
    )
      ->leftJoin(
        'uom_master',
        'product_uom_customer_mapping.product_uom',
        '=',
        'uom_master.uom_code'
      )
      ->where(
        'product_uom_customer_mapping.pricegroup_id',
        '=',
        $customer_price_group_id['pricegroup_id']
      )
      ->where('product_uom_customer_mapping.Is_active', '=', "1")
      ->where('product_uom_customer_mapping.to_date', '>', date("Y-m-d H:i:s"))
      ->where(
        'product_uom_customer_mapping.from_date',
        '<',
        date("Y-m-d H:i:s")
      )
      ->where('product.Active', '=', '1')
      ->where('product.item_code', '=', $product_id)
      ->where('product_uom_customer_mapping.Is_active', '=', '1')
      ->where(
        'product_uom_customer_mapping.pricegroup_id',
        '=',
        $customer_price_group_id['pricegroup_id']
      )
      ->select([
        'product.item_code AS item_code',
        'uom_master.name AS name',
        'product_uom_customer_mapping.price AS price',
      ])
      ->get();
    return new JsonResponseArrayResource(
      true,
      'Uom for product item code ' . $product_id,
      $products
    );
  }

  public function getProductByCustomer($id, $productid, Request $request)
  {
    $customer = Customer::where('code', $id)->first();

    if ($customer) {
      $pricegroupId = $customer->pricegroup_id;
      // Now $pricegroupId contains the pricegroup_id for the customer with the specified ID.
    }
    $products = ProductUomCustomerMappingModel::with([
      'ProductImage' => function ($query) use ($productid) {
        $query
          ->select(
            'product_id', // This is required if this key is the foreign key
            'file_path'
          )
          ->where('product_id', $productid)
          ->where('Is_active', '=', '1')
          ->orderBy('updated_at', "desc")
          ->take(3);
        return $query;
      },
      'ProductUom' => function ($query) use ($productid, $pricegroupId) {
        $query
          ->select(
            'product_id', // This is required if this key is the foreign key
            'product_uom',
            'customer',
            'price',
            'display_name',
            'name'
          )

          ->leftJoin("uom_master", function ($join) {
            $join->on(
              "product_uom_customer_mapping.product_uom",
              "=",
              "uom_master.uom_code"
            );
          })
          ->where('product_uom_customer_mapping.product_id', $productid)
          ->where('product_uom_customer_mapping.Is_active', '=', '1')
          ->where('product_uom_customer_mapping.pricegroup_id', $pricegroupId);
        return $query;
      },
    ])

      ->leftJoin("product", function ($join) {
        $join->on(
          "product_uom_customer_mapping.product_id",
          "=",
          "product.item_code"
        );
      })

      ->leftJoin("product_category_master", function ($join) {
        $join->on("product.item_group", "=", "product_category_master.value");
      })
      ->leftJoin("product_sub_category_master", function ($join) {
        $join->on(
          "product.item_sub_group",
          "=",
          "product_sub_category_master.value"
        );
      })
      ->leftJoin("tax_masters", function ($join) {
        $join->on("tax_masters.id", "=", "product.item_tax_group");
      })
      ->leftJoin("tax_details", function ($join) {
        $join->on("tax_masters.tax_key", "=", "tax_details.tax_key");
      })

      ->leftJoin('order_items', function ($join) use ($id) {
        $join
          ->on(
            'product_uom_customer_mapping.product_id',
            '=',
            'order_items.product_id'
          )
          ->where('order_items.uom', '!=', 'Pcs')
          ->join('order_details', function ($join) use ($id) {
            $join
              ->on('order_items.order_id', '=', 'order_details.id')
              ->where('order_details.customer_id', '=', $id)
              ->where('order_details.Status', '=', 999);
          });
      })
      ->leftJoin('cart', function ($join) use ($id) {
        $join
          ->on(
            'cart.product_id',
            '=',
            'product_uom_customer_mapping.product_id'
          )
          ->where('cart.active', '=', 1)
          ->where('cart.uom', '!=', 'Pcs')
          ->where('cart.customer_id', '=', $id);
      })

      ->leftJoin('order_items as pcs_order_items', function ($join) use ($id) {
        $join
          ->on(
            'product_uom_customer_mapping.product_id',
            '=',
            'pcs_order_items.product_id'
          )
          ->where('pcs_order_items.uom', '=', 'Pcs')
          ->join('order_details as pcs_order_details', function ($join) use (
            $id
          ) {
            $join
              ->on('pcs_order_items.order_id', '=', 'pcs_order_details.id')
              ->where('pcs_order_details.customer_id', '=', $id)
              ->where('pcs_order_details.Status', '=', 999);
          });
      })
      ->leftJoin('cart as pcs_cart', function ($join) use ($id) {
        $join
          ->on(
            'pcs_cart.product_id',
            '=',
            'product_uom_customer_mapping.product_id'
          )
          ->where('pcs_cart.active', '=', 1)
          ->where('pcs_cart.uom', '=', 'Pcs')
          ->where('pcs_cart.customer_id', '=', $id);
      })

      ->where("product_uom_customer_mapping.Is_active", "=", 1)
      ->where("product.Active", "=", 1)
      ->where("product_uom_customer_mapping.pricegroup_id", '=', $pricegroupId)
      ->where("product_uom_customer_mapping.product_id", '=', $productid)

      ->select(
        "product.item_name as item_name",
        "product.detailed_desc_en as detailed_desc_en",
        "product.detailed_desc_ar as detailed_desc_ar",
        "product.thumbnail_product_image as thumbnail_product_image",
        "product_uom_customer_mapping.product_id as product_id",
        "product_category_master.category_name as category_name",
        "product_category_master.category_name_ar as category_name_ar",
        "product_sub_category_master.subcategory as subcategory",
        "product_sub_category_master.subcategory_ar as subcategory_ar",
        "product.VAT as vat",
        "product.upc as upc",
        DB::raw('IFNULL(order_items.qty, cart.qty) AS case_qty'),
        DB::raw('IFNULL(pcs_order_items.qty, pcs_cart.qty) AS pcs_qty')
      );
    $result = $products->first();
    if ($result) {
      foreach ($result->ProductUom as &$uom) {
        $uom->existing_qty = $this->getExistingQty(
          $id,
          $productid,
          $uom->display_name
        );
      }

      return new JsonResponseArrayResource(true, 'product details ', $result);
    } else {
      return new JsonResponseArrayResource(
        false,
        'product customer combination not found',
        400
      );
    }
  }

  private function getExistingQty($customerId, $productId, $uom)
  {
    // Assuming you have models for order_items and cart tables, adjust them according to your actual model names
    $orderItemsQty = OrderItems::whereHas('orderDetail', function (
      $query
    ) use ($customerId) {
      $query->where('customer_id', $customerId)->where('Status', 999);
    })
      ->where('product_id', $productId)
      ->where('uom', $uom)
      ->sum('qty');

    $cartQty = cart::where('product_id', $productId)
      ->where('uom', $uom)
      ->where('active', 1)
      ->where('customer_id', $customerId)
      ->sum('qty');

    // Sum the quantities from order_items and cart
    $existingQty = $orderItemsQty + $cartQty;

    return $existingQty;
  }

  public function getProductByCustomerAndUser(
    $user,
    $id,
    $productid,
    Request $request
  ) {
    $customer = Customer::where('code', $id)->first();

    if ($customer) {
      $pricegroupId = $customer->pricegroup_id;
      // Now $pricegroupId contains the pricegroup_id for the customer with the specified ID.
    }
    $products = ProductUomCustomerMappingModel::with([
      'ProductImage' => function ($query) use ($productid) {
        $query
          ->select(
            'product_id', // This is required if this key is the foreign key
            'file_path'
          )
          ->where('product_id', $productid)
          ->where('Is_active', '=', '1')
          ->orderBy('updated_at', "desc")
          ->take(3);
        return $query;
      },
      'ProductUom' => function ($query) use ($productid, $pricegroupId) {
        $query
          ->select(
            'product_id', // This is required if this key is the foreign key
            'product_uom',
            'price',
            'display_name',
            'name',
            // 'upc'
          )

          ->leftJoin("uom_master", function ($join) {
            $join
              ->on(
                "product_uom_customer_mapping.product_uom",
                "=",
                "uom_master.uom_code"
              );
          })
          ->where('product_uom_customer_mapping.product_id', $productid)
          ->where('product_uom_customer_mapping.Is_active', '=', '1')
          ->where('product_uom_customer_mapping.pricegroup_id', $pricegroupId)
          ->where('uom_master.display_in_customer_portal', 1);
        return $query;
      },
    ])

      ->leftJoin("product", function ($join) {
        $join->on(
          "product_uom_customer_mapping.product_id",
          "=",
          "product.item_code"
        );
      })

      ->leftJoin("product_category_master", function ($join) {
        $join->on("product.item_group", "=", "product_category_master.value");
      })
      ->leftJoin("product_sub_category_master", function ($join) {
        $join->on(
          "product.item_sub_group",
          "=",
          "product_sub_category_master.value"
        );
      })
      ->leftJoin("tax_masters", function ($join) {
        $join->on("tax_masters.id", "=", "product.item_tax_group");
      })
      ->leftJoin("tax_details", function ($join) {
        $join->on("tax_masters.tax_key", "=", "tax_details.tax_key");
      })

      ->leftJoin('order_items', function ($join) use ($id, $user) {
        $join
          ->on(
            'product_uom_customer_mapping.product_id',
            '=',
            'order_items.product_id'
          )
          ->where('order_items.uom', '!=', 'Pcs')
          ->join('order_details', function ($join) use ($id, $user) {
            $join
              ->on('order_items.order_id', '=', 'order_details.id')
              ->where('order_details.customer_id', '=', $id)
              ->where('order_details.Status', '=', 999)
              ->where('order_details.user_id', '=', $user);
          });
      })
      ->leftJoin('cart', function ($join) use ($id, $user) {
        $join
          ->on(
            'cart.product_id',
            '=',
            'product_uom_customer_mapping.product_id'
          )
          ->where('cart.active', '=', 1)
          ->where('cart.uom', '!=', 'Pcs')
          ->where('cart.customer_id', '=', $id)
          ->where('cart.user_id', '=', $user);
      })

      ->leftJoin('order_items as pcs_order_items', function ($join) use (
        $id,
        $user
      ) {
        $join
          ->on(
            'product_uom_customer_mapping.product_id',
            '=',
            'pcs_order_items.product_id'
          )
          ->where('pcs_order_items.uom', '=', 'Pcs')
          ->join('order_details as pcs_order_details', function ($join) use (
            $id,
            $user
          ) {
            $join
              ->on('pcs_order_items.order_id', '=', 'pcs_order_details.id')
              ->where('pcs_order_details.customer_id', '=', $id)
              ->where('pcs_order_details.Status', '=', 999)
              ->where('pcs_order_details.user_id', '=', $user);
          });
      })
      ->leftJoin('cart as pcs_cart', function ($join) use ($id, $user) {
        $join
          ->on(
            'pcs_cart.product_id',
            '=',
            'product_uom_customer_mapping.product_id'
          )
          ->where('pcs_cart.active', '=', 1)
          ->where('pcs_cart.uom', '=', 'Pcs')
          ->where('pcs_cart.customer_id', '=', $id)
          ->where('cart.user_id', '=', $user);
      })

      ->leftJoin(
        'promotions',
        function ($join) use ($id) {
          $join->on(DB::raw("JSON_CONTAINS(JSON_UNQUOTE(promotions.assign_group), JSON_ARRAY(product.item_code))"), '=', DB::raw('1'))
            ->where('promotions.status', '=', 1)
            ->where('promotions.customer', '=', $id)
            ->whereIn('promotions.promo_type', ['Normal']);   
        },
        'left'
      )
       
      ->where("product_uom_customer_mapping.Is_active", "=", 1)
      ->where("product.Active", "=", 1)
      ->where("product_uom_customer_mapping.pricegroup_id", '=', $pricegroupId)
      ->where("product_uom_customer_mapping.product_id", '=', $productid)
      ->select(
        "product.item_name as item_name",
        "product.detailed_desc_en as detailed_desc_en",
        "product.detailed_desc_ar as detailed_desc_ar",
        "product.thumbnail_product_image as thumbnail_product_image",
        "product_uom_customer_mapping.product_id as product_id",
        "product_category_master.category_name as category_name",
        "product_category_master.category_name_ar as category_name_ar",
        "product_sub_category_master.subcategory as subcategory",
        "product_sub_category_master.subcategory_ar as subcategory_ar",
        "product.VAT as vat",
        "product.upc as upc",
        "product.uom_en as uom_en", 
        "product.uom_ar as uom_ar", 
        DB::raw('IFNULL(order_items.qty, cart.qty) AS case_qty'),
        DB::raw('IFNULL(pcs_order_items.qty, pcs_cart.qty) AS pcs_qty'),

         
        "promotions.promo_value as promo_value",        
        
         
      );
    $result = $products->first();
    if ($result) {

      // echo $result["promo_value"]; exit;

      foreach ($result->ProductUom as &$uom) {
        if($result["promo_value"]){
          $uom->promo_price = number_format($uom->price - ($uom->price*($result["promo_value"]/100)), 2);  
        }
        else{
          $uom->promo_price = null;
        }
        $uom->existing_qty = $this->getExistingQtyUser(
          $user,
          $id,
          $productid,
          $uom->display_name
        );
      }

      return new JsonResponseArrayResource(true, 'product details ', $result);
    } else {
      return new JsonResponseArrayResource(
        false,
        'product customer combination not found',
        400
      );
    }
  }

  private function getExistingQtyUser($user, $customerId, $productId, $uom)
  {
    // Assuming you have models for order_items and cart tables, adjust them according to your actual model names
    $orderItemsQty = OrderItems::whereHas('orderDetail', function (
      $query
    ) use ($user, $customerId) {
      $query
        ->where('customer_id', $customerId)
        ->where('Status', 999)
        ->where('user_id', $user);
    })
      ->where('product_id', $productId)
      ->where('uom', $uom)
      ->sum('qty');

    $cartQty = cart::where('product_id', $productId)
      ->where('uom', $uom)
      ->where('user_id', $user)
      ->where('active', 1)
      ->where('customer_id', $customerId)
      ->sum('qty');

    // Sum the quantities from order_items and cart
    $existingQty = $orderItemsQty + $cartQty;

    return $existingQty;
  }

  //For Nadec

  public function getProductDetailsByCustomer($id, $productid, Request $request)
  {
    $currentDate = Carbon::now();

    $products = Product::leftJoin("product_uom_customer_mapping", function (
      $join
    ) use ($currentDate, $id) {
      $join
        ->on(
          "product.item_code",
          "=",
          "product_uom_customer_mapping.product_id"
        )
        ->where("product_uom_customer_mapping.is_active", "=", 1)
        ->where("product_uom_customer_mapping.customer", '=', $id)
        ->where('product_uom_customer_mapping.from_date', '<=', $currentDate)
        ->where('product_uom_customer_mapping.to_date', '>=', $currentDate)
        ->whereRaw(
          'product_uom_customer_mapping.seqno = 
                    (SELECT MAX(seqno) FROM product_uom_customer_mapping 
                    WHERE product_id = product.item_code
                    AND product_uom_customer_mapping.is_active = 1
                    AND  product_uom_customer_mapping.customer = ' .
            $id .
            '
                    AND product_uom_customer_mapping.from_date <= "' .
            $currentDate .
            '"
                    AND product_uom_customer_mapping.to_date >= "' .
            $currentDate .
            '"
                    )'
        );
    })
      ->leftjoin("customer", function ($join) use ($id) {
        $join
          ->on("product.main_depot_name", "=", "customer.depot_name")
          ->where("customer.code", "=", $id);
      })

      ->leftJoin("product_category_price_mappings", function ($join) {
        $join
          ->on(
            "product_category_price_mappings.product_id",
            "=",
            "product.item_code"
          )
          ->on(
            "product_category_price_mappings.category_id",
            "=",
            "customer.category_name"
          );
      })

      ->leftJoin("product_category_master", function ($join) {
        $join->on("product.item_group", "=", "product_category_master.value");
      })
      ->leftJoin("product_sub_category_master", function ($join) {
        $join->on(
          "product.item_sub_group",
          "=",
          "product_sub_category_master.value"
        );
      })
      ->leftJoin("tax_masters", function ($join) {
        $join->on("tax_masters.id", "=", "product.item_tax_group");
      })
      ->leftJoin("tax_details", function ($join) {
        $join->on("tax_masters.tax_key", "=", "tax_details.tax_key");
      })

      ->leftJoin('order_items', function ($join) use ($id) {
        $join
          ->on('product.item_code', '=', 'order_items.product_id')
          ->where('order_items.uom', '!=', 'Pcs')
          ->join('order_details', function ($join) use ($id) {
            $join
              ->on('order_items.order_id', '=', 'order_details.id')
              ->where('order_details.customer_id', '=', $id)
              ->where('order_details.Status', '=', 999);
          });
      })
      ->leftJoin('cart', function ($join) use ($id) {
        $join
          ->on('cart.product_id', '=', 'product.item_code')
          ->where('cart.active', '=', 1)
          ->where('cart.uom', '!=', 'Pcs')
          ->where('cart.customer_id', '=', $id);
      })

      ->leftJoin('order_items as pcs_order_items', function ($join) use ($id) {
        $join
          ->on('product.item_code', '=', 'pcs_order_items.product_id')
          ->where('pcs_order_items.uom', '=', 'Pcs')
          ->join('order_details as pcs_order_details', function ($join) use (
            $id
          ) {
            $join
              ->on('pcs_order_items.order_id', '=', 'pcs_order_details.id')
              ->where('pcs_order_details.customer_id', '=', $id)
              ->where('pcs_order_details.Status', '=', 999);
          });
      })
      ->leftJoin('cart as pcs_cart', function ($join) use ($id) {
        $join
          ->on('pcs_cart.product_id', '=', 'product.item_code')
          ->where('pcs_cart.active', '=', 1)
          ->where('pcs_cart.uom', '=', 'Pcs')
          ->where('pcs_cart.customer_id', '=', $id);
      })

      ->where("product.active", "=", 1)
      ->where("product.item_code", $productid)
      ->select(
        "product.item_name as item_name",
        "product.item_code as product_id",
        "product.upc as upc",
        "product.detailed_desc_en as detailed_desc_en",
        "product.detailed_desc_ar as detailed_desc_ar",
        "product.thumbnail_product_image as thumbnail_product_image",
        "product_category_master.category_name as category_name",
        "product_category_master.category_name_ar as category_name_ar",
        "product_sub_category_master.subcategory as subcategory",
        "product_sub_category_master.subcategory_ar as subcategory_ar",
        "tax_details.tax_rate as vat",
        DB::raw("
            CASE
                WHEN product_uom_customer_mapping.price IS NOT NULL THEN product_uom_customer_mapping.price
                WHEN product_category_price_mappings.price IS NOT NULL THEN product_category_price_mappings.price
                ELSE product.price
            END AS pcs_price
        "),
        DB::raw("product.upc * 
            CASE
                WHEN product_uom_customer_mapping.price IS NOT NULL THEN product_uom_customer_mapping.price
                WHEN product_category_price_mappings.price IS NOT NULL THEN product_category_price_mappings.price
                ELSE product.price
            END AS case_price"),

        DB::raw('IFNULL(order_items.qty, cart.qty) AS case_qty'),
        DB::raw('IFNULL(pcs_order_items.qty, pcs_cart.qty) AS pcs_qty')
      );
    $result = $products->first();
    if ($result) {
      $prod_images = ProductImage::where('product_id', $productid)
        ->where('Is_active', '=', '1')
        ->orderBy('updated_at', 'desc')
        ->take(3)
        ->get(['product_id', 'file_path']);
      $result->product_image = $prod_images;
    }

    if ($result != null) {
      return new JsonResponseArrayResource(true, 'product details ', $result);
    } else {
      return new JsonResponseArrayResource(
        false,
        'product customer combination not found',
        400
      );
    }
  }

  public function getProductDetailsByCustomerAndUser(
    $user,
    $id,
    $productid,
    Request $request
  ) {
    $currentDate = Carbon::now();

    $products = Product::leftJoin("product_uom_customer_mapping", function (
      $join
    ) use ($currentDate, $id) {
      $join
        ->on(
          "product.item_code",
          "=",
          "product_uom_customer_mapping.product_id"
        )
        ->where("product_uom_customer_mapping.is_active", "=", 1)
        ->where("product_uom_customer_mapping.customer", '=', $id)
        ->where('product_uom_customer_mapping.from_date', '<=', $currentDate)
        ->where('product_uom_customer_mapping.to_date', '>=', $currentDate)
        ->whereRaw(
          'product_uom_customer_mapping.seqno = 
                    (SELECT MAX(seqno) FROM product_uom_customer_mapping 
                    WHERE product_id = product.item_code
                    AND product_uom_customer_mapping.is_active = 1
                    AND  product_uom_customer_mapping.customer = ' .
            $id .
            '
                    AND product_uom_customer_mapping.from_date <= "' .
            $currentDate .
            '"
                    AND product_uom_customer_mapping.to_date >= "' .
            $currentDate .
            '"
                    )'
        );
    })
      ->leftjoin("customer", function ($join) use ($id) {
        $join
          ->on("product.main_depot_name", "=", "customer.depot_name")
          ->where("customer.code", "=", $id);
      })

      ->leftJoin("product_category_price_mappings", function ($join) {
        $join
          ->on(
            "product_category_price_mappings.product_id",
            "=",
            "product.item_code"
          )
          ->on(
            "product_category_price_mappings.category_id",
            "=",
            "customer.category_name"
          );
      })

      ->leftJoin("product_category_master", function ($join) {
        $join->on("product.item_group", "=", "product_category_master.value");
      })
      ->leftJoin("product_sub_category_master", function ($join) {
        $join->on(
          "product.item_sub_group",
          "=",
          "product_sub_category_master.value"
        );
      })
      ->leftJoin("tax_masters", function ($join) {
        $join->on("tax_masters.id", "=", "product.item_tax_group");
      })
      ->leftJoin("tax_details", function ($join) {
        $join->on("tax_masters.tax_key", "=", "tax_details.tax_key");
      })

      ->leftJoin('order_items', function ($join) use ($id, $user) {
        $join
          ->on('product.item_code', '=', 'order_items.product_id')
          ->where('order_items.uom', '!=', 'Pcs')
          ->join('order_details', function ($join) use ($id, $user) {
            $join
              ->on('order_items.order_id', '=', 'order_details.id')
              ->where('order_details.customer_id', '=', $id)
              ->where('order_details.Status', '=', 999)
              ->where('order_details.user_id', '=', $user);
          });
      })
      ->leftJoin('cart', function ($join) use ($id, $user) {
        $join
          ->on('cart.product_id', '=', 'product.item_code')
          ->where('cart.active', '=', 1)
          ->where('cart.uom', '!=', 'Pcs')
          ->where('cart.customer_id', '=', $id)
          ->where('cart.user_id', '=', $user);
      })

      ->leftJoin('order_items as pcs_order_items', function ($join) use (
        $id,
        $user
      ) {
        $join
          ->on('product.item_code', '=', 'pcs_order_items.product_id')
          ->where('pcs_order_items.uom', '=', 'Pcs')
          ->join('order_details as pcs_order_details', function ($join) use (
            $id,
            $user
          ) {
            $join
              ->on('pcs_order_items.order_id', '=', 'pcs_order_details.id')
              ->where('pcs_order_details.customer_id', '=', $id)
              ->where('pcs_order_details.Status', '=', 999)
              ->where('pcs_order_details.user_id', '=', $user);
          });
      })
      ->leftJoin('cart as pcs_cart', function ($join) use ($id, $user) {
        $join
          ->on('pcs_cart.product_id', '=', 'product.item_code')
          ->where('pcs_cart.active', '=', 1)
          ->where('pcs_cart.uom', '=', 'Pcs')
          ->where('pcs_cart.customer_id', '=', $id)
          ->where('pcs_cart.user_id', '=', $user);
      })

      ->where("product.active", "=", 1)
      ->where("product.item_code", $productid)
      ->select(
        "product.item_name as item_name",
        "product.item_code as product_id",
        "product.upc as upc",
        "product.detailed_desc_en as detailed_desc_en",
        "product.detailed_desc_ar as detailed_desc_ar",
        "product.thumbnail_product_image as thumbnail_product_image",
        "product_category_master.category_name as category_name",
        "product_category_master.category_name_ar as category_name_ar",
        "product_sub_category_master.subcategory as subcategory",
        "product_sub_category_master.subcategory_ar as subcategory_ar",
        "tax_details.tax_rate as vat",
        DB::raw("
            CASE
                WHEN product_uom_customer_mapping.price IS NOT NULL THEN product_uom_customer_mapping.price
                WHEN product_category_price_mappings.price IS NOT NULL THEN product_category_price_mappings.price
                ELSE product.price
            END AS pcs_price
        "),
        DB::raw("product.upc * 
            CASE
                WHEN product_uom_customer_mapping.price IS NOT NULL THEN product_uom_customer_mapping.price
                WHEN product_category_price_mappings.price IS NOT NULL THEN product_category_price_mappings.price
                ELSE product.price
            END AS case_price"),

        DB::raw('IFNULL(order_items.qty, cart.qty) AS case_qty'),
        DB::raw('IFNULL(pcs_order_items.qty, pcs_cart.qty) AS pcs_qty')
      );
    $result = $products->first();
    if ($result) {
      $prod_images = ProductImage::where('product_id', $productid)
        ->where('Is_active', '=', '1')
        ->orderBy('updated_at', 'desc')
        ->take(3)
        ->get(['product_id', 'file_path']);
      $result->product_image = $prod_images;
    }

    if ($result != null) {
      return new JsonResponseArrayResource(true, 'product details ', $result);
    } else {
      return new JsonResponseArrayResource(
        false,
        'product customer combination not found',
        400
      );
    }
  }
}
