<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\JsonResponseArrayPaginateResource;
use App\Http\Resources\JsonResponseArrayResource;
use App\Models\ProductUomCustomerMappingModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator as FacadesValidator;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Http;
use Carbon\Carbon;
use App\Models\CompanyDetail;
use App\Models\Customer;
use App\Models\User;
use App\Jobs\DataMappingJob;
use App\Jobs\DataMappingJobForNadec;

class ProductUomCustomerMappingModelController extends Controller
{

  public function getByPriceGroup($id, $customer, Request $request)
  {
    $products = ProductUomCustomerMappingModel::leftJoin(
      'product',
      'product_uom_customer_mapping.product_id',
      '=',
      'product.item_code'
    )
      ->leftJoin(
        'uom_master',
        'product_uom_customer_mapping.product_uom',
        '=',
        'uom_master.uom_code'
      )
      ->leftJoin(
        'product_category_master',
        'product.item_group',
        '=',
        'product_category_master.value'
      )
      ->leftJoin(
        'product_sub_category_master',
        'product.item_sub_group',
        '=',
        'product_sub_category_master.value'
      )
      ->leftJoin(
        'promotions',
        function ($join) use ($customer) {
          $join->on(DB::raw("JSON_CONTAINS(JSON_UNQUOTE(promotions.assign_group), JSON_ARRAY(product.item_code))"), '=', DB::raw('1'))
            ->where('promotions.status', '=', 1)
            ->where('promotions.customer', '=', $customer)
            ->whereIn('promotions.promo_type', ['Normal']);   
        },
        'left'
      )
      ->leftJoin('promotions as slabpromotions', function ($join) use ($customer) {
        $join->on(DB::raw("JSON_CONTAINS(JSON_UNQUOTE(slabpromotions.assign_group), JSON_ARRAY(product.item_code))"), '=', DB::raw('1'))
            ->where('slabpromotions.status', '=', '1')
            ->where('slabpromotions.customer', '=', $customer)
            ->whereIn('slabpromotions.promo_type', ['SLABPROMO']);
      })

      ->leftJoin('order_items', function ($join) use ($customer) {
          $join->on('product.item_code', '=', 'order_items.product_id')
              ->where('order_items.uom', '!=', 'Pcs')         
              ->join('order_details', function ($join) use ($customer) {
                  $join->on('order_items.order_id', '=', 'order_details.id')
                      ->where('order_details.customer_id', '=', $customer)
                      ->where('order_details.Status', '=', 999);
              });         
      })    

      ->leftJoin('cart', function ($join) use ($customer) {
        $join->on('cart.product_id', '=', 'product.item_code')
            ->where('cart.active', '=', 1)
            ->where('cart.uom', '!=', 'Pcs')
            ->where('cart.customer_id', '=', $customer);
      })

      ->where('product_uom_customer_mapping.pricegroup_id', '=', $id)
      ->where('product_uom_customer_mapping.Is_active', '=', "1")
      ->where('product_uom_customer_mapping.to_date', '>', date("Y-m-d H:i:s"))
      ->where(
        'product_uom_customer_mapping.from_date',
        '<',
        date("Y-m-d H:i:s")
      )
      ->where('product.Active', '=', '1')
      ->where('uom_master.display_in_customer_portal', '=', '1')
      //->where('Is_active', '=', '1')
      // ->where('pricegroup_id', '=', $id)
      // ->where('product_sub_category_master.status', '=', '1')
      // ->where('product_category_master.status', '=', '1')
      ->select([
        'product.item_code AS item_code',
        'product.item_name AS item_name',
        'product.detailed_desc_en AS detailed_desc_en',
        'product.detailed_desc_ar AS detailed_desc_ar',
        'product.thumbnail_product_image AS thumbnail_product_image',
        'product.VAT AS vat',
        'product_uom_customer_mapping.pricegroup_id AS customer_price_group_id',
        'uom_master.display_name AS uom_name',
        'product_uom_customer_mapping.product_id AS product_id',
        'product_uom_customer_mapping.price AS price',
        'product_category_master.category_name AS category_name',
        'product_category_master.category_name_ar AS category_name_ar',
        'product_sub_category_master.subcategory AS subcategory',
        'product_sub_category_master.subcategory_ar AS subcategory_ar',  
         DB::raw('CASE WHEN slabpromotions.promo_type = "SLABPROMO" AND slabpromotions.id IS NOT NULL THEN 1 ELSE 0 END AS promotion_status'),        
         DB::raw('CASE WHEN promotions.promo_type = "Normal" AND promotions.id IS NOT NULL THEN round (product_uom_customer_mapping.price - (product_uom_customer_mapping.price*(promotions.promo_value/100)),2) ELSE NULL END AS promo_price'),
         DB::raw('IFNULL(order_items.uom, cart.uom) AS existing_uom'),
         DB::raw('IFNULL(order_items.qty, cart.qty) AS existing_qty')
      ]);

    if ($request->s) {
        // Search for both product name and code
        $products->where(function ($query) use ($request) {
          $query->where('product.item_name', 'like', '%' . $request->s . '%')
              ->orWhere('product.item_code', 'like', '%' . $request->s . '%');
      });
    }
    if ($request->cat) {
      $products->where(
        'product_category_master.category_name',
        'like',
        '%' . $request->cat . '%'
      );
    }
    
    if ($request->sub_cat) {     
      $subCategories=explode(",",$request->sub_cat);      
      $products->whereIn('product_sub_category_master.value', $subCategories);
    }     

    $products->orderBy('product.item_code');
    
    $products->distinct()->get();

    $result = $products->customPaginate();
    return new JsonResponseArrayPaginateResource(true, 'product list!', $result);
  }

  //*****Mayar product listing
  public function getByPriceGroupAndUser($user,$id, $customer, Request $request){
      //Save promotions     
      $currentDate = Carbon::now()->toDateString();
      //$user = auth()->user();
      $user_data = User::where('id', '=', $user)
                    ->first();
      $customer_codes=json_decode($user_data->branches);
      $customerCodesWithoutPromotion = Customer::whereDate('promotion_updated_on','<>', $currentDate)              
              ->whereIn('code', $customer_codes)
              ->pluck('code');  
              
    if ($customerCodesWithoutPromotion->isNotEmpty()) { 
            DataMappingJob::dispatch($user_data,$customerCodesWithoutPromotion);
    }
  
    $products = ProductUomCustomerMappingModel::leftJoin(
      'product',
      'product_uom_customer_mapping.product_id',
      '=',
      'product.item_code'
    )
      ->leftJoin(
        'uom_master',
        'product_uom_customer_mapping.product_uom',
        '=',
        'uom_master.uom_code'
      )
      ->leftJoin(
        'product_category_master',
        'product.item_group',
        '=',
        'product_category_master.value'
      )
      ->leftJoin(
        'product_sub_category_master',
        'product.item_sub_group',
        '=',
        'product_sub_category_master.value'
      )
      ->leftJoin(
        'promotions',
        function ($join) use ($customer) {
          $join->on(DB::raw("JSON_CONTAINS(JSON_UNQUOTE(promotions.assign_group), JSON_ARRAY(product.item_code))"), '=', DB::raw('1'))
            ->where('promotions.status', '=', 1)
            ->where('promotions.customer', '=', $customer)
            ->whereIn('promotions.promo_type', ['Normal']);   
        },
        'left'
      )
      ->leftJoin('promotions as slabpromotions', function ($join) use ($customer) {
        $join->on(DB::raw("JSON_CONTAINS(JSON_UNQUOTE(slabpromotions.assign_group), JSON_ARRAY(product.item_code))"), '=', DB::raw('1'))
            ->where('slabpromotions.status', '=', '1')
            ->where('slabpromotions.customer', '=', $customer)
            ->whereIn('slabpromotions.promo_type', ['SLABPROMO']);
      })
      ->leftJoin('order_items', function ($join) use ($customer, $user) {
          $join->on('product.item_code', '=', 'order_items.product_id')
              ->where('order_items.uom', '!=', 'Pcs')         
              ->join('order_details', function ($join) use ($customer, $user) {
                  $join->on('order_items.order_id', '=', 'order_details.id')
                      ->where('order_details.customer_id', '=', $customer)
                      ->where('order_details.Status', '=', 999) 
                      ->where('order_details.user_id', '=', $user);
              });         
      })  
      ->leftJoin('cart', function ($join) use ($customer, $user) {
        $join->on('cart.product_id', '=', 'product.item_code')
            ->where('cart.active', '=', 1)
            ->where('cart.uom', '!=', 'Pcs')
            ->where('cart.customer_id', '=', $customer) 
            ->where('cart.user_id', '=',  $user);
      })

      ->where('product_uom_customer_mapping.pricegroup_id', '=', $id)
      ->where('product_uom_customer_mapping.Is_active', '=', "1")
      ->where('product_uom_customer_mapping.to_date', '>', date("Y-m-d H:i:s"))
      ->where(
        'product_uom_customer_mapping.from_date',
        '<',
        date("Y-m-d H:i:s")
      )
      ->where('product.Active', '=', '1')
      ->where('uom_master.display_in_customer_portal', '=', '1')
      //->where('Is_active', '=', '1')
      // ->where('pricegroup_id', '=', $id)
      // ->where('product_sub_category_master.status', '=', '1')
      // ->where('product_category_master.status', '=', '1')
      ->select([
        'product.item_code AS item_code',
        'product.item_name AS item_name',
        'product.detailed_desc_en AS detailed_desc_en',
        'product.detailed_desc_ar AS detailed_desc_ar',
        'product.thumbnail_product_image AS thumbnail_product_image',
        'product.VAT AS vat',
        'product.uom_en AS uom_en',
        'product.uom_ar AS uom_ar',
        "product.seq as seq", 
        'product_uom_customer_mapping.pricegroup_id AS customer_price_group_id',
        'uom_master.display_name AS uom_name',
        'product_uom_customer_mapping.product_id AS product_id',
        'product_uom_customer_mapping.price AS price',
        'product_category_master.category_name AS category_name',
        'product_category_master.category_name_ar AS category_name_ar',
        'product_sub_category_master.subcategory AS subcategory',
        'product_sub_category_master.subcategory_ar AS subcategory_ar',  
         DB::raw('CASE WHEN slabpromotions.promo_type = "SLABPROMO" AND slabpromotions.id IS NOT NULL THEN 1 ELSE 0 END AS promotion_status'),        
         DB::raw('CASE WHEN promotions.promo_type = "Normal" AND promotions.id IS NOT NULL THEN round (product_uom_customer_mapping.price - (product_uom_customer_mapping.price*(promotions.promo_value/100)),2) ELSE NULL END AS promo_price'),
         DB::raw('IFNULL(order_items.uom, cart.uom) AS existing_uom'),
         DB::raw('IFNULL(order_items.qty, cart.qty) AS existing_qty')
      ]);
      

    if ($request->s) {
        // Search for both product name and code
        $products->where(function ($query) use ($request) {
          $query->where('product.item_name', 'like', '%' . $request->s . '%')
              ->orWhere('product.item_code', 'like', '%' . $request->s . '%');
      });
    }
    if ($request->cat) {
      $products->where(
        'product_category_master.category_name',
        'like',
        '%' . $request->cat . '%'
      );
    }
    
    if ($request->sub_cat) {     
      $subCategories=explode(",",$request->sub_cat);      
      $products->whereIn('product_sub_category_master.value', $subCategories);
    }         
    $products->orderBy('product.seq'); 
    $products->distinct()->get();
    $result = $products->customPaginate();  

    return new JsonResponseArrayPaginateResource(true, 'product list!', $result);
  }

public function getByCustomerID($id, Request $request)
{   
    if($request->cat){
      $cat=$request->cat;
    }
    else{
      $cat=0;
    }

    if($request->sub_cat){
      $sub_cat=$request->sub_cat;
    }
    else{
      $sub_cat=0;
    }

    if($request->per_page){
      $per_page=$request->per_page;
    }
    else{
      $per_page=20;
    }

    if($request->page){
      $page=$request->page;
    }
    else{
      $page=1;
    }
    if($request->search){
      $search=$request->search;
    }
    else{
      $search= 0;
    }
    $options = [];
    if (App::environment('local')) {
      $options = ['verify' => false];
    }
    $url = 'https://salesproapidev.azurewebsites.net/B2BItem/top-products/'.$id.'/'.$per_page.'/'.$page.'/'.$cat.'/'.$sub_cat.'/'.$search;    
   
    $response = Http::timeout(500)->withOptions($options)->get($url, [
          'headers' => [
              'Content-Type' => 'application/json',
          ],
      ]);  
      if ($response->successful()) {
          $result = $response->json();         
      } else {
          $errorMessage = $response->body();
          return response()->json(['error' => $errorMessage], $response->status());
      }
    
  $item_codes=[]; 
  if (isset($result["B2BITM"])) {      
    foreach ($result["B2BITM"] as $item) {
      $item_codes[]= $item["product_code"];
    }
  }  
  $currentDate = Carbon::now(); 

  $products =  DB::table("product")
      ->leftJoin("product_uom_customer_mapping", function ($join) use ($currentDate, $id) {
          $join->on("product.item_code", "=", "product_uom_customer_mapping.product_id")
              ->where("product_uom_customer_mapping.is_active", "=", 1)
              ->where("product_uom_customer_mapping.customer", '=', $id)
              ->where('product_uom_customer_mapping.from_date', '<=', $currentDate)
              ->where('product_uom_customer_mapping.to_date', '>=', $currentDate)               
              ->whereRaw('product_uom_customer_mapping.seqno = 
                        (SELECT MAX(seqno) FROM product_uom_customer_mapping 
                        WHERE product_id = product.item_code
                        AND product_uom_customer_mapping.is_active = 1
                        AND  product_uom_customer_mapping.customer = '.$id.'
                        AND product_uom_customer_mapping.from_date <= "'.$currentDate.'"
                        AND product_uom_customer_mapping.to_date >= "'.$currentDate.'"
                        )');
      })
      /*
      ->leftJoin("uom_master", function ($join) {
          $join->on(
              "product_uom_customer_mapping.product_uom",
              "=",
              "uom_master.uom_code"
          )
          ->where("uom_master.display_in_customer_portal", "=", 1);
      })
      */
    ->leftJoin("product_category_master", function ($join) {
      $join->on("product.item_group", "=", "product_category_master.value");
    })
    ->leftJoin("product_sub_category_master", function ($join) {
      $join->on(
        "product.item_sub_group",
        "=",
        "product_sub_category_master.value"
      );
    })
    ->leftJoin("tax_masters", function ($join) {
      $join->on("tax_masters.id", "=", "product.item_tax_group");
    })
    ->leftJoin("tax_details", function ($join) {
      $join->on("tax_masters.tax_key", "=", "tax_details.tax_key");
    })      
    ->join("customer", function ($join) use ($id){
      $join->on(
          "product.main_depot_name",
          "=",
          "customer.depot_name"
      )
      ->where("customer.code", "=", $id);
    }) 
    
    ->leftJoin("product_category_price_mappings", function ($join) {
      $join->on("product_category_price_mappings.product_id", "=", "product.item_code")
           ->on("product_category_price_mappings.category_id", "=", "customer.category_name");
    }) 
        
    ->leftJoin('promotions', function ($join) use ($id) {
      $join->on(DB::raw("JSON_CONTAINS(JSON_UNQUOTE(promotions.assign_group), JSON_ARRAY(product.item_code))"), '=', DB::raw('1'))
          ->where('promotions.status', '=', '1')
          ->where('promotions.customer', '=', $id);
    })

    ->leftJoin('order_items', function ($join) use ($id) {
      $join->on('product.item_code', '=', 'order_items.product_id')
          ->where('order_items.uom', '=', 'Pcs')         
          ->join('order_details', function ($join) use ($id) {
              $join->on('order_items.order_id', '=', 'order_details.id')
                  ->where('order_details.customer_id', '=', $id)
                  ->where('order_details.Status', '=', 999);
          });         
  })    

  ->leftJoin('cart', function ($join) use ($id) {
    $join->on('cart.product_id', '=', 'product.item_code')
        ->where('cart.active', '=', 1)
        ->where('cart.uom', '=', 'Pcs')
        ->where('cart.customer_id', '=', $id);
  })

  ->select(
      "product.item_code as item_code",
      "product.item_name as item_name",
      "product.detailed_desc_en as detailed_desc_en",
      "product.detailed_desc_ar as detailed_desc_ar",
      "product.thumbnail_product_image as thumbnail_product_image",
      "tax_details.tax_rate as vat",
      "product_uom_customer_mapping.pricegroup_id as customer_price_grouop_id",
     // "uom_master.display_name as uom_name",        
       DB::raw("'Pcs' as uom_name"),
      "product.item_code as product_id",
      //"product_uom_customer_mapping.price as price",
      "product_category_master.category_name as category_name",
      "product_category_master.category_name_ar as category_name_ar",
      "product_sub_category_master.subcategory as subcategory",
      "product_sub_category_master.subcategory_ar as subcategory_ar",               
      DB::raw("
          CASE
              WHEN product_uom_customer_mapping.price IS NOT NULL THEN product_uom_customer_mapping.price
              WHEN product_category_price_mappings.price IS NOT NULL THEN product_category_price_mappings.price
              ELSE product.price
          END AS price
      "),      
      DB::raw("
            CASE
                WHEN promotions.id IS NOT NULL THEN 1
                ELSE 0
            END AS promotion_status
        "),

      DB::raw('IFNULL(order_items.uom, cart.uom) AS existing_uom'),
      DB::raw('IFNULL(order_items.qty, cart.qty) AS existing_qty')
      
    )  
    ->where("product.active", "=", 1)
    ->whereIn("product.item_code",  $item_codes);

    
    
  if ($request->s) {
    $products->where('product.item_name', 'like', '%' . $request->s . '%');
  }

  if ($request->start_date) {
    $products->where(
      "product_uom_customer_mapping.from_date",
      ">=",
      $request->start_date
    );
  }
  if ($request->end_date) {
    $products->where(
      "product_uom_customer_mapping.to_date",
      "<=",
      $request->end_date
    );
  }
  /*
  if ($request->cat) {
    $products->where(
      'product_category_master.category_name',
      'like',
      '%' . $request->cat . '%'
    );
  }
  if ($request->sub_cat) {
    $products->where(
      'product_sub_category_master.subcategory',
      'like',
      '%' . $request->sub_cat . '%'
    );
  }    
 */
  $result = $products->distinct()->get();
  
  $result = $result->sortBy(function ($product) use ($item_codes) {
    return array_search($product->item_code, $item_codes);
  })->values();
  
  $message = "product list";
  return new JsonResponseArrayResource(true, $message, $result);
}

//Nadec product listing latest
  public function getByCustomerIDandUser($user,$id, Request $request){
     //Save promotions
      $currentDate = Carbon::now()->toDateString();
      //$user = auth()->user();
      $user_data = User::where('id', '=', $user)
                    ->first();
      $customer_codes=json_decode($user_data->branches);
      $customerCodesWithoutPromotion = Customer::whereDate('promotion_updated_on','<>', $currentDate)              
              ->whereIn('code', $customer_codes)
              ->pluck('code');  
           
    if ($customerCodesWithoutPromotion->isNotEmpty()) { 
        DataMappingJobForNadec::dispatch($user_data,$customerCodesWithoutPromotion);
    }
    
      if($request->cat){
        $cat=$request->cat;
      }
      else{
        $cat=0;
      }

      if($request->sub_cat){
        $sub_cat=$request->sub_cat;
      }
      else{
        $sub_cat=0;
      }

      if($request->per_page){
        $per_page=$request->per_page;
      }
      else{
        $per_page=20;
      }

      if($request->page){
        $page=$request->page;
      }
      else{
        $page=1;
      }
      if($request->search){
        $search=$request->search;
      }
      else{
        $search= 0;
      }

      $options = [];
      if (App::environment('local')) {
        $options = ['verify' => false];
      }

      $url = 'https://salesproapidev.azurewebsites.net/B2BItem/top-products/'.$id.'/'.$per_page.'/'.$page.'/'.$cat.'/'.$sub_cat.'/'.$search;    
     
      $response = Http::timeout(500)->withOptions($options)->get($url, [
            'headers' => [
                'Content-Type' => 'application/json',
            ],
        ]);  
        if ($response->successful()) {
            $result = $response->json();         
        } else {
            $errorMessage = $response->body();
            return response()->json(['error' => $errorMessage], $response->status());
        }
      
    $item_codes=[]; 
    if (isset($result["B2BITM"])) {      
      foreach ($result["B2BITM"] as $item) {
        $item_codes[]= $item["product_code"];
      }
    }  
    $currentDate = Carbon::now(); 

    $products =  DB::table("product")
        ->leftJoin("product_uom_customer_mapping", function ($join) use ($currentDate, $id) {
            $join->on("product.item_code", "=", "product_uom_customer_mapping.product_id")
                ->where("product_uom_customer_mapping.is_active", "=", 1)
                ->where("product_uom_customer_mapping.customer", '=', $id)
                ->where('product_uom_customer_mapping.from_date', '<=', $currentDate)
                ->where('product_uom_customer_mapping.to_date', '>=', $currentDate)               
                ->whereRaw('product_uom_customer_mapping.seqno = 
                          (SELECT MAX(seqno) FROM product_uom_customer_mapping 
                          WHERE product_id = product.item_code
                          AND product_uom_customer_mapping.is_active = 1
                          AND  product_uom_customer_mapping.customer = '.$id.'
                          AND product_uom_customer_mapping.from_date <= "'.$currentDate.'"
                          AND product_uom_customer_mapping.to_date >= "'.$currentDate.'"
                          )');
        })
        /*
        ->leftJoin("uom_master", function ($join) {
            $join->on(
                "product_uom_customer_mapping.product_uom",
                "=",
                "uom_master.uom_code"
            )
            ->where("uom_master.display_in_customer_portal", "=", 1);
        })
        */
      ->leftJoin("product_category_master", function ($join) {
        $join->on("product.item_group", "=", "product_category_master.value");
      })
      ->leftJoin("product_sub_category_master", function ($join) {
        $join->on(
          "product.item_sub_group",
          "=",
          "product_sub_category_master.value"
        );
      })
      ->leftJoin("tax_masters", function ($join) {
        $join->on("tax_masters.id", "=", "product.item_tax_group");
      })
      ->leftJoin("tax_details", function ($join) {
        $join->on("tax_masters.tax_key", "=", "tax_details.tax_key");
      })      
      ->join("customer", function ($join) use ($id){
        $join->on(
            "product.main_depot_name",
            "=",
            "customer.depot_name"
        )
        ->where("customer.code", "=", $id);
      }) 
      
      ->leftJoin("product_category_price_mappings", function ($join) {
        $join->on("product_category_price_mappings.product_id", "=", "product.item_code")
             ->on("product_category_price_mappings.category_id", "=", "customer.category_name");
      }) 
          
      ->leftJoin('promotions', function ($join) use ($id) {
        $join->on(DB::raw("JSON_CONTAINS(JSON_UNQUOTE(promotions.assign_group), JSON_ARRAY(product.item_code))"), '=', DB::raw('1'))
            ->where('promotions.status', '=', '1')
            ->where('promotions.customer', '=', $id);
      })

      ->leftJoin('order_items', function ($join) use ($id,$user) {
        $join->on('product.item_code', '=', 'order_items.product_id')
            ->where('order_items.uom', '=', 'Pcs')         
            ->join('order_details', function ($join) use ($id,$user) {
                $join->on('order_items.order_id', '=', 'order_details.id')
                    ->where('order_details.customer_id', '=', $id)
                    ->where('order_details.Status', '=', 999) 
                    ->where('order_details.user_id', '=', $user);
            });         
    })    

    ->leftJoin('cart', function ($join) use ($id,$user) {
      $join->on('cart.product_id', '=', 'product.item_code')
          ->where('cart.active', '=', 1)
          ->where('cart.uom', '=', 'Pcs')
          ->where('cart.customer_id', '=', $id) 
          ->where('cart.user_id', '=', $user);
    })

    ->select(
        "product.item_code as item_code",
        "product.item_name as item_name",
        "product.detailed_desc_en as detailed_desc_en",
        "product.detailed_desc_ar as detailed_desc_ar",
        "product.thumbnail_product_image as thumbnail_product_image",
        "tax_details.tax_rate as vat",
        "product_uom_customer_mapping.pricegroup_id as customer_price_grouop_id",
       // "uom_master.display_name as uom_name",        
         DB::raw("'Pcs' as uom_name"),
        "product.item_code as product_id",
        //"product_uom_customer_mapping.price as price",
        "product_category_master.category_name as category_name",
        "product_category_master.category_name_ar as category_name_ar",
        "product_sub_category_master.subcategory as subcategory",
        "product_sub_category_master.subcategory_ar as subcategory_ar",               
        DB::raw("
            CASE
                WHEN product_uom_customer_mapping.price IS NOT NULL THEN product_uom_customer_mapping.price
                WHEN product_category_price_mappings.price IS NOT NULL THEN product_category_price_mappings.price
                ELSE product.price
            END AS price
        "),      
        DB::raw("
              CASE
                  WHEN promotions.id IS NOT NULL THEN 1
                  ELSE 0
              END AS promotion_status
          "),

        DB::raw('IFNULL(order_items.uom, cart.uom) AS existing_uom'),
        DB::raw('IFNULL(order_items.qty, cart.qty) AS existing_qty')
        
      )  
      ->where("product.active", "=", 1)
      ->whereIn("product.item_code",  $item_codes);

      
      
    if ($request->s) {
      $products->where('product.item_name', 'like', '%' . $request->s . '%');
    }

    if ($request->start_date) {
      $products->where(
        "product_uom_customer_mapping.from_date",
        ">=",
        $request->start_date
      );
    }
    if ($request->end_date) {
      $products->where(
        "product_uom_customer_mapping.to_date",
        "<=",
        $request->end_date
      );
    }
    /*
    if ($request->cat) {
      $products->where(
        'product_category_master.category_name',
        'like',
        '%' . $request->cat . '%'
      );
    }
    if ($request->sub_cat) {
      $products->where(
        'product_sub_category_master.subcategory',
        'like',
        '%' . $request->sub_cat . '%'
      );
    }    
   */
    $result = $products->distinct()->get();
    
    $result = $result->sortBy(function ($product) use ($item_codes) {
      return array_search($product->item_code, $item_codes);
    })->values();   
    
    $message = "product list";
    return new JsonResponseArrayResource(true, $message, $result);
  }

  public function getPromotionProductsByCustomerIDandUser($user,$id, Request $request)
  {   
      if($request->cat){
        $cat=$request->cat;
      }
      else{
        $cat=0;
      }

      if($request->sub_cat){
        $sub_cat=$request->sub_cat;
      }
      else{
        $sub_cat=0;
      }

      if($request->per_page){
        $per_page=$request->per_page;
      }
      else{
        $per_page=20;
      }

      if($request->page){
        $page=$request->page;
      }
      else{
        $page=1;
      }
      if($request->search){
        $search=$request->search;
      }
      else{
        $search= 0;
      }

      $options = [];
      if (App::environment('local')) {
        $options = ['verify' => false];
      }

      $url = 'http://salesproapidev.azurewebsites.net/B2BItem/PromoItems/'.$id.'/'.$page;    
     
      $response = Http::timeout(500)->withOptions($options)->get($url, [
            'headers' => [
                'Content-Type' => 'application/json',
            ],
        ]);  
        if ($response->successful()) {
            $result = $response->json();         
        } else {
            $errorMessage = $response->body();
            return response()->json(['error' => $errorMessage], $response->status());
        }
      
    $item_codes=[]; 
    if (isset($result["B2BITM"])) {      
      foreach ($result["B2BITM"] as $item) {
        $item_codes[]= $item["product_code"];
      }
    }  
    $currentDate = Carbon::now(); 

    $products =  DB::table("product")
        ->leftJoin("product_uom_customer_mapping", function ($join) use ($currentDate, $id) {
            $join->on("product.item_code", "=", "product_uom_customer_mapping.product_id")
                ->where("product_uom_customer_mapping.is_active", "=", 1)
                ->where("product_uom_customer_mapping.customer", '=', $id)
                ->where('product_uom_customer_mapping.from_date', '<=', $currentDate)
                ->where('product_uom_customer_mapping.to_date', '>=', $currentDate)               
                ->whereRaw('product_uom_customer_mapping.seqno = 
                          (SELECT MAX(seqno) FROM product_uom_customer_mapping 
                          WHERE product_id = product.item_code
                          AND product_uom_customer_mapping.is_active = 1
                          AND  product_uom_customer_mapping.customer = '.$id.'
                          AND product_uom_customer_mapping.from_date <= "'.$currentDate.'"
                          AND product_uom_customer_mapping.to_date >= "'.$currentDate.'"
                          )');
        })
        /*
        ->leftJoin("uom_master", function ($join) {
            $join->on(
                "product_uom_customer_mapping.product_uom",
                "=",
                "uom_master.uom_code"
            )
            ->where("uom_master.display_in_customer_portal", "=", 1);
        })
        */
      ->leftJoin("product_category_master", function ($join) {
        $join->on("product.item_group", "=", "product_category_master.value");
      })
      ->leftJoin("product_sub_category_master", function ($join) {
        $join->on(
          "product.item_sub_group",
          "=",
          "product_sub_category_master.value"
        );
      })
      ->leftJoin("tax_masters", function ($join) {
        $join->on("tax_masters.id", "=", "product.item_tax_group");
      })
      ->leftJoin("tax_details", function ($join) {
        $join->on("tax_masters.tax_key", "=", "tax_details.tax_key");
      })      
      ->join("customer", function ($join) use ($id){
        $join->on(
            "product.main_depot_name",
            "=",
            "customer.depot_name"
        )
        ->where("customer.code", "=", $id);
      }) 
      
      ->leftJoin("product_category_price_mappings", function ($join) {
        $join->on("product_category_price_mappings.product_id", "=", "product.item_code")
             ->on("product_category_price_mappings.category_id", "=", "customer.category_name");
      }) 
          
      ->leftJoin('promotions', function ($join) use ($id) {
        $join->on(DB::raw("JSON_CONTAINS(JSON_UNQUOTE(promotions.assign_group), JSON_ARRAY(product.item_code))"), '=', DB::raw('1'))
            ->where('promotions.status', '=', '1')
            ->where('promotions.customer', '=', $id);
      })

      ->leftJoin('order_items', function ($join) use ($id,$user) {
        $join->on('product.item_code', '=', 'order_items.product_id')
            ->where('order_items.uom', '=', 'Pcs')         
            ->join('order_details', function ($join) use ($id,$user) {
                $join->on('order_items.order_id', '=', 'order_details.id')
                    ->where('order_details.customer_id', '=', $id)
                    ->where('order_details.Status', '=', 999) 
                    ->where('order_details.user_id', '=', $user);
            });         
    })    

    ->leftJoin('cart', function ($join) use ($id,$user) {
      $join->on('cart.product_id', '=', 'product.item_code')
          ->where('cart.active', '=', 1)
          ->where('cart.uom', '=', 'Pcs')
          ->where('cart.customer_id', '=', $id) 
          ->where('cart.user_id', '=', $user);
    })

    ->select(
        "product.item_code as item_code",
        "product.item_name as item_name",
        "product.detailed_desc_en as detailed_desc_en",
        "product.detailed_desc_ar as detailed_desc_ar",
        "product.thumbnail_product_image as thumbnail_product_image",
        "tax_details.tax_rate as vat",
        "product_uom_customer_mapping.pricegroup_id as customer_price_grouop_id",
       // "uom_master.display_name as uom_name",        
         DB::raw("'Pcs' as uom_name"),
        "product.item_code as product_id",
        //"product_uom_customer_mapping.price as price",
        "product_category_master.category_name as category_name",
        "product_category_master.category_name_ar as category_name_ar",
        "product_sub_category_master.subcategory as subcategory",
        "product_sub_category_master.subcategory_ar as subcategory_ar",               
        DB::raw("
            CASE
                WHEN product_uom_customer_mapping.price IS NOT NULL THEN product_uom_customer_mapping.price
                WHEN product_category_price_mappings.price IS NOT NULL THEN product_category_price_mappings.price
                ELSE product.price
            END AS price
        "),      
        DB::raw("
              CASE
                  WHEN promotions.id IS NOT NULL THEN 1
                  ELSE 0
              END AS promotion_status
          "),

        DB::raw('IFNULL(order_items.uom, cart.uom) AS existing_uom'),
        DB::raw('IFNULL(order_items.qty, cart.qty) AS existing_qty')
        
      )  
      ->where("product.active", "=", 1)
      ->whereIn("product.item_code",  $item_codes);

      
      
    if ($request->s) {
      $products->where('product.item_name', 'like', '%' . $request->s . '%');
    }

    if ($request->start_date) {
      $products->where(
        "product_uom_customer_mapping.from_date",
        ">=",
        $request->start_date
      );
    }
    if ($request->end_date) {
      $products->where(
        "product_uom_customer_mapping.to_date",
        "<=",
        $request->end_date
      );
    }
    /*
    if ($request->cat) {
      $products->where(
        'product_category_master.category_name',
        'like',
        '%' . $request->cat . '%'
      );
    }
    if ($request->sub_cat) {
      $products->where(
        'product_sub_category_master.subcategory',
        'like',
        '%' . $request->sub_cat . '%'
      );
    }    
   */
    $result = $products->distinct()->get();
    
    $result = $result->sortBy(function ($product) use ($item_codes) {
      return array_search($product->item_code, $item_codes);
    })->values();    
    
    $message = "product list";
    return new JsonResponseArrayResource(true, $message, $result);
  }



  public function postProductUOMCustomerMapping(Request $request)
  {

    $validator = FacadesValidator::make($request->all(), [
      'customer' => 'required',
      'price_key' => 'required',
    ]);

    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }
      $existingProducts = ProductUomCustomerMappingModel::where('customer', $request->customer)
          ->where('pricegroup_id', $request->price_key)
          ->get();
  

      if ($existingProducts->isNotEmpty()) {
          $existingProducts->each(function ($product) {
              $product->forcedelete();
          });
      }
  
      $product = new ProductUomCustomerMappingModel();
      $product->customer = $request->customer;
      $product->pricegroup_id = $request->price_key;
  
      $productPricing = $request->product_pricing;

      
  
      if (is_array($productPricing) && count($productPricing) > 0) {
          foreach ($productPricing as $item ) {
            $newProductPricing = new ProductUomCustomerMappingModel();
            $newProductPricing->product_uom = $item['product_uom'];
            $newProductPricing->UPC = $item['UPC'];
            $newProductPricing->customer = $item['customer'];
              $newProductPricing->price = $item['price'];
              $newProductPricing->product_id = $item['product_id'];
              $newProductPricing->from_date = $item['from_date'];
              $newProductPricing->to_date = $item['to_date'];
              $newProductPricing->Is_active = $item['is_active'] ?? 1;
              $newProductPricing->seqno = $item['seqno'];
              $newProductPricing->direction = $item['direction'] ?? 'RP-CP';
              $newProductPricing->pricegroup_id = $item['price_key'];
  
              // Save each product pricing record
              $newProductPricing->save();
          }
      }
  
      $message = "Product UOM Customer Mapping Added or Updated Successfully";
      return new JsonResponseArrayResource(true, $message, [
        'customer' => $request->customer,
        'price_key' => $request->price_key,
    ]);
  }  
  
  
}
