<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\ProfileEditRequest;
use App\Http\Requests\StoreProfileEditRequestRequest;
use App\Http\Requests\UpdateProfileEditRequestRequest;
use App\Http\Resources\JsonResponseArrayPaginateResource;
use App\Http\Resources\JsonResponseArrayResource;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class ProfileEditRequestController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $editRequests = ProfileEditRequest::leftJoin(
            'customer',
            'profile_edit_requests.customer',
            '=',
            'customer.code'
          )->leftJoin(
            'users',
            'profile_edit_requests.user',
            '=',
            'users.id'
          )->where('profile_edit_requests.active', '=', '1')->select(['profile_edit_requests.*', 'customer.name AS customer_name', 'users.name AS user_name']);

          $fromDate = $request->input('from_date');
          $toDate = $request->input('to_date');

      if ($fromDate !== null && strtolower($fromDate) !== 'null') {
        $editRequests->where('profile_edit_requests.created_at', '>=', $fromDate);
      }
      if ($toDate !== null && strtolower($toDate) !== 'null') {
        $editRequests->where('profile_edit_requests.created_at', '<=', $toDate);
      }
        $result = $editRequests->orderBy('profile_edit_requests.created_at', 'desc')->customPaginate(); 
        return new JsonResponseArrayPaginateResource(true, 'Edit Request List!', $result);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreProfileEditRequestRequest $request)
    {
        $validator = FacadesValidator::make($request->all(), [
            'user' => 'required',
            'customer' => 'required',
                     
        ]);
    
    if ($validator->fails()) {
        return response()->json($validator->errors(), 422);
    }
   
        $profileEditRequest = new ProfileEditRequest();
        $message = "Profile Edit Request Created!";
        $profileEditRequest->user = $request->user;
        $profileEditRequest->customer = $request->customer;
        $profileEditRequest->email = $request->email;
        $profileEditRequest->mobile = $request->mobile;
        $profileEditRequest->company_details = $request->companyDetails;
        $profileEditRequest->others = $request->others;
        $profileEditRequest->viewed = $request->viewed ?? 0;
        $profileEditRequest->completed = $request->completed ?? 0;
        $profileEditRequest->active = $request->active ?? 1;
         
        if ($profileEditRequest->save()) {
            return  new  JsonResponseArrayResource(true, $message, $profileEditRequest);
        } else {
            return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
        }
    
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {


        $editRequest = ProfileEditRequest::where('profile_edit_requests.id', '=', $id)
        ->leftJoin(
            'customer',
            'profile_edit_requests.customer',
            '=',
            'customer.code'
          )->leftJoin(
            'users',
            'profile_edit_requests.user',
            '=',
            'users.id'
          )->where('profile_edit_requests.active', '=', '1')->select(['profile_edit_requests.*', 'customer.name AS customer_name', 'users.name AS user_name'])->first();
 
        return new JsonResponseArrayResource(true, 'Edit Request List!', $editRequest);       
    }



    public function UpdateViewOfProfileEditRequest($id){
        $ProfileEditRequest_exist = ProfileEditRequest::where('id', $id)->first();
        if ($ProfileEditRequest_exist) {
        $ProfileEditRequest = ProfileEditRequest::find($id);
        $ProfileEditRequest->viewed = 1;
        $ProfileEditRequest->update();
        return new JsonResponseArrayResource(true, 'ProfileEditRequest view changed', $ProfileEditRequest);
        }
    }


    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ProfileEditRequest $profileEditRequest)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateProfileEditRequestRequest $request, ProfileEditRequest $profileEditRequest)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ProfileEditRequest $profileEditRequest)
    {
        //
    }
}
