<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Promotion;
use App\Models\Transaction;
use App\Models\OrderDetails;
use App\Http\Resources\JsonResponseArrayPaginateResource;
use App\Http\Resources\JsonResponseArrayResource;
use App\Models\OrderItems;
use App\Models\Product;
use Exception;
use App\Models\cart;
use App\Models\Customer;
//use DB;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator as FacadesValidator;
use Carbon\Carbon;
use App\Models\FocEligibility;
use Illuminate\Support\Facades\Auth;
use App\Models\CompanyDetail;

class PromotionsController extends Controller
{
    public function getPromotion(Request $request)
    {
        //define validation rules
        $validator = FacadesValidator::make($request->all(), [
            'customer' => 'required',
            'order_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        try {

            $promotions = Promotion::where('customer',  $request->customer)->where('promotions.status', 1)->join('promotion_type_master', 'promotions.type', '=', 'promotion_type_master.value')->get(['promotions.id', 'promotions.qual_group', 'promotions.assign_group', 'promotions.range_basis', 'promotions.low', 'promotions.high', 'promotions.rep_range', 'promotions.promo_value', 'promotion_type_master.promotion_type', 'promotion_type_master.short_code', 'promotion_type_master.value', 'promotions.promo_type']);
            
            $company_details = CompanyDetail::where('id', 1)->first('company_shortcode');
            if ($company_details) {
                $company_shortcode=$company_details->company_shortcode;
            }     
            
            $data = [];
            if ($promotions->isNotEmpty()) {
                $allProducts = [];
                foreach ($promotions as $promo) {

                    $productIds = json_decode($promo->qual_group);
                    $assignGroupId = json_decode($promo->assign_group);

                    if ($productIds !== null) {
                        if ($promo->range_basis == 'QA' && !empty($productIds)) {


                            if (is_array($productIds) && count($productIds) > 1) {

                                $order_total_price = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $request->order_id)->sum('total_Price');

                                $flag_1 = 0;
                                if ($order_total_price > $promo->low && $order_total_price < $promo->high && $promo->rep_range == 0) {
                                    $flag_1 = 1;
                                    $promo_value = $promo->promo_value;
                                }
                                if ($order_total_price > $promo->low && $promo->rep_range == 1 && $promo->promo_type == 'SLABPROMO') {
                                    $flag_1 = 1;
                                    if ($promo->low > 0)
                                        $promo_value = $promo->promo_value * intval(($order_total_price / $promo->low));
                                    else
                                        $promo_value = $promo->promo_value;
                                }
                                if ($flag_1 == 1) {
                                    $product_details = Product::whereIn('item_code', $productIds)->get(['item_code', 'item_name']);
                                    $assignGroup_details = Product::whereIn('item_code', $assignGroupId)->get(['item_code', 'item_name']);
                                    $data[] = [
                                        'customer' => $request->customer,
                                        'promotion_id' => $promo->id,
                                        'promotion_value' => $promo_value,
                                        'promotion_type' => $promo->promotion_type,
                                        'promotion_short_code' => $promo->short_code,
                                        'qual_group' => $product_details,
                                        'assign_group' => $assignGroup_details,
                                        'range_basis' => $promo->range_basis,
                                        'low' => $promo->low,
                                        'high' => $promo->high,
                                        'rep_range' => $promo->rep_range,
                                        'promotion_master_value' => $promo->value
                                    ];
                                }
                            } else {
                                $order_total_price = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $request->order_id)->sum('total_Price');

                                if ($promo->rep_range == 0) {
                                    $promo_value = $promo->promo_value;
                                    $products = OrderItems::whereIn('product_id', $productIds)
                                        ->where(function ($query) use ($promo) {
                                            $query->whereRaw(' ? <= total_Price', [$promo->low])
                                                ->WhereRaw('? >= total_Price', [$promo->high]);
                                        })->where('active', 1)->where('order_id', $request->order_id)
                                        ->get();
                                }
                                if ($promo->rep_range == 1 && $promo->promo_type == 'SLABPROMO') {
                                    if ($promo->low > 0)
                                        $promo_value = $promo->promo_value * intval(($order_total_price / $promo->low));
                                    else
                                        $promo_value = $promo->promo_value;

                                    $products = OrderItems::whereIn('product_id', $productIds)
                                        ->where(function ($query) use ($promo) {
                                            $query->whereRaw(' ? <= total_Price', [$promo->low]);
                                        })->where('active', 1)->where('order_id', $request->order_id)
                                        ->get();
                                }

                                if ($products->isNotEmpty()) {

                                    $product_details = Product::whereIn('item_code', $productIds)->get(['item_code', 'item_name']);
                                    $assignGroup_details = Product::whereIn('item_code', $assignGroupId)->get(['item_code', 'item_name']);
                                    $data[] = [
                                        'customer' => $request->customer,
                                        'promotion_id' => $promo->id,
                                        'promotion_value' => $promo_value,
                                        'promotion_type' => $promo->promotion_type,
                                        'promotion_short_code' => $promo->short_code,
                                        'qual_group' => $product_details,
                                        'assign_group' => $assignGroup_details,
                                        'range_basis' => $promo->range_basis,
                                        'low' => $promo->low,
                                        'high' => $promo->high,
                                        'rep_range' => $promo->rep_range,
                                        'promotion_master_value' => $promo->value
                                    ];
                                }
                            }
                        } elseif ($promo->range_basis == 'QQ' && !empty($productIds)) {
                            if ($promo->rep_range == 0) {
                                if($company_shortcode=='MAYAR'){
                                    $products = OrderItems::whereIn('product_id', $productIds)
                                    ->where(function ($query) use ($promo) {
                                        $query->whereRaw('? <= qty', [$promo->low])
                                            ->WhereRaw('? >= qty', [$promo->high]);
                                    })->where('order_id', $request->order_id)
                                    ->get();
                                }
                                else{
                                    $products = OrderItems::whereIn('product_id', $productIds)
                                    ->where(function ($query) use ($promo) {
                                        $query->whereRaw('? <= uom_quantity', [$promo->low])
                                            ->WhereRaw('? >= uom_quantity', [$promo->high]);
                                    })->where('order_id', $request->order_id)
                                    ->get();
                                }                                
                            }
                            if ($promo->rep_range == 1 && $promo->promo_type == 'SLABPROMO') {
                                if($company_shortcode=='MAYAR'){
                                    $products = OrderItems::whereIn('product_id', $productIds)
                                        ->where(function ($query) use ($promo) {
                                            $query->whereRaw('? <= qty', [$promo->low]);
                                        })->where('order_id', $request->order_id)
                                        ->get();
                                }
                                else{
                                    $products = OrderItems::whereIn('product_id', $productIds)
                                    ->where(function ($query) use ($promo) {
                                        $query->whereRaw('? <= uom_quantity', [$promo->low]);
                                    })->where('order_id', $request->order_id)
                                    ->get();
                                }    
                            }
                            if (is_array($productIds) && count($productIds) > 1) {
                                if($company_shortcode=='MAYAR'){
                                    $order_total_qty = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $request->order_id)->sum('qty');
                                }
                                else{
                                    $order_total_qty = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $request->order_id)->sum('uom_quantity');
                                }
                                // if ($products->isNotEmpty()) {
                                $flag_2 = 0;
                                if ($order_total_qty >= $promo->low && $order_total_qty <= $promo->high && $promo->rep_range == 0) {
                                    $flag_2 = 1;
                                    $promo_value = $promo->promo_value;
                                }
                                if ($order_total_qty >= $promo->low && $promo->rep_range == 1 && $promo->promo_type == 'SLABPROMO') {
                                    $flag_2 = 1;
                                    if ($promo->low > 0)
                                        $promo_value = $promo->promo_value * (intval($order_total_qty / $promo->low));
                                    else
                                        $promo_value = $promo->promo_value;
                                }
                                if ($flag_2 == 1) {
                                    $product_details = Product::whereIn('item_code', $productIds)->get(['item_code', 'item_name']);
                                    $assignGroup_details = Product::whereIn('item_code', $assignGroupId)->get(['item_code', 'item_name']);
                                    $data[] = [
                                        'customer' => $request->customer,
                                        'promotion_id' => $promo->id,
                                        'promotion_value' => $promo_value,
                                        'promotion_type' => $promo->promotion_type,
                                        'promotion_short_code' => $promo->short_code,
                                        'qual_group' => $product_details,
                                        'assign_group' => $assignGroup_details,
                                        'range_basis' => $promo->range_basis,
                                        'low' => $promo->low,
                                        'high' => $promo->high,
                                        'rep_range' => $promo->rep_range,
                                        'promotion_master_value' => $promo->value
                                    ];
                                }
                                // }

                            } else {
                                if ($products->isNotEmpty()) {
                                    if($company_shortcode=='MAYAR'){
                                        $order_total_qty = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $request->order_id)->sum('qty');
                                    }
                                    else{
                                        $order_total_qty = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $request->order_id)->sum('uom_quantity');
                                    }
                                    if ($promo->rep_range == 0) {
                                        $promo_value = $promo->promo_value;
                                    } else if ($promo->rep_range == 1 && $promo->promo_type == 'SLABPROMO') {
                                        if ($promo->low > 0)
                                            $promo_value = $promo->promo_value * (intval($order_total_qty / $promo->low));
                                        else
                                            $promo_value = $promo->promo_value;
                                    }
                                    $product_details = Product::whereIn('item_code', $productIds)->get(['item_code', 'item_name']);
                                    $assignGroup_details = Product::whereIn('item_code', $assignGroupId)->get(['item_code', 'item_name']);
                                    $data[] = [
                                        'customer' => $request->customer,
                                        'promotion_id' => $promo->id,
                                        'promotion_value' => $promo_value,
                                        'promotion_type' => $promo->promotion_type,
                                        'promotion_short_code' => $promo->short_code,
                                        'qual_group' => $product_details,
                                        'assign_group' => $assignGroup_details,
                                        'range_basis' => $promo->range_basis,
                                        'low' => $promo->low,
                                        'high' => $promo->high,
                                        'rep_range' => $promo->rep_range,
                                        'promotion_master_value' => $promo->value
                                    ];
                                }
                            }
                        }
                    } else {

                        $invoice_total = OrderItems::where('active', 1)->where('order_id', $request->order_id)->sum('total_Price');

                        if ($invoice_total > $promo->low && $invoice_total < $promo->high) {
                            $data[] = [
                                'customer' => $request->customer,
                                'promotion_id' => $promo->id,
                                'promotion_value' => $promo->promo_value,
                                'promotion_type' => $promo->promotion_type,
                                'promotion_short_code' => $promo->short_code,
                                'qual_group' => [],
                                'assign_group' => [],
                                'range_basis' => $promo->range_basis,
                                'low' => $promo->low,
                                'high' => $promo->high,
                                'rep_range' => $promo->rep_range,
                                'promotion_master_value' => $promo->value
                            ];
                        }
                    }
                }
                // Sort the 'data' array using the custom sorting function
                // usort($data, [$this, 'customSort']);
                return new JsonResponseArrayResource(true, 'Promotion List', $data);
            } else {
                return new JsonResponseArrayResource(true, 'No Promotions available', []);
            }
        } catch (Exception $ex) {

            return new JsonResponseArrayResource(false, $ex->getMessage(), 500);
        }
    }

    function customSort($a, $b)
    {
        return $a['promotion_id'] - $b['promotion_id'];
    }



    public function PromotionCalculations(Request $request)
    {
        //define validation rules
        $validator = FacadesValidator::make($request->all(), [
            'customer' => 'required',
            'order_id' => 'required',
            'promotions' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        try {
            $promotions = $request->promotions;
            $qty = null;
            if (!empty($promotions)) {
                $company_details = CompanyDetail::where('id', 1)->first('company_shortcode');
                if ($company_details) {
                    $company_shortcode=$company_details->company_shortcode;
                }     
               
                $check_transaction = Transaction::where('order_id', $request->order_id)->count();
                if ($check_transaction > 0) {
                    DB::select('CALL UpdationAfterProductChange(?)', [$request->order_id]);
                }

                $success = 0;
                $laPromotions = [];
                $lDPPromotions = [];
                $rounding=$this->getRounding($request->input('orderData.customer_id'));
           
                foreach ($promotions as $promotion) {
                    if ($promotion['promotion_short_code'] === 'LA' || $promotion['promotion_short_code'] === 'LP') {
                        $laPromotions[] = $promotion;
                    } elseif ($promotion['promotion_short_code'] === 'IDP') {
                        $lDPPromotions[] = $promotion;
                    }
                }

                if (!empty($laPromotions)) {
                    foreach ($laPromotions as $promo) {
                        $assign_group = $promo['assign_group'];

                        if (!empty($assign_group)) {
                            $item_code = [];
                            foreach ($assign_group as $group) {
                                // Access and print the "item_code" value for each object in the "assign_group" array
                                $item_code[] = $group['item_code']; // PHP_EOL for line break
                            }
                            $product = OrderItems::whereIn('product_id', $item_code)
                                ->where('active', 1)->where('order_id', $request->order_id)
                                ->get();
                        } else {
                            $product = OrderItems::where('active', 1)->where('order_id', $request->order_id)
                                ->get();
                        }
                        if ($product->isNotEmpty()) {

                            foreach ($product as $prod) {
                                // $check = Transaction::where('product_id', $prod->product_id)->where('la_id', $prod->id)->where('order_id',$request->order_id)->first();
                                if($company_shortcode=='MAYAR'){
                                    $qty = $prod->qty;
                                }
                                else{
                                    $qty = $prod->uom_quantity;
                                }
                                $promotion_value = $promo['promotion_value'];
                                if ($promo['promotion_short_code'] == 'LA') {

                                    $discount = $qty * $promo['promotion_value'];
                                }
                                if ($promo['promotion_short_code'] == 'LP') {

                                    $discount = $prod->total_Price * $promo['promotion_value'] / 100;
                                }
                                $transaction = new Transaction();                              

                                $TransArray = array(
                                    'promo_id' => $promo['promotion_id'],
                                    'product_id' => $prod->product_id,
                                    'la_id' => $prod->id,
                                    'order_id' => $request->order_id,
                                    'discount' => round($discount,$rounding)
                                );
                                //$orderitemsObj->update(array('product_id' =>$prod->product_id,'order_id' => $request->order_id));
                                Transaction::create($TransArray);
                                DB::select('CALL CalculateAndUpdateDiscount(?, ?)', [$request->order_id, $prod->id]);
                                $success = 1;
                            }
                        }
                    }
                }

                if (!empty($lDPPromotions)) {
                    $success = 0;
                    foreach ($lDPPromotions as $promo) {
                        $assign_group = $promo['assign_group'];
                        // product = (unitprice*qty) total_price - litemtotaldiscount = resultamount*promotion_value/100=discount
                        if (!empty($assign_group)) {
                            $item_code = [];
                            foreach ($assign_group as $group) {
                                // Access and print the "item_code" value for each object in the "assign_group" array
                                $item_code[] = $group['item_code']; // PHP_EOL for line break
                            }
                            $product = OrderItems::whereIn('product_id', $item_code)
                                ->where('active', 1)->where('order_id', $request->order_id)
                                ->get();
                        } else {
                            $product = OrderItems::where('active', 1)->where('order_id', $request->order_id)
                                ->get();
                        }
                        if ($product->isNotEmpty()) {
                            foreach ($product as $prod) {
                                $other_total_discount = Transaction::where('la_id', $prod->id)->where('order_id', $request->order_id)->sum('discount');
                                $total_priceArray =  OrderItems::where('id', $prod->id)->where('order_id', $request->order_id)->first();
                                $total_price = $total_priceArray->total_Price;
                                $result_amount = $total_price - $other_total_discount;
                                $discount_amt = $result_amount * $promo['promotion_value'] / 100;

                                $transaction = new Transaction();

                                $TransArray = array(
                                    'promo_id' => $promo['promotion_id'],
                                    'product_id' => $prod->product_id,
                                    'la_id' => $prod->id,
                                    'order_id' => $request->order_id,
                                    'discount' => round($discount_amt,$rounding)
                                );
                                //$orderitemsObj->update(array('product_id' =>$prod->product_id,'order_id' => $request->order_id));
                                Transaction::create($TransArray);

                                // Call the stored procedure with parameters
                                DB::select('CALL CalculateAndUpdateDiscount(?, ?)', [$request->order_id, $prod->id]);
                                $success = 1;
                            }
                        }
                    }
                }


                if ($success == 1) {
                    DB::select('CALL UpdateOrderDetails(?)', [$request->order_id]);

                    return new JsonResponseArrayResource(true, 'Promotions Calculated', []);
                }
            } else {

                return new JsonResponseArrayResource(true, 'Invalid Promotions', []);
            }
        } catch (Exception $ex) {

            return new JsonResponseArrayResource(false, $ex->getMessage(), 500);
        }
    }
    public function PromotionByCustomer($customer)
    {
        $promotions = Promotion::where('customer', $customer)
            ->where('status', 1)
            ->whereIn('promo_type', ['SLABPROMO', 'CASHDISCOU'])
            ->select('qual_group', 'assign_group', 'range_basis', 'low', 'high', 'rep_range', 'promo_type', 'promo_value', 'seq', 'sap_code', 'brand_names', 'type')
            ->get();
    
        // Remove duplicate brands
        $promotions = $this->removeDuplicateBrands($promotions);
    
        return new JsonResponseArrayResource(true, 'promo list', $promotions);
    }
    
    private function removeDuplicateBrands($promotions)
{
    foreach ($promotions as &$promotion) {
        $brandNames = explode(', ', trim($promotion['brand_names'], '()'));

        // Remove duplicates by converting to a set and then back to an array
        $brandNames = array_values(array_unique($brandNames));
        $promotion['brand_names'] = '(' . implode(', ', $brandNames) . ')';
    }

    return $promotions;
}

    //Reset Promotions
    public function ResetPromotionCalculations(Request $request)
    {

        //define validation rules
        $validator = FacadesValidator::make($request->all(), [
            'customer' => 'required',
            'order_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        try {
            $order_id = $request->order_id;
            if (!empty($order_id)) {
                $check_transaction = Transaction::where('order_id', $request->order_id)->count();
                if ($check_transaction > 0) {
                    DB::select('CALL UpdationAfterProductChange(?)', [$request->order_id]);

                    $success = 1;
                } else {
                    $success = 0;
                }
            } else {
                $success = 0;
            }

            if ($success == 1) {
                return new JsonResponseArrayResource(true, 'Promotions Cancelled', []);
            } else {
                return new JsonResponseArrayResource(true, 'No Promotions Found', []);
            }
        } catch (Exception $ex) {

            return new JsonResponseArrayResource(false, $ex->getMessage(), 500);
        }
    }

    public function getPromotionByProduct(Request $request)
    {
        //define validation rules
        $validator = FacadesValidator::make($request->all(), [
            'product_id' => 'required',
            "customer" => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        try {
            $promotions = Promotion::whereJsonContains('qual_group', $request->product_id)
                ->where('promotions.status', 1)
                ->where('promotions.promo_type', 'SLABPROMO')
                ->where('customer', $request->customer)
                ->join('promotion_type_master', 'promotions.type', '=', 'promotion_type_master.value')
                ->get(['promotions.id', 'promotions.from_date', 'promotions.to_date', 'promotions.promo_type', 'promotions.qual_group', 'promotions.assign_group', 'promotions.range_basis', 'promotions.low', 'promotions.high', 'promotions.rep_range', 'promotions.promo_value', 'promotion_type_master.promotion_type', 'promotion_type_master.short_code', 'promotion_type_master.value']);
            $data = [];
            if ($promotions->isNotEmpty()) {
                $allProducts = [];
                foreach ($promotions as $promo) {
                    $productIds = json_decode($promo->qual_group);
                    $assignGroupId = json_decode($promo->assign_group);

                    if ($productIds !== null) {
                        $product_details = Product::whereIn('item_code', $productIds)->get(['item_code', 'item_name']);
                        $assignGroup_details = Product::whereIn('item_code', $assignGroupId)->get(['item_code', 'item_name']);
                        $data[] = [
                            'customer' => $request->customer,
                            'promotion_id' => $promo->id,
                            'promotion_value' => $promo->promo_value,
                            'promotion_type' => $promo->promotion_type,
                            'promotion_short_code' => $promo->short_code,
                            'qual_group' => $product_details,
                            'assign_group' => $assignGroup_details,
                            'range_basis' => $promo->range_basis,
                            'low' => $promo->low,
                            'high' => $promo->high,
                            'rep_range' => $promo->rep_range,
                            'promotion_master_value' => $promo->value,
                            'start_date' => $promo->from_date,
                            'end_date' => $promo->to_date,
                            'promo_type' => $promo->promo_type
                        ];
                    }
                }

                return new JsonResponseArrayResource(true, 'Promotion List', $data);
            } else {
                return new JsonResponseArrayResource(true, 'No Promotions available', []);
            }
        } catch (Exception $ex) {
            return new JsonResponseArrayResource(false, $ex->getMessage(), 500);
        }
    }

    public function getCompletePromotionsByProduct(Request $request)
    {
        //define validation rules
        $validator = FacadesValidator::make($request->all(), [
            'product_id' => 'required',
            "customer" => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        try {
            $promotions = Promotion::whereJsonContains('qual_group', $request->product_id)
                ->where('promotions.status', 1)
                ->where('customer', $request->customer)
                ->join('promotion_type_master', 'promotions.type', '=', 'promotion_type_master.value')
                ->get(['promotions.id', 'promotions.from_date', 'promotions.to_date', 'promotions.promo_type','promotions.sap_code', 'promotions.qual_group',
                 'promotions.assign_group', 'promotions.customer', 'promotions.range_basis', 'promotions.low', 'promotions.high', 'promotions.rep_range', 'promotions.promo_value', 'promotion_type_master.promotion_type', 'promotion_type_master.short_code', 'promotion_type_master.value']);
        
            $groupedPromotions = [];
        
            if ($promotions->isNotEmpty()) {
                foreach ($promotions as $promo) { 
                    $productIds = json_decode($promo->qual_group);
                    $assignGroupId = json_decode($promo->assign_group);
                    $key = $promo->customer . '' . $promo->sap_code . '' . $promo->promo_type . '' . json_encode($promo->qual_group) . '' . json_encode($promo->assign_group) . '_' . $promo->range_basis;
                    
                    if ($productIds !== null) {
                        $product_details = Product::whereIn('item_code', $productIds)->get(['item_code', 'item_name']);
                        $assignGroup_details = Product::whereIn('item_code', $assignGroupId)->get(['item_code', 'item_name']);
                        if (!isset($groupedPromotions[$key])) {
                            $groupedPromotions[$key] = [
                                'customer' => $promo->customer,
                                'promotion_id' => $promo->sap_code,
                                'promotion_internal_id' => $promo->id,
                                'promotion_type' => $promo->promo_type,
                                'promotion_short_code' => $promo->short_code,
                                'qual_group' => $product_details,
                                'assign_group' => $assignGroup_details,
                                'range_basis' => $promo->range_basis,
                                'rep_range' => $promo->rep_range,
                                'promotion_master_value' => $promo->value,
                                'start_date' => $promo->from_date,
                                'end_date' => $promo->to_date,
                                'promo_type' => $promo->promo_type,
                                'ranges' => [],
                            ];
                        }
        
                    $groupedPromotions[$key]['ranges'][] = [
                        'low' => $promo->low,
                        'high' => $promo->high,
                        'promotion_value' => $promo->promo_value,
                    ];
                }
            }
        
                return new JsonResponseArrayResource(true, 'Promotion List', array_values($groupedPromotions));
            } else {
                return new JsonResponseArrayResource(true, 'No Promotions available', []);
            }
        } catch (Exception $ex) {
            return new JsonResponseArrayResource(false, $ex->getMessage(), 500);
        }        
    }
    
    public function storeOrderPromotions(Request $request)
    {
        //define validation rules       
        $validator = FacadesValidator::make($request->all(), [
            'customer_id' => 'required'
        ]);

        if ($validator->fails()) { 
            return response()->json($validator->errors(), 422);
        }
        try {
           
            $customer_id = $request->customer_id;           
            DB::beginTransaction();
            $order_exist = OrderDetails::where('id', $request->id)->first();
            if ($order_exist) {
                $order = OrderDetails::find($order_exist->id);
                $message = "Order Updated";
            } 
            else {
                $order = new OrderDetails();
                $message = "Order Created"; 
                $cart_exit = cart::where('user_id', $request->user_id)
                    ->where('customer_id', $request->customer_id)
                    ->get();
                if ($cart_exit) {
                    foreach ($cart_exit as $cart_item) {
                        $cartitem = cart::find($cart_item->id);
                        $cartitem->active = 2;
                        $cartitem->update();
                    }
                }
            }

            $rounding=$this->getRounding($request->customer_id);
           
            $order->order_date = date('Y-m-d', strtotime(str_replace('-', '/', $request->order_date)));
            $order->po_number = $request->po_number;
            $order->ship_to = $request->ship_to;
            $order->salesman_code = $request->salesman_code;
            $order->sales_man = $request->sales_man;
            $order->delivery_route_code = $request->delivery_route_code;
            $order->delivery_route_name = $request->delivery_route_name;
            $order->customer_id = $request->customer_id;
            $order->Status = $request->Status;
            $order->delivery_rep_name = $request->delivery_rep_name;
            $order->tentative_delivery_date = $request->tentative_delivery_date ?? Carbon::now(); 
            $order->delivery_slot = $request->delivery_slot;
            $order->net_amt = round($request->net_amt,$rounding);
            $order->vat_amt = round($request->vat_amt,$rounding);
            $order->advance_amount = round($request->advance_amount,$rounding);
            $order->remarks = $request->remarks;
            $order->total_order_value = round($request->total_order_value,$rounding);
            $order->direction = $request->direction ?? "CP-RP";
            $order->synced = $request->synced;
            $order->created_timestamp = $request->created_timestamp;
            $order->updated_timestamp = $request->updated_timestamp;
            $order->Is_customer_portal_order = $request->Is_customer_portal_order ?? 1;
            $order->promotion_applied = $request->promotion_applied ?? 0;
            $order->Is_active = $request->Is_active ?? 1;
            $order->user_id = $request->user_id;
           
            if ($order->save()) {
                DB::commit();                 
                $order_id = $order->id;
                if (isset($request->order_details) &&  count($request->order_details) > 0) {
                    if ($order_exist) {
                        OrderItems::where('order_id', $order->id)->forcedelete();
                    }
                    foreach ($request->order_details as $items) {                        
                    if($items['qty'] > 0){
                        $odr_items = new OrderItems();
                        $odr_items->order_id = $order->id;
                        $odr_items->product_id = $items['product_id'];
                        $odr_items->Unit_Price = round($items['Unit_Price'],$rounding);
                        $odr_items->case_Price = isset($items['case_Price']) ? round($items['case_Price'], $rounding) : null; 
                        $odr_items->qty = $items['qty'];
                        $odr_items->total_Price = round($items['total_Price'],$rounding);
                        $odr_items->vat = $items['vat'];
                        $odr_items->vat_amt = round($items['vat_amt'],$rounding);
                        $odr_items->total_amount = round($items['total_amount'],$rounding);
                        $odr_items->active = $items['active'] ?? 1;
                        $odr_items->direction = $items['direction'] ?? "CP-RP";
                        $odr_items->uom = $items['uom'];
                        $odr_items->upc = $items['upc'] ?? null;
                        $odr_items->remarks = $items['remarks'] ?? null;
                        
                        if($items['uom']=='Pcs'){
                            $odr_items->uom_quantity=$items['qty'];
                            $odr_items->uom_price=round($items['Unit_Price'],$rounding);
                        }
                        else{
                            $prod_upc_details=Product::where('item_code', $items['product_id'])->first('upc');
                            $odr_items->uom_quantity=$prod_upc_details->upc * $items['qty']; 
                            if(isset($items['Unit_Price'])){
                                $odr_items->uom_price=round($items['Unit_Price'] / $prod_upc_details->upc,$rounding);
                            }
                            else{
                                $odr_items->uom_price=0;
                            }
                        }

                        if (!$odr_items->save()) {
                            DB::rollback();
                            return new JsonResponseArrayResource(
                                false,
                                "Something went wrong!",
                                500
                            );
                        }
                    }
                    }
                    DB::commit();
                    
                    $order->order_details = OrderItems::where(
                        'order_id',
                        $order->id
                    )->get();
                    
                    //*********Eligible Promotion starts here
                    $order_id = $order->id;

                    $promotions = Promotion::where('customer',  $customer_id)->where('promotions.status', 1)->join('promotion_type_master', 'promotions.type', '=', 'promotion_type_master.value')->get(['promotions.id', 'promotions.qual_group', 'promotions.assign_group', 'promotions.range_basis', 'promotions.low', 'promotions.high', 'promotions.rep_range', 'promotions.promo_value', 'promotion_type_master.promotion_type', 'promotion_type_master.short_code', 'promotion_type_master.value', 'promotions.promo_type', 'promotions.type']);
                    $data = [];
                    if ($promotions->isEmpty()) {
                        return new JsonResponseArrayResource(true, $message, $order);
                    } else {
                        $allProducts = [];
                        $company_details = CompanyDetail::where('id', 1)->first('company_shortcode');
                        if ($company_details) {
                            $company_shortcode=$company_details->company_shortcode;
                        }     
                        
                        foreach ($promotions as $promo) {

                            $productIds = json_decode($promo->qual_group);
                            $assignGroupId = json_decode($promo->assign_group);

                            if ($productIds !== null) {
                                if ($promo->range_basis == 'QA' && !empty($productIds)) {
                                    if (is_array($productIds) && count($productIds) > 1) {
                                        $order_total_price = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $order_id)->sum('total_Price');

                                        $flag_1 = 0;
                                        if ($order_total_price > $promo->low && $order_total_price < $promo->high && $promo->rep_range == 0) {
                                            $flag_1 = 1;
                                            $promo_value = $promo->promo_value;
                                        }
                                        if ($order_total_price > $promo->low && $promo->rep_range == 1 && ($promo->promo_type == 'SLABPROMO' ||  $promo->type == 3) ) {
                                            $flag_1 = 1;
                                            if ($promo->low > 0)
                                                $promo_value = $promo->promo_value * intval(($order_total_price / $promo->low));
                                            else
                                                $promo_value = $promo->promo_value;
                                        }
                                        if ($flag_1 == 1) {
                                            $product_details = Product::whereIn('item_code', $productIds)->get(['item_code', 'item_name']);
                                            $assignGroup_details = Product::whereIn('item_code', $assignGroupId)->get(['item_code', 'item_name']);
                                            $data[] = [
                                                'customer' => $customer_id,
                                                'promotion_id' => $promo->id,
                                                'promotion_value' => $promo_value,
                                                'promotion_type' => $promo->promotion_type,
                                                'promotion_short_code' => $promo->short_code,
                                                'qual_group' => $product_details,
                                                'assign_group' => $assignGroup_details,
                                                'range_basis' => $promo->range_basis,
                                                'low' => $promo->low,
                                                'high' => $promo->high,
                                                'rep_range' => $promo->rep_range,
                                                'promotion_master_value' => $promo->value
                                            ];
                                        }
                                    } else {
                                        $order_total_price = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $request->order_id)->sum('total_Price');

                                        if ($promo->rep_range == 0) {
                                            $promo_value = $promo->promo_value;
                                            $products = OrderItems::whereIn('product_id', $productIds)
                                                ->where(function ($query) use ($promo) {
                                                    $query->whereRaw(' ? <= total_Price', [$promo->low])
                                                        ->WhereRaw('? >= total_Price', [$promo->high]);
                                                })->where('active', 1)->where('order_id', $order_id)
                                                ->get();
                                        }
                                        if ($promo->rep_range == 1 && ($promo->promo_type == 'SLABPROMO' ||  $promo->type == 3)) {
                                            if ($promo->low > 0)
                                                $promo_value = $promo->promo_value * intval(($order_total_price / $promo->low));
                                            else
                                                $promo_value = $promo->promo_value;

                                            $products = OrderItems::whereIn('product_id', $productIds)
                                                ->where(function ($query) use ($promo) {
                                                    $query->whereRaw(' ? <= total_Price', [$promo->low]);
                                                })->where('active', 1)->where('order_id', $order_id)
                                                ->get();
                                        }

                                        if ($products->isNotEmpty()) {

                                            $product_details = Product::whereIn('item_code', $productIds)->get(['item_code', 'item_name']);
                                            $assignGroup_details = Product::whereIn('item_code', $assignGroupId)->get(['item_code', 'item_name']);
                                            $data[] = [
                                                'customer' => $customer_id,
                                                'promotion_id' => $promo->id,
                                                'promotion_value' => $promo_value,
                                                'promotion_type' => $promo->promotion_type,
                                                'promotion_short_code' => $promo->short_code,
                                                'qual_group' => $product_details,
                                                'assign_group' => $assignGroup_details,
                                                'range_basis' => $promo->range_basis,
                                                'low' => $promo->low,
                                                'high' => $promo->high,
                                                'rep_range' => $promo->rep_range,
                                                'promotion_master_value' => $promo->value
                                            ];
                                        }
                                    }
                                } elseif ($promo->range_basis == 'QQ' && !empty($productIds)) {
                                    if ($promo->rep_range == 0) {
                                        if($company_shortcode=='MAYAR'){
                                            $products = OrderItems::whereIn('product_id', $productIds)
                                                ->where(function ($query) use ($promo) {
                                                    $query->whereRaw('? <= qty', [$promo->low])
                                                        ->WhereRaw('? >= qty', [$promo->high]);
                                                })->where('order_id', $order_id)
                                                ->get();
                                        }
                                        else{
                                            $products = OrderItems::whereIn('product_id', $productIds)
                                            ->where(function ($query) use ($promo) {
                                                $query->whereRaw('? <= uom_quantity', [$promo->low])
                                                    ->WhereRaw('? >= uom_quantity', [$promo->high]);
                                            })->where('order_id', $order_id)
                                            ->get();
                                        }    
                                    } 
                                    if ($promo->rep_range == 1 && ($promo->promo_type == 'SLABPROMO' ||  $promo->type == 3)) { 
                                        if($company_shortcode=='MAYAR'){                                        
                                            $products = OrderItems::whereIn('product_id', $productIds)
                                                ->where(function ($query) use ($promo) {
                                                    $query->whereRaw('? <= qty', [$promo->low]);
                                                })->where('order_id', $order_id)
                                                ->get();
                                        }
                                        else{
                                            $products = OrderItems::whereIn('product_id', $productIds)
                                            ->where(function ($query) use ($promo) {
                                                $query->whereRaw('? <= uom_quantity', [$promo->low]);
                                            })->where('order_id', $order_id)
                                            ->get();
                                        }        
                                    }
                                    if (is_array($productIds) && count($productIds) > 1) {
                                        if($company_shortcode=='MAYAR'){
                                            $order_total_qty = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $order_id)->sum('qty');
                                        }
                                        else{
                                            $order_total_qty = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $order_id)->sum('uom_quantity');
                                        }
                                        // if ($products->isNotEmpty()) {
                                        $flag_2 = 0;
                                        if ($order_total_qty >= $promo->low && $order_total_qty <= $promo->high && $promo->rep_range == 0) {
                                            $flag_2 = 1;
                                            $promo_value = $promo->promo_value;
                                        }
                                        if ($order_total_qty >= $promo->low && $promo->rep_range == 1 && ($promo->promo_type == 'SLABPROMO' ||  $promo->type == 3)) {
                                            $flag_2 = 1;
                                            if ($promo->low > 0)
                                                $promo_value = $promo->promo_value * (intval($order_total_qty / $promo->low));
                                            else
                                                $promo_value = $promo->promo_value;
                                        }
                                        if ($flag_2 == 1) {  
                                            $product_details = Product::whereIn('item_code', $productIds)->get(['item_code', 'item_name']);
                                            $assignGroup_details = Product::whereIn('item_code', $assignGroupId)->get(['item_code', 'item_name']);
                                            $data[] = [
                                                'customer' => $customer_id,
                                                'promotion_id' => $promo->id,
                                                'promotion_value' => $promo_value,
                                                'promotion_type' => $promo->promotion_type,
                                                'promotion_short_code' => $promo->short_code,
                                                'qual_group' => $product_details,
                                                'assign_group' => $assignGroup_details,
                                                'range_basis' => $promo->range_basis,
                                                'low' => $promo->low,
                                                'high' => $promo->high,
                                                'rep_range' => $promo->rep_range,
                                                'promotion_master_value' => $promo->value
                                            ];
                                        } 
                                        // }

                                    } else {
                                        if ($products->isNotEmpty()) { 
                                            if($company_shortcode=='MAYAR'){
                                                $order_total_qty = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $order_id)->sum('qty');
                                            }
                                            else{
                                                $order_total_qty = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $order_id)->sum('uom_quantity');
                                            }
                                            if ($promo->rep_range == 0) {
                                                $promo_value = $promo->promo_value;
                                            } 
                                            else if ($promo->rep_range == 1 && ($promo->promo_type == 'SLABPROMO' ||  $promo->type == 3)) { 
                                                if ($promo->low > 0)
                                                    $promo_value = $promo->promo_value * (intval($order_total_qty / $promo->low));
                                                else
                                                    $promo_value = $promo->promo_value;
                                            }
                                            $product_details = Product::whereIn('item_code', $productIds)->get(['item_code', 'item_name']);
                                            $assignGroup_details = Product::whereIn('item_code', $assignGroupId)->get(['item_code', 'item_name']);
                                            $data[] = [
                                                'customer' => $customer_id,
                                                'promotion_id' => $promo->id,
                                                'promotion_value' => $promo_value,
                                                'promotion_type' => $promo->promotion_type,
                                                'promotion_short_code' => $promo->short_code,
                                                'qual_group' => $product_details,
                                                'assign_group' => $assignGroup_details,
                                                'range_basis' => $promo->range_basis,
                                                'low' => $promo->low,
                                                'high' => $promo->high,
                                                'rep_range' => $promo->rep_range,
                                                'promotion_master_value' => $promo->value
                                            ];  
                                        }
                                    }
                                }
                            } else {

                                $invoice_total = OrderItems::where('active', 1)->where('order_id', $order_id)->sum('total_Price');

                                if ($invoice_total > $promo->low && $invoice_total < $promo->high) {
                                    $data[] = [
                                        'customer' => $customer_id,
                                        'promotion_id' => $promo->id,
                                        'promotion_value' => $promo->promo_value,
                                        'promotion_type' => $promo->promotion_type,
                                        'promotion_short_code' => $promo->short_code,
                                        'qual_group' => [],
                                        'assign_group' => [],
                                        'range_basis' => $promo->range_basis,
                                        'low' => $promo->low,
                                        'high' => $promo->high,
                                        'rep_range' => $promo->rep_range,
                                        'promotion_master_value' => $promo->value
                                    ];
                                }
                            }
                        }

                        //   return new JsonResponseArrayResource(true, 'Promotion List', $data);
                        //***********promotion calculations starts here */  

                        $promotions = $data;
                        $qty = null;

                        $check_transaction = Transaction::where('order_id', $order_id)->count();
                        if ($check_transaction > 0) {
                            DB::select('CALL UpdationAfterProductChange(?)', [$order_id]);
                        }

                        if (!empty($promotions)) { 
                            $success = 0;
                            $laPromotions = [];
                            $lDPPromotions = [];
                            $fgPromotions = [];

                            foreach ($promotions as $promotion) {
                                if ($promotion['promotion_short_code'] === 'LA' || $promotion['promotion_short_code'] === 'LP') {
                                    $laPromotions[] = $promotion;
                                } elseif ($promotion['promotion_short_code'] === 'IDP') {
                                    $lDPPromotions[] = $promotion;
                                }
                                elseif ($promotion['promotion_short_code'] === 'FG') { 
                                    $fgPromotions[] = $promotion;
                                }
                            }
                            if (!empty($laPromotions)) {
                                foreach ($laPromotions as $promo) {
                                    $assign_group = $promo['assign_group'];

                                    if (!empty($assign_group)) {
                                        $item_code = [];
                                        foreach ($assign_group as $group) {
                                            // Access and print the "item_code" value for each object in the "assign_group" array
                                            $item_code[] = $group['item_code'];
                                        }

                                        $product = OrderItems::whereIn('product_id', $item_code)
                                            ->where('active', 1)->where('order_id', $order_id)
                                            ->get();
                                    } else {
                                        $product = OrderItems::where('active', 1)->where('order_id', $order_id)
                                            ->get();
                                    }
                                    if ($product->isNotEmpty()) {

                                        foreach ($product as $prod) {
                                            // $check = Transaction::where('product_id', $prod->product_id)->where('la_id', $prod->id)->where('order_id',$request->order_id)->first();
                                            if($company_shortcode=='MAYAR'){
                                                $qty = $prod->qty;
                                            }
                                            else{
                                                $qty = $prod->uom_quantity;
                                            }
                                            $promotion_value = $promo['promotion_value'];
                                            if ($promo['promotion_short_code'] == 'LA') {

                                                $discount = $qty * $promo['promotion_value'];
                                            }
                                            if ($promo['promotion_short_code'] == 'LP') {

                                                $discount = $prod->total_Price * $promo['promotion_value'] / 100;
                                            }
                                            $transaction = new Transaction();

                                            $TransArray = array(
                                                'promo_id' => $promo['promotion_id'],
                                                'product_id' => $prod->product_id,
                                                'la_id' => $prod->id,
                                                'order_id' => $order_id,
                                                'discount' => round($discount,$rounding)
                                            );
                                            //$orderitemsObj->update(array('product_id' =>$prod->product_id,'order_id' => $request->order_id));
                                            Transaction::create($TransArray);
                                            DB::select('CALL CalculateAndUpdateDiscount(?, ?)', [$order_id, $prod->id]);
                                            $success = 1;
                                        }
                                    }
                                }
                            }

                            if (!empty($lDPPromotions)) {
                                $success = 0;
                                foreach ($lDPPromotions as $promo) {
                                    $assign_group = $promo['assign_group'];
                                    // product = (unitprice*qty) total_price - litemtotaldiscount = resultamount*promotion_value/100=discount
                                    if (!empty($assign_group)) {
                                        $item_code = [];
                                        foreach ($assign_group as $group) {
                                            $item_code[] = $group['item_code'];
                                        }
                                        $product = OrderItems::whereIn('product_id', $item_code)
                                            ->where('active', 1)->where('order_id', $order_id)
                                            ->get();
                                    } else {
                                        $product = OrderItems::where('active', 1)->where('order_id', $order_id)
                                            ->get();
                                    }
                                    if ($product->isNotEmpty()) {
                                        foreach ($product as $prod) {
                                            $other_total_discount = Transaction::where('la_id', $prod->id)->where('order_id', $order_id)->sum('discount');
                                            $total_priceArray =  OrderItems::where('id', $prod->id)->where('order_id', $order_id)->first();
                                            $total_price = $total_priceArray->total_Price;
                                            $result_amount = $total_price - $other_total_discount;
                                            $discount_amt = $result_amount * $promo['promotion_value'] / 100;

                                            $transaction = new Transaction();

                                            $TransArray = array(
                                                'promo_id' => $promo['promotion_id'],
                                                'product_id' => $prod->product_id,
                                                'la_id' => $prod->id,
                                                'order_id' => $order_id,
                                                'discount' => round($discount_amt,$rounding)
                                            );

                                            Transaction::create($TransArray);

                                            // Call the stored procedure with parameters
                                            DB::select('CALL CalculateAndUpdateDiscount(?, ?)', [$order_id, $prod->id]);
                                            $success = 1;
                                        }
                                    }
                                }
                            }

                            //Free good promotions need to save
                            if (!empty($fgPromotions)) {                                
                                $success = 0;
                                foreach ($fgPromotions as $promo) {  
                                    $existingPromo = FocEligibility::where('foc_promo_id', $promo['promotion_id'])
                                                        ->where('order_id', $order_id)
                                                        ->first();                                
                                    if ($existingPromo) {         
                                        $existingPromo->update([
                                            'status' => 1,
                                            'rep_range' =>$promo['rep_range'],
                                            'product_count' => $promo['promotion_value'],
                                        ]);
                                    } 
                                    else {                                    
                                            $focArray = array(
                                                'foc_promo_id' => $promo['promotion_id'],
                                                'order_id' => $order_id,                                                
                                                'status' => 1,
                                                'rep_range' =>$promo['rep_range'],
                                                'product_count'=>$promo['promotion_value'],
                                            ); 
                                            FocEligibility::create($focArray);
                                    }        
                                }
                                $success = 1;
                            }

                            if ($success == 1) { 

                                DB::select('CALL UpdateOrderDetails(?)', [$order_id]);
                                $message = 'Order Saved & Promotions Calculated';
                                return new JsonResponseArrayResource(true, $message, $order);
                                // return new JsonResponseArrayResource(true, 'Order Saved & Promotions Calculated',[]);
                            }
                        } else {
                                return new JsonResponseArrayResource(true, $message, $order);
                            //return new JsonResponseArrayResource(true, 'Invalid Promotions', []);
                        }
                    }
                    /*
        else
          {     
        
              return new JsonResponseArrayResource(true,'No Promotions available',[]);            
          }
       */
                    //***********eligible promotion ends here 


                } else {
                   
                //Update order_details                
                OrderDetails::where('customer_id', '=', $order->customer_id)
                            ->where('Status', '=', 999)
                            ->where('id', '=', $order_id)
                            ->update(array('Status' => 0,
                                        'total_order_value'=> 0,
                                        'vat_amt'=> 0,
                                        'net_amt'=> 0,
                                        'advance_amount'=>0,
                                        'total_discount'=>0 ));
               
                return new JsonResponseArrayResource(true, $message, $order);
                    /*
                    return new JsonResponseArrayResource(
                        false,
                        "Something went wrong!",
                        500
                    ); */
                }
            }
        } catch (Exception $ex) {
            DB::rollback();
            return new JsonResponseArrayResource(false, $ex->getMessage(), 500);
        }
    }
   
    //FOC products For nadec
    public function getFocProducts($order_id, Request $request){       
       
        $validator = FacadesValidator::make(['order_id' => $order_id], [
            'order_id' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }

        $check_foc = FocEligibility::where('order_id', $order_id)->count();

        if ($check_foc > 0) {                                            
            $promos = FocEligibility::where('foc_eligibility.status', 1)
                            ->where('order_id', $order_id)
                            ->join('promotions', 'promotions.id', '=', 'foc_eligibility.foc_promo_id')            
                            ->select('foc_promo_id','foc_eligibility.product_count','foc_eligibility.rep_range', 'order_id','promotions.promo_value','promotions.assign_group')
                            ->distinct()
                            ->get();                    
            $data = [];
            
            foreach ($promos as $promo) {              
                $productIds = json_decode($promo->assign_group);                  
                $focData = [];
                if($promo->rep_range == 1){
                    $FOC_product_count=round($promo->product_count,2);
                }
                else{
                    $FOC_product_count=round($promo->promo_value,2);
                }
                foreach ($productIds as $productId) {
                    $product = Product::where('item_code', $productId)->first(['item_code', 'item_name','detailed_desc_ar']);
                    if($product){
                        $focData[] = [
                            'product_id' => $product->item_code,
                            'product_name_en' => $product->item_name,
                            'product_name_ar' => $product->detailed_desc_ar, //arabic name not found
                        ];
                    }
                }            
                $data[] = [
                    'FOC_promo_id' => $promo->foc_promo_id,
                    'FOC_product_count' => $FOC_product_count,  
                    'FOC_products' => $focData,
                ];
            }        
            if ($data != null) {
                return new JsonResponseArrayResource(true,'FOC Products',$data);
            } 
            else {
                return new JsonResponseArrayResource(false, 'Foc Products Not Found', 400);
            }
        }
        else{
            return new JsonResponseArrayResource(false, 'Foc Products Not Found', []);                             
        }
    }

        //Re order - order details and promotions
        public function reorderSubmission($order_id, Request $request){       
       
            $validator = FacadesValidator::make(['order_id' => $order_id], [
                'order_id' => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }   

            $order = OrderDetails::where('order_details.id', $order_id)
                        ->leftjoin('customer', 'customer.code', '=', 'order_details.customer_id')
                        ->first(['order_details.*','customer.name','customer.customer_tax_id']);
                     
        if(!empty($order)){            
            $orderItemDetails = OrderItems::where('order_id', $order_id)->where('is_foc','!=',1)->get();

            $order_details = [];
            foreach($orderItemDetails as $orderItems){
                $order_details[]=
                            [
                                "id" => $orderItems->id,
                                "user_id" => Auth::user()->id ?? null,
                                "customer_id" => $order->customer_id,
                                "product_id" => $orderItems->product_id,
                                "uom" => $orderItems->uom,
                                "unit_price" => $orderItems->Unit_Price,
                                "qty" => $orderItems->qty,
                                "vat" => $orderItems->vat,
                                "active" => $orderItems->active,
                                "Unit_Price" => $orderItems->Unit_Price,
                                "total_Price" => $orderItems->total_Price,
                                "vat_amt" => $orderItems->vat_amt,
                                "total_amount" => $orderItems->total_amount,                                
                                "uom_quantity" => $orderItems->uom_quantity,
                                "uom_price" => $orderItems->uom_price,
                            ];
            }                
            
            $orderData = [
                "id" => null,
                "order_date" => Carbon::now(), 
                "po_number" => $order->po_number,
                "ship_to" => $order->ship_to,
                "salesman_code" => $order->salesman_code,
                "sales_man" => $order->sales_man,
                "delivery_route_code" => $order->delivery_route_code,
                "delivery_route_name" => $order->delivery_route_name,
                "customer_id" => $order->customer_id,
                "Status" => 999, 
                "edit_permission" => 1,
                "delivery_rep_name" => $order->delivery_rep_name,
                "tentative_delivery_date" => $order->tentative_delivery_date,
                "delivery_slot" => $order->delivery_slot,
                "net_amt" => $order->net_amt,
                "vat_amt" => $order->vat_amt,
                "total_discount" => $order->total_discount,
                "advance_amount" => $order->advance_amount,
                "remarks" => $order->remarks,
                "total_order_value" => $order->total_order_value,
                "direction" => $order->direction,
                "synced" => $order->synced,
                "created_timestamp" => Carbon::now() ,
                "updated_timestamp" => Carbon::now() ,
                "rp_order_id" => null,
                "Is_customer_portal_order" => $order->Is_customer_portal_order,
                "promotion_applied" => $order->promotion_applied, 
                "user_id" => $order->user_id ?? null,
                "customer_name" => $order->name, 
                "customer_tax_id" => $order->customer_tax_id, 
                "order_details" => $order_details
                ];                

            $request = new Request(['orderData' => $orderData]);
            $return_data=$this->storeReOrderPromotions($request);
            //var_dump($return_data); exit;
            if ($return_data != null && isset($return_data->resource->id)) {
                $data[] = [
                    'reorder_id' => $return_data->resource->id,   
                ];
                
                return new JsonResponseArrayResource(true,'Reorder ID Created',$data);
            } 
            else {
                return new JsonResponseArrayResource(false, 'Something went wrong!', 400);
            }

        }
        else {
            return new JsonResponseArrayResource(false, 'Something went wrong!', 400);
        }
    }

    public function storeReOrderPromotions(Request $request)
    {
        //define validation rules       
        $validator = FacadesValidator::make($request->all(), [
            'orderData.customer_id' => 'required'
        ]);

        if ($validator->fails()) { 
            return response()->json($validator->errors(), 422);
        }
        try {
            $request->input('orderData.customer_id');
            $customer_id = $request->input('orderData.customer_id');   
               
           // DB::beginTransaction(); 
            $order_exist = OrderDetails::where('id', $request->input('orderData.id'))->first();
            if ($order_exist) {
                $order = OrderDetails::find($order_exist->id);
                $message = "Order Updated";
            } else {
                $order = new OrderDetails();
                $message = "Order Created"; 
                $cart_exit = cart::where('user_id', $request->input('orderData.user_id'))
                    ->where('customer_id', $request->input('orderData.customer_id'))
                    ->get();
                if ($cart_exit) {
                    foreach ($cart_exit as $cart_item) {
                        $cartitem = cart::find($cart_item->id);
                        $cartitem->active = 2;
                        $cartitem->update();
                    }
                }
            }
                  
            $rounding=$this->getRounding($request->input('orderData.customer_id'));
           
            $order = new OrderDetails();
            $order->order_date = Carbon::now(); //?? doubt
            $order->po_number = $request->input('orderData.po_number');
            $order->ship_to = $request->input('orderData.ship_to');
            $order->salesman_code = $request->input('orderData.salesman_code');
            $order->sales_man = $request->input('orderData.sales_man');
            $order->delivery_route_code = $request->input('orderData.delivery_route_code');
            $order->delivery_route_name = $request->input('orderData.delivery_route_name');
            $order->customer_id = $request->input('orderData.customer_id');
            $order->Status = $request->input('orderData.Status'); //?? doubt
            $order->delivery_rep_name = $request->input('orderData.delivery_rep_name');
            $order->tentative_delivery_date = $request->input('orderData.tentative_delivery_date') ?? now(); //?? doubt
            $order->delivery_slot = $request->input('orderData.delivery_slot');           
            $order->net_amt = round($request->input('orderData.net_amt'),$rounding);
            $order->vat_amt =  round($request->input('orderData.vat_amt'),$rounding);
            $order->advance_amount = round($request->input('orderData.advance_amount'),$rounding);
            $order->remarks = $request->input('orderData.remarks');
            $order->total_order_value = round($request->input('orderData.total_order_value'),$rounding);            
            $order->direction = $request->input('orderData.direction') ?? "CP-RP";
            $order->synced = $request->input('orderData.synced');
            $order->created_timestamp = $request->input('orderData.created_timestamp');
            $order->updated_timestamp =  $request->input('orderData.updated_timestamp');
            $order->Is_customer_portal_order =  $request->input('orderData.Is_customer_portal_order') ?? 1;
            $order->promotion_applied =  $request->input('orderData.promotion_applied') ?? 0;  
            $order->Is_active = $request->input('orderData.Is_active') ?? 1;
            $order->user_id = $request->input('orderData.user_id');
           
            if ($order->save()) {
                $order_id = $order->id;  
                //change status of already existing orders into 998
                $check_orders =OrderDetails::where('customer_id', '=', $order->customer_id)->where('Status', '=', 999)->where('id', '!=', $order->id)->update(array('Status' => 998));
           
                if (
                    is_array($request->input('orderData.order_details')) &&
                    count($request->input('orderData.order_details')) > 0
                ) { 
                    if ($order_exist) {
                        OrderItems::where('order_id', $order->id)->forcedelete();
                    }
                   
                    foreach ($request->input('orderData.order_details') as $items) {
                        $odr_items = new OrderItems();
                        $odr_items->order_id = $order->id;
                        $odr_items->product_id = $items['product_id'];
                        $odr_items->Unit_Price = round($items['Unit_Price'],$rounding);
                        $odr_items->case_Price = isset($items['case_Price']) ? round($items['case_Price'], $rounding) : null; 
                        $odr_items->qty = $items['qty'];
                        $odr_items->total_Price = round($items['total_Price'],$rounding);
                        $odr_items->vat = $items['vat'];
                        $odr_items->vat_amt = round($items['vat_amt'],$rounding);
                        $odr_items->total_amount = round($items['total_amount'],$rounding);
                        $odr_items->active = $items['active'] ?? 1;
                        $odr_items->direction = $items['direction'] ?? "CP-RP";
                        $odr_items->uom = $items['uom'];
                        $odr_items->upc = $items['upc'] ?? null;
                        $odr_items->remarks = $items['remarks'] ?? null;
                        $odr_items->uom_quantity=$items['uom_quantity'];
                        $odr_items->uom_price=$items['uom_price'];
                       
                        if (!$odr_items->save()) {  
                            //DB::rollback();
                            return new JsonResponseArrayResource(
                                false,
                                "Something went wrong!",
                                500
                            );
                        }
                    }
                   // DB::commit();
                    $order->order_details = OrderItems::where(
                        'order_id',
                        $order->id
                    )->get();
                    
                    //*********Eligible Promotion starts here
                    $order_id = $order->id;
                    
                    $promotions = Promotion::where('customer',  $customer_id)
                        ->where('promotions.status', 1)
                        ->join('promotion_type_master', 'promotions.type', '=', 'promotion_type_master.value')
                        ->get(['promotions.id', 'promotions.qual_group', 'promotions.assign_group', 'promotions.range_basis', 'promotions.low', 'promotions.high', 'promotions.rep_range', 'promotions.promo_value', 'promotion_type_master.promotion_type', 'promotion_type_master.short_code', 'promotion_type_master.value', 'promotions.promo_type','promotions.type' ]);
                   
                    $data = [];
                    if ($promotions->isEmpty()) { 
                        return new JsonResponseArrayResource(true, $message, $order);
                    } else {   
                        $allProducts = [];
                        $company_details = CompanyDetail::where('id', 1)->first('company_shortcode');
                        if ($company_details) {
                            $company_shortcode=$company_details->company_shortcode;
                        }  

                        foreach ($promotions as $promo) {  
                            $productIds = json_decode($promo->qual_group);
                            $assignGroupId = json_decode($promo->assign_group);
                            if ($productIds !== null) {  
                                if ($promo->range_basis == 'QA' && !empty($productIds)) {  
                                    if (is_array($productIds) && count($productIds) > 1) { 
                                        $order_total_price = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $order_id)->sum('total_Price');

                                        $flag_1 = 0;
                                        if ($order_total_price > $promo->low && $order_total_price < $promo->high && $promo->rep_range == 0) {
                                            $flag_1 = 1;
                                            $promo_value = $promo->promo_value;
                                        }
                                        if ($order_total_price > $promo->low && $promo->rep_range == 1 && ($promo->promo_type == 'SLABPROMO' ||  $promo->type == 3)) {
                                            $flag_1 = 1;
                                            if ($promo->low > 0)
                                                $promo_value = $promo->promo_value * intval(($order_total_price / $promo->low));
                                            else
                                                $promo_value = $promo->promo_value;
                                        }
                                        if ($flag_1 == 1) {
                                            $product_details = Product::whereIn('item_code', $productIds)->get(['item_code', 'item_name']);
                                            $assignGroup_details = Product::whereIn('item_code', $assignGroupId)->get(['item_code', 'item_name']);
                                            $data[] = [
                                                'customer' => $customer_id,
                                                'promotion_id' => $promo->id,
                                                'promotion_value' => $promo_value,
                                                'promotion_type' => $promo->promotion_type,
                                                'promotion_short_code' => $promo->short_code,
                                                'qual_group' => $product_details,
                                                'assign_group' => $assignGroup_details,
                                                'range_basis' => $promo->range_basis,
                                                'low' => $promo->low,
                                                'high' => $promo->high,
                                                'rep_range' => $promo->rep_range,
                                                'promotion_master_value' => $promo->value
                                            ];
                                        }
                                    } else {
                                        $order_total_price = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $request->input('orderData.order_id') )->sum('total_Price');

                                        if ($promo->rep_range == 0) {
                                            $promo_value = $promo->promo_value;
                                            $products = OrderItems::whereIn('product_id', $productIds)
                                                ->where(function ($query) use ($promo) {
                                                    $query->whereRaw(' ? <= total_Price', [$promo->low])
                                                        ->WhereRaw('? >= total_Price', [$promo->high]);
                                                })->where('active', 1)->where('order_id', $order_id)
                                                ->get();
                                        }
                                        if ($promo->rep_range == 1 && ($promo->promo_type == 'SLABPROMO' ||  $promo->type == 3)) {
                                            if ($promo->low > 0)
                                                $promo_value = $promo->promo_value * intval(($order_total_price / $promo->low));
                                            else
                                                $promo_value = $promo->promo_value;

                                            $products = OrderItems::whereIn('product_id', $productIds)
                                                ->where(function ($query) use ($promo) {
                                                    $query->whereRaw(' ? <= total_Price', [$promo->low]);
                                                })->where('active', 1)->where('order_id', $order_id)
                                                ->get();
                                        }
                                     
                                        if ($products->isNotEmpty()) {                                          
                                            $product_details = Product::whereIn('item_code', $productIds)->get(['item_code', 'item_name']);
                                            $assignGroup_details = Product::whereIn('item_code', $assignGroupId)->get(['item_code', 'item_name']);
                                            $data[] = [
                                                'customer' => $customer_id,
                                                'promotion_id' => $promo->id,
                                                'promotion_value' => $promo_value,
                                                'promotion_type' => $promo->promotion_type,
                                                'promotion_short_code' => $promo->short_code,
                                                'qual_group' => $product_details,
                                                'assign_group' => $assignGroup_details,
                                                'range_basis' => $promo->range_basis,
                                                'low' => $promo->low,
                                                'high' => $promo->high,
                                                'rep_range' => $promo->rep_range,
                                                'promotion_master_value' => $promo->value
                                            ];
                                        }
                                    }
                                } 
                                elseif ($promo->range_basis == 'QQ' && !empty($productIds)) {                                                                    
                                    if ($promo->rep_range == 0) { 
                                        if($company_shortcode=='MAYAR'){ 
                                            $products = OrderItems::whereIn('product_id', $productIds)
                                                ->where(function ($query) use ($promo) {
                                                    $query->whereRaw('? <= qty', [$promo->low])
                                                        ->WhereRaw('? >= qty', [$promo->high]);
                                                })->where('order_id', $order_id)
                                                ->get(); 
                                        }           
                                        else{  
                                            $products = OrderItems::whereIn('product_id', $productIds)
                                            ->where(function ($query) use ($promo) {
                                                $query->whereRaw('? <= uom_quantity', [$promo->low])
                                                    ->WhereRaw('? >= uom_quantity', [$promo->high]);
                                            })->where('order_id', $order_id)
                                            ->get();
                                        }                                   
                                    }
                                    if ($promo->rep_range == 1 && ($promo->promo_type == 'SLABPROMO' ||  $promo->type == 3)) {                                       
                                        if($company_shortcode=='MAYAR'){
                                            $products = OrderItems::whereIn('product_id', $productIds)
                                                ->where(function ($query) use ($promo) {
                                                    $query->whereRaw('? <= qty', [$promo->low]);
                                                })->where('order_id', $order_id)
                                                ->get();
                                        }
                                        else{
                                            $products = OrderItems::whereIn('product_id', $productIds)
                                            ->where(function ($query) use ($promo) {
                                                $query->whereRaw('? <= uom_quantity', [$promo->low]);
                                            })->where('order_id', $order_id)
                                            ->get();
                                        }    
                                    } 
                                                                          
                                    if (is_array($productIds) && count($productIds) > 1) {  
                                        if($company_shortcode=='MAYAR'){
                                            $order_total_qty = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $order_id)->sum('qty');
                                        }
                                        else{
                                            $order_total_qty = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $order_id)->sum('uom_quantity');
                                        }
                                        // if ($products->isNotEmpty()) {
                                        $flag_2 = 0;
                                        if ($order_total_qty >= $promo->low && $order_total_qty <= $promo->high && $promo->rep_range == 0) {
                                            $flag_2 = 1;
                                            $promo_value = $promo->promo_value;
                                        }
                                        if ($order_total_qty >= $promo->low && $promo->rep_range == 1 && ($promo->promo_type == 'SLABPROMO' ||  $promo->type == 3)) {
                                            $flag_2 = 1;
                                            if ($promo->low > 0)
                                                $promo_value = $promo->promo_value * (intval($order_total_qty / $promo->low));
                                            else
                                                $promo_value = $promo->promo_value;
                                        }
                                        if ($flag_2 == 1) { 
                                            $product_details = Product::whereIn('item_code', $productIds)->get(['item_code', 'item_name']);
                                            $assignGroup_details = Product::whereIn('item_code', $assignGroupId)->get(['item_code', 'item_name']);
                                            $data[] = [
                                                'customer' => $customer_id,
                                                'promotion_id' => $promo->id,
                                                'promotion_value' => $promo_value,
                                                'promotion_type' => $promo->promotion_type,
                                                'promotion_short_code' => $promo->short_code,
                                                'qual_group' => $product_details,
                                                'assign_group' => $assignGroup_details,
                                                'range_basis' => $promo->range_basis,
                                                'low' => $promo->low,
                                                'high' => $promo->high,
                                                'rep_range' => $promo->rep_range,
                                                'promotion_master_value' => $promo->value
                                            ];
                                        }
                                        // } 
                                        
                                    } 
                                    else { 
                                        if (isset($products)) {  
                                            if ($products->isNotEmpty()) {  
                                                if($company_shortcode=='MAYAR'){
                                                    $order_total_qty = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $order_id)->sum('qty');
                                                }
                                                else{ 
                                                    $order_total_qty = OrderItems::whereIn('product_id', $productIds)->where('active', 1)->where('order_id', $order_id)->sum('uom_quantity');
                                                }
                                                if ($promo->rep_range == 0) {
                                                    $promo_value = $promo->promo_value;
                                                } else if ($promo->rep_range == 1 && ($promo->promo_type == 'SLABPROMO' ||  $promo->type == 3)) {
                                                    if ($promo->low > 0)
                                                        $promo_value = $promo->promo_value * (intval($order_total_qty / $promo->low));
                                                    else
                                                        $promo_value = $promo->promo_value;
                                                }
                                                $product_details = Product::whereIn('item_code', $productIds)->get(['item_code', 'item_name']);
                                                $assignGroup_details = Product::whereIn('item_code', $assignGroupId)->get(['item_code', 'item_name']);
                                                $data[] = [
                                                    'customer' => $customer_id,
                                                    'promotion_id' => $promo->id,
                                                    'promotion_value' => $promo_value,
                                                    'promotion_type' => $promo->promotion_type,
                                                    'promotion_short_code' => $promo->short_code,
                                                    'qual_group' => $product_details,
                                                    'assign_group' => $assignGroup_details,
                                                    'range_basis' => $promo->range_basis,
                                                    'low' => $promo->low,
                                                    'high' => $promo->high,
                                                    'rep_range' => $promo->rep_range,
                                                    'promotion_master_value' => $promo->value
                                                ];
                                            }
                                        }    
                                    }
                                }
                            } else { 
                                $invoice_total = OrderItems::where('active', 1)->where('order_id', $order_id)->sum('total_Price');

                                if ($invoice_total > $promo->low && $invoice_total < $promo->high) {
                                    $data[] = [
                                        'customer' => $customer_id,
                                        'promotion_id' => $promo->id,
                                        'promotion_value' => $promo->promo_value,
                                        'promotion_type' => $promo->promotion_type,
                                        'promotion_short_code' => $promo->short_code,
                                        'qual_group' => [],
                                        'assign_group' => [],
                                        'range_basis' => $promo->range_basis,
                                        'low' => $promo->low,
                                        'high' => $promo->high,
                                        'rep_range' => $promo->rep_range,
                                        'promotion_master_value' => $promo->value
                                    ];
                                }
                            }
                        }

                        //   return new JsonResponseArrayResource(true, 'Promotion List', $data);
                        //***********promotion calculations starts here */  
                     
                        $promotions = $data;
                        $qty = null;

                        $check_transaction = Transaction::where('order_id', $order_id)->count();
                        if ($check_transaction > 0) {
                            DB::select('CALL UpdationAfterProductChange(?)', [$order_id]);
                        }

                        if (!empty($promotions)) {
                            $success = 0;
                            $laPromotions = [];
                            $lDPPromotions = [];
                            $fgPromotions = [];
                            
                            foreach ($promotions as $promotion) {                                
                                if ($promotion['promotion_short_code'] === 'LA' || $promotion['promotion_short_code'] === 'LP') {
                                    $laPromotions[] = $promotion;
                                } elseif ($promotion['promotion_short_code'] === 'IDP') {
                                    $lDPPromotions[] = $promotion;
                                } 
                                elseif ($promotion['promotion_short_code'] === 'FG') {
                                    $fgPromotions[] = $promotion;
                                }                               
                            }
                            if (!empty($laPromotions)) {  
                                foreach ($laPromotions as $promo) {
                                    $assign_group = $promo['assign_group'];

                                    if (!empty($assign_group)) {  
                                        $item_code = [];
                                        foreach ($assign_group as $group) {
                                            // Access and print the "item_code" value for each object in the "assign_group" array
                                            $item_code[] = $group['item_code'];
                                        }

                                        $product = OrderItems::whereIn('product_id', $item_code)
                                            ->where('active', 1)->where('order_id', $order_id)
                                            ->get();
                                    } else {
                                        $product = OrderItems::where('active', 1)->where('order_id', $order_id)
                                            ->get();
                                    }
                                    if ($product->isNotEmpty()) {                                       
                                        foreach ($product as $prod) {
                                            // $check = Transaction::where('product_id', $prod->product_id)->where('la_id', $prod->id)->where('order_id',$request->order_id)->first();
                                            if($company_shortcode=='MAYAR'){
                                                $qty = $prod->qty;
                                            }
                                            else{
                                                $qty = $prod->uom_quantity;
                                            }
                                            $promotion_value = $promo['promotion_value'];
                                            if ($promo['promotion_short_code'] == 'LA') {

                                                $discount = $qty * $promo['promotion_value'];
                                            }
                                            if ($promo['promotion_short_code'] == 'LP') {

                                                $discount = $prod->total_Price * $promo['promotion_value'] / 100;
                                            }
                                            $transaction = new Transaction();

                                            $TransArray = array(
                                                'promo_id' => $promo['promotion_id'],
                                                'product_id' => $prod->product_id,
                                                'la_id' => $prod->id,
                                                'order_id' => $order_id,
                                                'discount' => round($discount,$rounding)
                                            );
                                            //$orderitemsObj->update(array('product_id' =>$prod->product_id,'order_id' => $request->order_id));
                                            Transaction::create($TransArray);
                                            DB::select('CALL CalculateAndUpdateDiscount(?, ?)', [$order_id, $prod->id]);
                                            $success = 1;
                                        }
                                    }
                                }
                            }               
                            if (!empty($lDPPromotions)) {
                                $success = 0;
                                foreach ($lDPPromotions as $promo) {
                                    $assign_group = $promo['assign_group'];
                                    // product = (unitprice*qty) total_price - litemtotaldiscount = resultamount*promotion_value/100=discount
                                    if (!empty($assign_group)) {
                                        $item_code = [];
                                        foreach ($assign_group as $group) {
                                            $item_code[] = $group['item_code'];
                                        }
                                        $product = OrderItems::whereIn('product_id', $item_code)
                                            ->where('active', 1)->where('order_id', $order_id)
                                            ->get();
                                    } else {
                                        $product = OrderItems::where('active', 1)->where('order_id', $order_id)
                                            ->get();
                                    }
                                    if ($product->isNotEmpty()) {
                                        foreach ($product as $prod) {
                                            $other_total_discount = Transaction::where('la_id', $prod->id)->where('order_id', $order_id)->sum('discount');
                                            $total_priceArray =  OrderItems::where('id', $prod->id)->where('order_id', $order_id)->first();
                                            $total_price = $total_priceArray->total_Price;
                                            $result_amount = $total_price - $other_total_discount;
                                            $discount_amt = $result_amount * $promo['promotion_value'] / 100;

                                            $transaction = new Transaction();

                                            $TransArray = array(
                                                'promo_id' => $promo['promotion_id'],
                                                'product_id' => $prod->product_id,
                                                'la_id' => $prod->id,
                                                'order_id' => $order_id,
                                                'discount' => round($discount_amt,$rounding)
                                            );

                                            Transaction::create($TransArray);

                                            // Call the stored procedure with parameters
                                            DB::select('CALL CalculateAndUpdateDiscount(?, ?)', [$order_id, $prod->id]);
                                            $success = 1;
                                        }
                                    }
                                }
                            }
                            //Free good promotions need to save
                            if (!empty($fgPromotions)) {                                
                                $success = 0;
                                foreach ($fgPromotions as $promo) {  
                                    $existingPromo = FocEligibility::where('foc_promo_id', $promo['promotion_id'])
                                                        ->where('order_id', $order_id)
                                                        ->first();                                
                                    if ($existingPromo) {         
                                        $existingPromo->update([
                                            'status' => 1,
                                            'rep_range' =>$promo['rep_range'],
                                            'product_count' => $promo['promotion_value'],
                                        ]);
                                    } 
                                    else {                                    
                                            $focArray = array(
                                                'foc_promo_id' => $promo['promotion_id'],
                                                'order_id' => $order_id,                                                
                                                'status' => 1,
                                                'rep_range' =>$promo['rep_range'],
                                                'product_count'=>$promo['promotion_value'],
                                            ); 
                                            FocEligibility::create($focArray);
                                    }        
                                }
                                $success = 1;
                            }
                            
                            if ($success == 1) {

                                DB::select('CALL UpdateOrderDetails(?)', [$order_id]);
                                $message = 'Order Saved & Promotions Calculated';
                                return new JsonResponseArrayResource(true, $message, $order);
                                // return new JsonResponseArrayResource(true, 'Order Saved & Promotions Calculated',[]);
                            }
                        } else {
                                return new JsonResponseArrayResource(true, $message, $order);
                            //return new JsonResponseArrayResource(true, 'Invalid Promotions', []);
                        }
                    }
                 
                    //***********eligible promotion ends here 

                } else {

                OrderDetails::where('customer_id', '=', $order->customer_id)                    
                    ->where('id', '=', $order_id)
                    ->update(array('Status' => 0,
                                'total_order_value'=> 0,
                                'vat_amt'=> 0,
                                'net_amt'=> 0,
                                'advance_amount'=>0,
                                'total_discount'=>0 ));
       
                return new JsonResponseArrayResource(true, $message, $order);

                }
            }
        } catch (Exception $ex) {
            DB::rollback();
            return new JsonResponseArrayResource(false, $ex->getMessage(), 500);
        }
    }
   
    function getRounding($customer_id){ 
        $customer = Customer::where('code', $customer_id)->first('rounding');
        if(!empty($customer)){
            $rounding=$customer->rounding;
        }
        else{
            $rounding=2;
        }
        return $rounding;
    }


    function getCustomerPromotions($customer_id, $promo_type = null){ 
        $query = Promotion::where('customer', $customer_id)->where('status', 1)
        ->leftJoin(
            'promotion_type_master',
            'promotion_type_master.value',
            '=',
            'promotions.type'
          )->select([
            'promotions.*',        
            'promotion_type_master.promotion_type AS promotion_type_name',
            
             
          ]);
        
        if ($promo_type !== null) {
            $query->where('type', $promo_type);
        }

        $customerPromos = $query->get();


        foreach ($customerPromos as $promotion) {
            $qualItemsCodes = json_decode($promotion->qual_group);
    
            if ($qualItemsCodes) {
                // Assuming you have a "products" table with "item_code", "item_name", "thumbnail_product_image", "detailed_desc_en", and "detailed_desc_ar" columns
                $qualItemDetails = Product::whereIn('item_code', $qualItemsCodes)
                    ->select('item_code', 'item_name', 'thumbnail_product_image', 'detailed_desc_en', 'detailed_desc_ar')
                    ->get();
    
                $promotion->qual_group_details = $qualItemDetails;
            }


            $assignItemsCodes = json_decode($promotion->assign_group);
    
            if ($assignItemsCodes) {
                // Assuming you have a "products" table with "item_code", "item_name", "thumbnail_product_image", "detailed_desc_en", and "detailed_desc_ar" columns
                $assignItemDetails = Product::whereIn('item_code', $assignItemsCodes)
                    ->select('item_code', 'item_name', 'thumbnail_product_image', 'detailed_desc_en', 'detailed_desc_ar')
                    ->get();
    
                $promotion->assign_group_details = $assignItemDetails;
            }
        }

        return new JsonResponseArrayResource(true, "Customer  Promotions", $customerPromos);
        
    }


}
