<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\QuestionCategoryMaster;
use App\Http\Requests\StoreQuestionCategoryMasterRequest;
use App\Http\Requests\UpdateQuestionCategoryMasterRequest;
use App\Http\Resources\JsonResponseArrayPaginateResource;
use App\Http\Resources\JsonResponseArrayResource;
use Illuminate\Support\Facades\Validator as FacadesValidator;
class QuestionCategoryMasterController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $faq = QuestionCategoryMaster::leftJoin(
            'users',
            'faq_category_master.created_by_id',
            '=',
            'users.id'
        )
        ->select([
            'faq_category_master.id AS id',
            'faq_category_master.category_name AS category_name',
            'users.name AS created_by',
            'faq_category_master.sort_order AS sort_order',
            'faq_category_master.created_at AS created_on',
            'faq_category_master.is_active AS active',

        ])->orderBy('faq_category_master.sort_order')
        ->get();

        return new JsonResponseArrayResource(true, 'faq categories list', $faq);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreQuestionCategoryMasterRequest $request)
    {
        $validator = FacadesValidator::make($request->all(), [
            'Category_name' => 'required',
            'Created_by' => 'required',
            'Sort_order' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }

        $faq_exit = QuestionCategoryMaster::where('id', $request->Id)->first();
        if ($faq_exit) {
            $faq = QuestionCategoryMaster::find($faq_exit->id);

            $faq->category_name = $request->Category_name;
            $faq->created_by_id = $request->Created_by;
            $faq->sort_order = $request->Sort_order;
            $faq->is_active = $request->Is_active ?? 1;
            if ($faq->update())
            $message = "Faq category updated";
                return new JsonResponseArrayResource(true, $message, $faq);
        } else {
            $message = "Faq category added";
            $faq = new QuestionCategoryMaster();
         
            $faq->category_name = $request->Category_name;
            $faq->created_by_id = $request->Created_by;
            $faq->sort_order = $request->Sort_order;
            $faq->is_active = $request->Is_active ?? 1;
            if ($faq->save()) {
                return  new  JsonResponseArrayResource(true, $message, $faq);
            } else {
                return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
            }
        }
    }
    public function UpdateStatusFaqCategory($id,$active){
        $faq_exist = QuestionCategoryMaster::where('id', $id)->first();
        if ($faq_exist) {
        $faq = QuestionCategoryMaster::find($id);
        $faq->is_active = $active;
        $faq->update();
        return new JsonResponseArrayResource(true, 'Faq category status changed', $faq);
        }
    }
    
    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        {
            $faq = QuestionCategoryMaster::where('id', '=', $id)
                ->first();
            return new JsonResponseArrayResource(true, 'Faq category details', $faq);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(QuestionCategoryMaster $questionCategoryMaster)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateQuestionCategoryMasterRequest $request, QuestionCategoryMaster $questionCategoryMaster)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(QuestionCategoryMaster $questionCategoryMaster)
    {
        //
    }
}
