<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\RedeemLoyalityPoints;
use App\Http\Requests\StoreRedeemLoyalityPointsRequest;
use App\Http\Requests\UpdateRedeemLoyalityPointsRequest;
use App\Http\Resources\JsonResponseArrayPaginateResource;
use App\Http\Resources\JsonResponseArrayResource;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class RedeemLoyalityPointsController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function index()
  {
    $redeempoints = RedeemLoyalityPoints::where('Is_active', '=', '1')
      ->orderBy('created_on', "desc")
      ->customPaginate();

    return new JsonResponseArrayPaginateResource(
      true,
      'loyality points list',
      $redeempoints
    );
  }

  public function getRedeempointsByCustomer($customer)
  {
    $redeempoints = RedeemLoyalityPoints::where('Is_active', '=', '1')
      ->where('customer',  $customer)
      ->orderBy('created_on', "desc")
      ->customPaginate();

    return new JsonResponseArrayPaginateResource(
      true,
      'loyality points list',
      $redeempoints
    );
  }
  /**
   * Show the form for creating a new resource.
   */
  public function create()
  {
    //
  }

  /**
   * Store a newly created resource in storage.
   */
  public function store(StoreRedeemLoyalityPointsRequest $request)
  {
    $validator = FacadesValidator::make($request->all(), [
      'Customer_code' => 'required',
      'Channel' => 'required',
      'Redeem_Points' => 'required',
    ]);

    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }
    try {
      DB::beginTransaction();

      $redeempoints_exit = RedeemLoyalityPoints::where('customer', $request->Customer_code)
        ->where('channel', $request->Channel)
        ->where('details', $request->Details)
        ->first();
      if ($redeempoints_exit) {
        $redeempoints = RedeemLoyalityPoints::find($redeempoints_exit->id);
        $redeempoints->customer = $request->Customer_code;
        $redeempoints->created_on = $request->Created_On;
        $redeempoints->is_active = $request->Active ?? 1;
        $redeempoints->channel = $request->Channel;
        $redeempoints->details = $request->Details;
        $redeempoints->redeem_points = $request->Redeem_Points;
        $message = "Redeem Points updated";
        if ($redeempoints->update()) {
            DB::commit();
          return new JsonResponseArrayResource(true, $message, $redeempoints);
        }
      } else {
        $redeempoints = new RedeemLoyalityPoints();
        $message = "Redeem Points added";
      }
      $redeempoints->customer = $request->Customer_code;
      $redeempoints->created_on = $request->Created_On;
      $redeempoints->is_active = $request->Active;
      $redeempoints->channel = $request->Channel;
      $redeempoints->details = $request->Details;
      $redeempoints->redeem_points = $request->Redeem_Points;
      if ($redeempoints->save()) {
        DB::commit();
        return new JsonResponseArrayResource(true, $message, $redeempoints);
      } else {
        DB::rollBack();
        return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
      }
    } catch (Exception $ex) {
      DB::rollback();
      return new JsonResponseArrayResource(false, $ex->getMessage(), 500);
    }
    
  }

  /**
   * Display the specified resource.
   */
  public function show(RedeemLoyalityPoints $redeemLoyalityPoints)
  {
    //
  }

  /**
   * Show the form for editing the specified resource.
   */
  public function edit(RedeemLoyalityPoints $redeemLoyalityPoints)
  {
    //
  }

  /**
   * Update the specified resource in storage.
   */
  public function update(
    UpdateRedeemLoyalityPointsRequest $request,
    RedeemLoyalityPoints $redeemLoyalityPoints
  ) {
    //
  }

  /**
   * Remove the specified resource from storage.
   */
  public function destroy(RedeemLoyalityPoints $redeemLoyalityPoints)
  {
    //
  }
}
