<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\JsonResponseArrayResource;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\App;
use App\Models\Promotion;
use App\Models\PromotionType;


class SapPromotionController extends Controller
{
  public function getNormalPromotions(Request $request)
  {
    $options = [];
    if (App::environment('local')) {
      $options = ['verify' => false];
    }

    $url =
      'https://172.18.1.61:8001/sap/opu/odata/sap/ZOD_SD_PROM_DET_SRV/zprom_detSet';
    $headers = [
      'Authorization' => 'Basic R1RfQVBQOkFtRiRHdEBhUFAyMw==',
       
    ];

    $json = [
      [
        "DATE" => Carbon::now()->format('d.m.Y'),
        //   "BUDAT" => str_replace('-', '.', $request->start_date),
        "KUNNR" => $request->customer_code,
        //   "KONTO" => $request->customer_code,
        "AKTNR" => "NORMAL",
      ],
    ];

    $json_to_str = "'" . json_encode($json) . "'";

    $params = [
      '$filter' => 'ZvInput eq ' . $json_to_str,
      '$format' => 'json',
    ];

    $response = Http::withHeaders($headers)
      ->withOptions($options)
      ->get($url, $params);

    if ($response->successful()) {
      // You can access the API response JSON using $response->json()
      $data = $response->json();

      // Process the $data as needed

      return new JsonResponseArrayResource(
        true,
        'Normal Promotions',
        $data['d']['results']
      );
    } else {
      // Handle the error, e.g., return an error response
      return response()->json(
        ['error' => 'Failed to fetch data from SAP API'],
        $response->status()
      );
    }
  }

  public function getSlabPromotions(Request $request)
  {
    $options = [];
    if (App::environment('local')) {
      $options = ['verify' => false];
    }

    // $url ='https://172.18.3.60:8001/sap/opu/odata/sap/ZOD_SD_PROM_DET_SRV/zprom_detSet';
    $url ='https://172.18.1.61:8001/sap/opu/odata/sap/ZOD_SD_PROM_DET_SRV/zprom_detSet';
    $headers = [
      'Authorization' => 'Basic R1RfQVBQOkFtRiRHdEBhUFAyMw==',
       
    ];

    $json = [
      [
        "DATE" => Carbon::now()->format('d.m.Y'),
        //   "BUDAT" => str_replace('-', '.', $request->start_date),
        "KUNNR" => $request->customer_code,
        //   "KONTO" => $request->customer_code,
        "AKTNR" => "SLABPROMO",
      ],
    ];

    $json_to_str = "'" . json_encode($json) . "'";

    $params = [
      '$filter' => 'ZvInput eq ' . $json_to_str,
      '$format' => 'json',
    ];

    $response = Http::withHeaders($headers)
      ->withOptions($options)
      ->get($url, $params);

    if ($response->successful()) {
      // You can access the API response JSON using $response->json()
      $data = $response->json();

      // Process the $data as needed
      $results = $data['d']['results'];

      

      return new JsonResponseArrayResource(
        true,
        'Slab Promotions',
        $data['d']['results']
      );
    } else {
      // Handle the error, e.g., return an error response
      return response()->json(
        ['error' => 'Failed to fetch data from SAP API'],
        $response->status()
      );
    }
  }

  public function getCashDiscountPromotions(Request $request)
  {
    $options = [];
    if (App::environment('local')) {
      $options = ['verify' => false];
    }

    // Set the API endpoint and parameters
    // $url ='https://172.18.3.60:8001/sap/opu/odata/sap/ZOD_SD_PROM_DET_SRV/zprom_detSet';
    $url ='https://172.18.1.61:8001/sap/opu/odata/sap/ZOD_SD_PROM_DET_SRV/zprom_detSet';

    $json = [
      [
        "DATE" => Carbon::now()->format('d.m.Y'),
        //   "BUDAT" => str_replace('-', '.', $request->start_date),
        "KUNNR" => $request->customer_code,
        "AKTNR" => "CASHDISCOUNT",
      ],
    ];

    $json_to_str = "'" . json_encode($json) . "'";

    $params = [
      '$filter' => 'ZvInput eq ' . $json_to_str,
      '$format' => 'json',
    ];

    // Make the API request with headers
    $response = Http::withHeaders([
      'Authorization' => 'Basic R1RfQVBQOkFtRiRHdEBhUFAyMw==',
    ])
      ->withOptions($options)
      ->get($url, $params);

    // Check if the request was successful
    if ($response->successful()) {
      // You can access the API response JSON using $response->json()
      $data = $response->json();

      // Process the $data as needed
      return new JsonResponseArrayResource(
        true,
        'Cash Discount Promotions',
        $data['d']['results']
      );
    } else {
      // Handle the error, e.g., return an error response
      return response()->json(
        ['error' => 'Failed to fetch data from SAP API'],
        $response->status()
      );
    }
  }

  /**
   * Display a listing of the resource.
   */
  public function index()
  {
    //
  }

  /**
   * Store a newly created resource in storage.
   */
  public function store(Request $request)
  {
    //
  }

  /**
   * Display the specified resource.
   */
  public function show(string $id)
  {
    //
  }

  /**
   * Update the specified resource in storage.
   */
  public function update(Request $request, string $id)
  {
    //
  }

  /**
   * Remove the specified resource from storage.
   */
  public function destroy(string $id)
  {
    //
  }
}
