<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\JsonResponseArrayResource;
use App\Models\CompanyDetail;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Http;

class SoaController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function index(Request $request)
  {
    $options = [];
    if (App::environment('local')) {
      $options = ['verify' => false];
    }
    $json = [
      [
        "BUKRS" => "2100",
        "KOART" => "D",
        "KONTO" => $request->customer_code,
        "PERNR" => "",
        "ZTERM" => "",
        "XAUSZ" => "2",
        "BUDAT" => str_replace('-', '.', $request->start_date),
        "BUDT1" => str_replace('-', '.', $request->end_date) ?? date("d.m.Y"),
        "DAY1" => "30",
        "DAY2" => "45",
        "DAY3" => "60",
        "WAERS" => "SAR",
      ],
    ];

    $json_to_str = "'" . json_encode($json) . "'";

    $params = [
      '$filter' => 'ZvInput eq  ' . $json_to_str,
      '$format' => 'json',
    ];

    // $username = env('GT_DATA_USERNAME');
    // $password = env('GT_DATA_PASSWORD');

    $company_details = CompanyDetail::where('id', 1)->first();

              $username =  $company_details->sap_user;
              $password = $company_details->sap_password;

    $credentials = base64_encode($username . ':' . $password);

    $response = Http::withHeaders([
      'Authorization' => 'Basic ' . $credentials,
    ])
      ->withOptions($options)
      ->get(
        'https://172.18.1.61:8001/sap/opu/odata/sap/ZFI_GT_SOA_SRV/zsoaSet',
        $params
      ); // https://172.18.1.61:8001 - production link
    if (isset($response['d']['results'])) {
      return new JsonResponseArrayResource(
        true,
        'SOA',
        $response['d']['results']
      );
    } else {
      return response()->json('SAP error!', 422);
    }
  }
}
