<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\SubCategory;
use App\Http\Requests\StoreSubCategoryRequest;
use App\Http\Requests\UpdateSubCategoryRequest;
use App\Http\Resources\JsonResponseArrayResource;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator as FacadesValidator;
use Intervention\Image\ImageManagerStatic as Image;
class SubCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $subcategories = SubCategory::where('product_sub_category_master.status', '=', '1')
        ->leftJoin('product_category_master', 'product_category_master.value', '=', 'product_sub_category_master.category')
        ->select('product_sub_category_master.*', 'product_category_master.category_name')
        ->orderBy('product_sub_category_master.sort_order', 'asc')
        ->get();

       return new JsonResponseArrayResource(true, 'subcategory list', $subcategories);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreSubCategoryRequest $request)
    {
        {
            $validator = FacadesValidator::make($request->all(), [
                'Subcategory' => 'required',
                'Subcategory_ar' => 'required',
                'Value' => 'required',
                'Category' => 'required',
                 
            ]);
            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }
    
            $subcategory_exit = SubCategory::where('value', $request->Value)->first();
            if ($subcategory_exit) {
                $subcategory = SubCategory::find($subcategory_exit->id);
                $message = "Subcategory updated";
                
                $subcategory->value = $request->Value;
                $subcategory->subcategory = $request->Subcategory;
                $subcategory->subcategory_ar = $request->Subcategory_ar;
                $subcategory->category = $request->Category;
                $subcategory->sort_order = $request->Sort_order;
                $subcategory->status = $request->Status ?? 1;

                if ($request->hasFile('img_url')) {
                    $value = $request->file('img_url');
                    $rand = rand(100000, 1000000);
                    $imageName = $request->Category_name . $rand . '.' . $value->extension();
                    $width = 600; // your max width
                    $height = 600; // your max height
                    $img = Image::make(file_get_contents($value));
                    $img->height() > $img->width() ? ($width = null) : ($height = null);
                    $image = $img->resize($width, $height, function ($constraint) {
                        $constraint->aspectRatio();
                    });
                    if (!file_exists('images/')) {
                        mkdir('images/');
                    }
                    if (!file_exists('images/subcategory/')) {
                        mkdir('images/subcategory/');
                    }
                    $img_name = 'images/subcategory/subcategory_' .strtolower(str_replace(' ','_',$imageName));
                    $image->save(public_path($img_name), 70);
                    $subcategory->img_url = $img_name;
                }

                if ($subcategory->update())
                return new JsonResponseArrayResource(true, $message, $subcategory);
        } else {
                $subcategory = new SubCategory();
                $message = "Status Added!";
    
                if ($request->hasFile('img_url')) {
                    $value = $request->file('img_url');
                    $rand = rand(100000, 1000000);
                    $imageName = $request->Category_name . $rand . '.' . $value->extension();
                    $width = 600; // your max width
                    $height = 600; // your max height
                    $img = Image::make(file_get_contents($value));
                    $img->height() > $img->width() ? ($width = null) : ($height = null);
                    $image = $img->resize($width, $height, function ($constraint) {
                        $constraint->aspectRatio();
                    });
                    if (!file_exists('images/')) {
                        mkdir('images/');
                    }
                    if (!file_exists('images/subcategory/')) {
                        mkdir('images/subcategory/');
                    }
                    $img_name = 'images/subcategory/subcategory_' .strtolower(str_replace(' ','_',$imageName));
                    $image->save(public_path($img_name), 70);
                    $subcategory->img_url = $img_name;
                }

                $subcategory->value = $request->Value;
                $subcategory->subcategory = $request->Subcategory;
                $subcategory->subcategory_ar = $request->Subcategory_ar;
                $subcategory->category = $request->Category;
                $subcategory->sort_order = $request->Sort_order;
                $subcategory->status = $request->Status ?? 1;
                if ($subcategory->save()) {
                    return  new  JsonResponseArrayResource(true, $message, $subcategory);
                } else {
                    return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
                }
            }
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        
            $subcat = SubCategory::where('id', '=', $id)
                ->first();
            return new JsonResponseArrayResource(true, 'Sub Category Details', $subcat);
         
    }

    public function subCatsByCat($cus_id,$cat_id){  
        /*
            $subcats = SubCategory::where('category', '=', $cat_id)
                ->get();
            return new JsonResponseArrayResource(true, 'Subcategory by Category', $subcats);
        */
        
        $validator = FacadesValidator::make(['cus_id' => $cus_id,'cat_id' => $cat_id,], [
            'cus_id' => 'required',
            'cat_id' => 'required',            
          ]);
          if ($validator->fails()) {
              return response()->json($validator->errors(), 422);
          }
        
        $options = [];
        if (App::environment('local')) {
            $options = ['verify' => false];
        }
        $url = "https://salesproapidev.azurewebsites.net/B2BItem/CategoryItems/{$cus_id}";
    
        $response = Http::timeout(500)
          ->withOptions($options)
          ->get($url, [
            'headers' => [
              'Content-Type' => 'application/json',
            ],
          ]);
    
        if ($response->successful()) {
            $categoryData = $response->json();            
            $subCategoryValues = collect($categoryData)
                                ->filter(function ($category) use ($cat_id) {
                                    return $category['category_value'] == $cat_id;
                                })
                                ->flatMap(function ($category) {
                                    return collect($category['subcategory_details'])
                                        ->pluck('value');
                                })
                                ->toArray();
 
                                
            $externalSubCategories = SubCategory::whereIn('value', $subCategoryValues)
                                ->where('status', '=', '1')                                                                 
                                ->get();
            $otherSubCategories = SubCategory::whereNotIn('value', $subCategoryValues)
                            ->where('status', '=', '1')
                            ->where('category',$cat_id)
                            ->orderBy('id', 'asc')
                            ->get();
            $subCategories = $externalSubCategories->merge($otherSubCategories);
            return new JsonResponseArrayResource(
                true,
                'Sub category list',
                $subCategories->toArray()
            );
        }
        else {
            return new JsonResponseArrayResource(
              false,
              'Failed to fetch Sub categories',
              null
            );
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(SubCategory $subCategory)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateSubCategoryRequest $request, SubCategory $subCategory)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(SubCategory $subCategory)
    {
        //
    }
}
