<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\TermsConditions;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator as FacadesValidator;
use stdClass;

class TermsConditionsController extends Controller
{
    //

    public function index(Request  $request)
    {
        $validator = FacadesValidator::make($request->all(), [
            'user_id' => 'required'

        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }


        $userDetails =  User::where('id', $request->user_id)->first();

        $id = (!isset($userDetails->terms_condition_id) || empty($userDetails->terms_condition_id)) ? 0 : $userDetails->terms_condition_id;

        $status = (!isset($userDetails->terms_condition_status) || empty($userDetails->terms_condition_status)) ? 0 : $userDetails->terms_condition_status;


        $output = array();
        $teamsandcondition =  TermsConditions::where('status', 1)->first();
        $teamsandcondition->eng_file = url('/').$teamsandcondition->eng_file;
        $teamsandcondition->arabic_file = url('/').$teamsandcondition->arabic_file;


        if ($id == 0 || $status != 'agreed') {

            
            $output = array('is_approval_required' => true, 'termsandcondition' => $teamsandcondition);
        } else if ($id != 0 || $status == 'agreed') {

        
            if ($id != $teamsandcondition->id) {
                $output = array('is_approval_required' => true, 'termsandcondition' => $teamsandcondition);
            } else {
                $output = array('is_approval_required' => false, 'termsandcondition' => $teamsandcondition);
            }
        }




        return $output;
    }


    public function updateUserData(Request  $request)
    {

        $fields = $request->validate(['user_id' => 'required', 'status' => 'required', 'tc_id' => 'required']);
 
   

        $result = array();
        $user = User::find($request->input('user_id'));

        if ($user) {
           
           
            $user->update([
                'terms_condition_id' => $request->input('tc_id'),
                'terms_condition_status' => ($request->input('status')) == 1 ? 'agreed': 'disagree',
                'terms_condition_action_date' => DB::raw('NOW()')
            ]);
           
            $result=array('status'=>true,'message'=>'Action Updated');
        
        } else {

            $result=array('status'=>false,'message'=>'not updated');
        }
        return $result;
    }

}
