<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\JsonResponseArrayResource;
use App\Models\Transaction;
use Illuminate\Http\Request;

class TransactionController extends Controller
{


    public function getTransactionByProduct($order_id, $la_id)
    {
        $orders = Transaction::where('transactions.order_id', '=', $order_id)
        ->where('transactions.la_id', '=', $la_id)
        ->leftJoin(
          'promotions',
          'transactions.promo_id',
          '=',
          'promotions.id'
        )
        ->leftJoin(
            'product',
            'transactions.product_id',
            '=',
            'product.item_code'
          )
          ->leftJoin(
            'promotion_type_master',
            'promotions.type',
            '=',
            'promotion_type_master.value'
          ) 
        ->select([
          'transactions.*',
          'promotions.promo_value AS promo_value',
          'promotions.type AS promo_type',
          'product.item_name AS item_name',
          'promotion_type_master.promotion_type AS promotion_type',
          'promotion_type_master.short_code AS short_code',
        ])->get();
     
      return new JsonResponseArrayResource(true, 'Transaction by Product!', $orders);
    }
    public function getTransactionByOrder($order_id)
    {
        $orders = Transaction::where('transactions.order_id', '=', $order_id) 
        ->leftJoin(
          'promotions',
          'transactions.promo_id',
          '=',
          'promotions.id'
        )
        ->leftJoin(
            'product',
            'transactions.product_id',
            '=',
            'product.item_code'
          )
          ->leftJoin(
            'promotion_type_master',
            'promotions.type',
            '=',
            'promotion_type_master.value'
          ) 
        ->select([
          'transactions.*',
          'promotions.promo_value AS promo_value',
          'promotions.type AS promo_type',
          'promotions.promo_type AS sap_promo_type',
          'promotions.sap_code AS sap_code',
          'product.item_name AS item_name',
          'promotion_type_master.promotion_type AS promotion_type',
          'promotion_type_master.short_code AS short_code',
        ])->get();
     
      return new JsonResponseArrayResource(true, 'Transaction by Order!', $orders);
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Transaction $transaction)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Transaction $transaction)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Transaction $transaction)
    {
        //
    }
}
