<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\JsonResponseArrayPaginateResource;
use App\Http\Resources\JsonResponseArrayResource;
use App\Models\User;
use App\Models\UserDetailsModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator as FacadesValidator;
use Carbon\Carbon;
use App\Models\Promotion;
use App\Models\PromotionType;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Http;
use App\Jobs\DataMappingJob;
use App\Jobs\DataMappingJobForNadec;
use App\Models\CompanyDetail;
use App\Models\Customer;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Queue;
use Tymon\JWTAuth\Facades\JWTAuth;
use Illuminate\Support\Facades\Log;
use App\Models\ActiveSession;
use Illuminate\Support\Facades\DB;

class UserController extends Controller
{
  
  /**
   * Display a listing of the resource.
   */
  public function index()
  {
    $users = UserDetailsModel::where('active', '=', '1')
      ->orderBy('created_at', "desc")
      ->customPaginate();
    return new JsonResponseArrayPaginateResource(true, 'List of Users', $users);
  }

  /**
   * Store a newly created resource in storage.
   */
  public function register(Request $request)
  {
    $validator = FacadesValidator::make($request->all(), [
      'name' => 'required',
      'email' => 'required',
      'password' => 'required',
    ]);

    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }

    $user = new UserDetailsModel();
    $user->name = $request->name;
    $user->email = $request->email;
    $user->password = Hash::make($request->password);
    $user->mobile = $request->mobile;
    $user->branches = $request->branches;
    $user->permission = $request->permission;
    $user->is_admin = $request->is_admin;
    $user->role = $request->role ?? "USER";
    $user->active = $request->active ?? 1;
    $user->activated = $request->activated ?? null;
    $user->code = $request->code ?? null;
    $user->reset_date_time = $request->reset_date_time ?? null;
    $user->reset_key = $request->reset_key ?? null;
    $user->direction = $request->direction ?? "CP-RP";

    $message = "User Created!";
    if ($user->save()) {
      return new JsonResponseArrayResource(true, $message, $user);
    } else {
      return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
    }
  }

  /**
   * Display the specified resource.
   */
  public function show($id)
  {
    $user = UserDetailsModel::where('active', '=', '1')
      ->where('id', '=', $id)
      ->first();
    if (!$user) {
      return new JsonResponseArrayResource(false, 'User not found', null);
    }

    $branchCodes = json_decode($user->branches);

    if ($branchCodes) {
      // Assuming you have a "customers" table with "code", "name", "address1", and "address2" columns
      $branchDetails = Customer::whereIn('code', $branchCodes)
        ->select(
          'code',
          'name',
          'name_ar',
          'address1',
          'address2',
          'city',
          'zip',
          'cr_number',
          'vat_number',
          'address1_ar',
          'address2_ar',
          'city_ar'
        )
        ->get();
      $user->branch_details = $branchDetails;
    }
    return new JsonResponseArrayResource(true, 'Users Details', $user);
  }

  /**
   * Update the specified resource in storage.
   */
  public function update(Request $request, $id)
  {
  }

  public function destroy(UserDetailsModel $userDetailsModel)
  {
    //
  }

  public function login(Request $request)
  {
    
    $validator = FacadesValidator::make($request->all(), [
      'email' => 'required',
      'password' => 'required',
    ]);

    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }
   
    if(auth()->attempt(array('email' => $request['email'], 'password' => $request['password']))){
      $user = auth()->user();  
      
      if (isset($request->webportal) && $request->webportal==1 && $user->role!='ADMIN') {
              $errors = [];
              $errors['error'] = 'Invalid Login Attempt';
              return response()->json($errors, 401);
      }  
      $credentials = $request->only('email', 'password');  
      $token = auth('api')->attempt($credentials);
      if($token){       
          $this->insertOrUpdateSession($user->id, $request->device, $request->device_id,$token); 
      }
      
      // Dispatch the data mapping job
      if ($user['role'] == 'USER') {
          $company_details = CompanyDetail::where('id', 1)->first(
            'company_shortcode'
          );
          
          if ($company_details) {
            if ($company_details->company_shortcode == 'MAYAR') {
              DataMappingJob::dispatch($user,$user_branches='');
            }
            if ($company_details->company_shortcode == 'NADEC') {
              DataMappingJobForNadec::dispatch($user,$user_branches='');
            }
          }
      }
      $user['token']=$this->respondWithToken($token);
      $user['token_type']="bearer";      
      $user['expires_in'] = 0;

      // If rp_token exists, add it to the user data
      $routeProToken = CompanyDetail::select('rp_token')->first();
      if ($routeProToken) {
          $user['rp_token'] = $routeProToken->rp_token;
      }
      
      return new JsonResponseArrayResource(true, 'Login Success', $user);
    }
    else {
      $errors = [];
      $errors['error'] = 'Unauthorized ';
      return response()->json($errors, 401);
    }
  }

  protected function respondWithToken($token){
      return $token;  
  }
  
  // Create/Update token
  private function insertOrUpdateSession($userId, $deviceType, $device_id, $token) {
      $existingSession = ActiveSession::where('user_id', $userId)
                                      ->where('device_type', $deviceType)                                      
                                      ->first();
      if ($existingSession) {        
          $existingSession->token = $token;
          $existingSession->device_id = $device_id; 
          $existingSession->is_active = true;          
          $existingSession->save();
      }
      else {       
          ActiveSession::create([
            'user_id' => $userId,
            'device_type' => $deviceType,
            'device_id'=>$device_id,
            'token' => $token, 
            'is_active' => true,
          ]);
      }
  }

  public function changepassword(Request $request)
  {
    $validator = FacadesValidator::make($request->all(), [
      'email' => 'required',
      'password' => 'required',
      'newpassword' => 'required',
    ]);

    if ($validator->fails()) {
      return response()->json($validator->errors(), 422);
    }
    $user = UserDetailsModel::where('email', "=", $request->email)
      ->where('password', '=', $request->password)
      ->get();
    if (count($user) > 0) {
      $updated = UserDetailsModel::where('email', "=", $request->email)
        ->where('password', '=', $request->password)
        ->update(['password' => $request->newpassword]);
      if ($updated) {
        return new JsonResponseArrayResource(true, 'password changed', $user);
      } else {
        $errors = [];
        $errors['error'] = "Couldn't change Password";
        return response()->json($errors, 401);
      }
    } else {
      $errors = [];
      $errors['error'] = 'Unauthorized ';
      return response()->json($errors, 401);
    }    
  }

  public function checkUserAccessLimit()
  {
    // Get user details from the request
    $userDetails = request()
      ->json()
      ->all();

    if (empty($userDetails['branches'])) {
      return new JsonResponseArrayResource(
        false,
        'Fill the mandatory(*) fields!',
        []
      );
    } else {
      foreach ($userDetails['branches'] as $branch) {
        // Get the user access count for the current branch from the Customer table
        $customer = Customer::where('code', $branch)->first();

        // Check if the branch exists in the Customer table
        if (!$customer) {
          return new JsonResponseArrayResource(
            false,
            'Branch ' . $branch . ' not found in the Customer table',
            []
          );
        }

        // Check if user_access_count is null
        if ($customer->user_access_count === null) {
          return new JsonResponseArrayResource(
            false,
            'Set user access limit for Customer ' . $customer->name,
            []
          );
        }

        $userAccessCount = $customer->user_access_count;

        // Get the user count for the current branch from the UserDetails table
        $userCount = UserDetailsModel::where('active', 1)
          ->whereJsonContains('branches', $branch)
          ->count();

        // Check if the user count exceeds the user access limit
        if ($userCount >= $userAccessCount) {
          return new JsonResponseArrayResource(
            false,
            'Customer ' . $customer->name . ' reached user access limit',
            []
          );
        }
      }

      // If no branch has reached the user access limit, return success message
      return new JsonResponseArrayResource(
        true,
        'User access limit check successful',
        []
      );
    }

    // Loop through the branches in the users
  }




  // public function resetPassword(Request $request)
  // {
  //   $validator = FacadesValidator::make($request->all(), [
  //     'name' => 'required',
  //     'email' => 'required',
  //     'password' => 'required',
  //   ]);

  //   if ($validator->fails()) {
  //     return response()->json($validator->errors(), 422);
  //   }

  //   $user = new UserDetailsModel();
  //   $user->name = $request->name;
  //   $user->email = $request->email;
  //   $user->password = Hash::make($request->password);
  //   $user->mobile = $request->mobile;
  //   $user->branches = $request->branches;
  //   $user->permission = $request->permission;
  //   $user->is_admin = $request->is_admin;
  //   $user->role = $request->role ?? "USER";
  //   $user->active = $request->active ?? 1;
  //   $user->activated = $request->activated ?? null;
  //   $user->code = $request->code ?? null;
  //   $user->reset_date_time = $request->reset_date_time ?? null;
  //   $user->reset_key = $request->reset_key ?? null;
  //   $user->direction = $request->direction ?? "CP-RP";

  //   $message = "User Created!";
  //   if ($user->save()) {
  //     return new JsonResponseArrayResource(true, $message, $user);
  //   } else {
  //     return new JsonResponseArrayResource(false, 'Some Error Occured', 422);
  //   }
  // }

  public function validateToken(Request $request)
    {
        $userId = $request->input('user_id');
        $token = $request->input('token');

        $user = UserDetailsModel::
             select('id')
            ->where('id', $userId)
            ->where('recovery_token', $token)
            ->first();

            if ($user) {
              $message = 'Token validated successfully.';
              return new JsonResponseArrayResource(true, $message, $user);
          } else {
              $message = 'Token validation failed.';
              return new JsonResponseArrayResource(false, $message, null);
          }
    }


    public function updateUserPassword(Request $request)
    {
        $userId = $request->input('user_id');
        $recoveryToken = $request->input('token');
    
        // Find the user by user_id and recovery_token
        $user = UserDetailsModel::where('id', $userId)
                                 ->where('recovery_token', $recoveryToken)
                                 ->first();
    
        if ($user) {
            // Hash the new password
            $newPassword = Hash::make($request->input('new_password'));
    
            // Update the user's password
            $user->password = $newPassword;
            $user->recovery_token = null; // Nullify the recovery token
            $user->save();
    
            // Return success response
            $message = 'Password updated successfully.';
            return new JsonResponseArrayResource(true, $message, $user);
        } else {
            // Return error response if user is not found or recovery token is invalid
            $message = 'Invalid user ID or recovery token.';
            return new JsonResponseArrayResource(false, $message, null);
        }
    }
    public function getUserIdfromEmail(Request $request)
    {
      $email = $request->input('email');

      // Query the User model to find the user with the provided email
      $user = User::where('email', $email)->first();

      if (!$user) {

            // Return error response if user not found
          $message = 'User Not Found.';
          return new JsonResponseArrayResource(false, $message, null);
      }
      else {
            $message = 'User ID';
            return new JsonResponseArrayResource(true , $message, $user->id);
        }
    }
    
    


}
