<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\JsonResponseArrayResource;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Intervention\Image\ImageManagerStatic as Image;
class UserImgController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function index()
  {
    //
  }

  /**
   * Store a newly created resource in storage.
   */
  public function store(Request $request)
  {
    $rules = [
      'baseImage' => 'required',
    ];

    $validator = Validator::make($request->all(), $rules);

    if ($validator->fails()) {
      return response()->json(
        [
          'success' => false,
          'message' => $validator->errors(),
        ],
        401
      );
    } else {
      $image_64 = $request->file('baseImage');
      $imageName =
        'user_' .
        $request->id .
        '_' .
        Str::random(10) .
        '.' .
        $image_64->extension();

      $destinationPath = 'images/customers/' . $imageName;
      $image = Image::make(file_get_contents($image_64))->resize(
        700,
        null,
        function ($constraint) {
          $constraint->aspectRatio();
        }
      );
      $image->save(public_path($destinationPath), 70);

      $imageSaved = DB::table('users')
        ->where('id', $request->id)
        ->update([
          'photo_url' => $imageName,
        ]);

      if ($imageSaved) {
        return new JsonResponseArrayResource(
          true,
          'Image Saved For User',
          $imageName
        );
      } else {
        return new JsonResponseArrayResource(false, 'Image of User', 400);
      }
    }
  }
  /**
   * Display the specified resource.
   */
  public function show(string $id)
  {
    //
  }

  /**
   * Update the specified resource in storage.
   */
  public function update(Request $request, string $id)
  {
    //
  }

  /**
   * Remove the specified resource from storage.
   */
  public function destroy(string $id)
  {
    //
  }
}
