<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;
use App\Models\ActiveSession;

class CheckActiveSession
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response{
        if (Auth::check()) {            
            $userId = Auth::id();
            $token = $request->header('Authorization');
            $token = str_replace('Bearer ', '', $token);
            if ($this->isUserSessionActive($userId, $token)) {
                return $next($request);
            } 
            else {
                return response()->json(['error' => 'Unauthorized - Inactive Session'], 401);
            }

        }
        return $next($request);
    }
    private function isUserSessionActive($userId, $token){
        return ActiveSession::where('user_id', $userId)
            ->where('token', $token)
            ->where('is_active', true)
            ->exists();
    }
}
