<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Symfony\Component\HttpFoundation\Response;

class LogRoute
{
  /**
   * Handle an incoming request.
   *
   * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
   */
  public function handle($request, Closure $next)
  {
    $response = $next($request);

    if ($request->method() == 'POST') {
      $log = [
        'URI' => $request->getUri(),
        'METHOD' => $request->getMethod(),
        'REQUEST_BODY' => $request->all(),
        'RESPONSE' => json_decode($response->getContent()),
      ];

      Log::info(json_encode($log));
    }

    return $response;
  }
}
