<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Models\ActiveToken;

class StaticTokenMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */

    public function handle(Request $request, Closure $next): Response{      
        $activeToken=ActiveToken::where('type', 'staticToken')           
                    ->where('is_active', true)
                    ->first();
        $staticToken = $activeToken->token;    
        $token = $request->header('Authorization');        
        if ($token && $token === 'Bearer ' . $staticToken) {           
            return $next($request);
        }
        return response()->json(['error' => 'Unauthorized'], 401);      
    }
}
