<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class JsonResponseArrayPaginateResource extends JsonResource
{
  public $status;
  public $message;
  public $resource;

  public function __construct($status, $message, $resource)
  {
    parent::__construct($resource);
    $this->status = $status;
    $this->message = $message;
  }

  public function toArray($request)
  {
    $custom = collect([
      'success' => $this->status,
      'message' => $this->message,
    ]);
    $data = $custom->merge($this->resource);
    return $data;
  }
}
