<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class JsonResponseArrayResource extends JsonResource
{
  public $status;
  public $message;
  public $resource;

  public function __construct($status, $message, $resource)
  {
    parent::__construct($resource);
    $this->status = $status;
    $this->message = $message;
  }

  public function toArray($request)
  {
    return [
      'success' => $this->status,
      'message' => $this->message,
      'data' => $this->resource,
    ];
  }
}
