<?php
namespace App\Jobs;

use App\Models\CompanyDetail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\Jobs\Job;
use App\Models\User;
use App\Models\UserDetailsModel;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\Promotion;
use App\Models\PromotionType;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Http;
use App\Models\Product; 
use App\Models\Customer;

class DataMappingJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    
    protected $user, $user_branches ;

    /**
     * Create a new job instance.
     */
    public function __construct($user, $user_branches)
    {
        $this->user = $user;
        $this->user_branches=$user_branches;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {

        if (isset($this->user)) {
            $options = [];
            if (App::environment('local')) {
              $options = ['verify' => false];
            }
          //Data Mapping
          if(empty($user_branches)){
            $customer_codes = json_decode($this->user->branches);          
          }
          else{
            $customer_codes = $this->user_branches;           
          }

          $twoHoursAgo = Carbon::now()->subHours(2);   
          
          if(count($customer_codes) > 0){ 
            foreach($customer_codes as $customer_code){
               $promotions = Promotion::where('customer',  $customer_code)
              ->where('status',1)                                    
              ->orderBy('created_at', 'desc')
              ->first('created_at');
              $flag=0;
              if($promotions){                    
                $createdAt=$promotions['created_at'];
                if ($createdAt->lte($twoHoursAgo))
                $flag=1;
                else
                $flag=0;
              }
              else{
                $flag=1;
              }

              if ($flag==1 ) {  

              $promo_types=["Normal","SLABPROMO","CASHDISCOU"];               
              

              // $username = 'env('GT_DATA_USERNAME')';
              // $password = env('GT_DATA_PASSWORD');

             

              // $username = 'GT_APP';
              // $password = 'AmF$Gt@aPP23';

              $company_details = CompanyDetail::where('id', 1)->first();

              $username =  $company_details->sap_user;
              $password = $company_details->sap_password;
 
              $credentials = base64_encode($username . ':' . $password);      
                

              foreach($promo_types as $promo_type){
    
                        // $url ='https://172.18.14.60:8001/sap/opu/odata/sap/ZOD_SD_PROM_DET_SRV/zprom_detSet';
                        $url ='https://172.18.1.61:8001/sap/opu/odata/sap/ZOD_SD_PROM_DET_SRV/zprom_detSet';
                        // https://172.18.1.61:8001 - production url
 
                        $headers = [
                          'Authorization' => 'Basic ' . $credentials,
                        ];
    
                        if($promo_type=='Normal'){
                          $json = [
                          [
                            "DATE" => Carbon::now()->format('d.m.Y'),
                            "KUNNR" => $customer_code,
                            "AKTNR" => "NORMAL",
                          ],
                          ];
                        }
    
                        if($promo_type=='SLABPROMO'){
                          $json = [
                          [
                            "DATE" => Carbon::now()->format('d.m.Y'),
                            "KUNNR" => $customer_code,
                            "AKTNR" => "SLABPROMO",
                          ],
                          ];
                        }
                        if($promo_type=='CASHDISCOU'){
                          $json = [
                          [
                            "DATE" => Carbon::now()->format('d.m.Y'),
                            "KUNNR" => $customer_code,
                            "AKTNR" => "CASHDISCOUNT", 
                          ],
                          ];
                        }
    
                        $json_to_str = "'" . json_encode($json) . "'";
                        $params = [
                        '$filter' => 'ZvInput eq ' . $json_to_str,
                        '$format' => 'json',
                        ];                   
   
    
                        $response = Http::timeout(500)->withHeaders($headers)
                        ->withOptions($options)
                        ->get($url, $params);
                        
                        // print_r($response); exit;
 
                        // $jsonString = json_encode($response, JSON_PRETTY_PRINT);
                        // echo $jsonString; 
                        // $jsonString1 = json_encode($url, JSON_PRETTY_PRINT);
                        // echo $jsonString1;  
                        // $jsonString2 = json_encode($params, JSON_PRETTY_PRINT);
                        // echo $jsonString2; exit;
                        
                      if ($response->successful()) {                         

                        $data = $response->json();  

                        //  $jsonString = json_encode($data, JSON_PRETTY_PRINT);
                        // echo $jsonString;    exit;  
                                         
                        $results = $data['d']['results'];  
                        if(!empty($results)){ 
                         
                          // Convert the input arrays into a Laravel collection
                          $collection = collect($results);
                          $grouped = $collection->groupBy(function ($item) {
                              return $item['Kbetr'] . '|' . $item['ErrDesc'] . '|'.$item['Refqty1'] .'|' . $item['Refqty2']  ;
                          });

                          $result = $grouped->map(function ($group) {                           
                              $matnrConcatenated = '';
                              $item_sub_groups=[];
                            
                              foreach ($group as $item) {      
                                if (strpos($matnrConcatenated, $item['Matnr']) === false) {

                                  //get item item_sub_group from product table
                                  $product_details = Product::leftJoin(
                                                      'product_sub_category_master',
                                                      'product.item_sub_group',
                                                      '=',
                                                      'product_sub_category_master.value'
                                                    )                                
                                                  ->where('item_code', $item['Matnr'])->first(['subcategory']);                                           
                                    if ($product_details) {    
                                      if (!in_array($product_details->subcategory, $item_sub_groups)) {
                                        $item_sub_groups[]=$product_details->subcategory;
                                      }  
                                    }
                                      //check product exist in db                         
                                    $check_product = Product::where('Active', 1)
                                                    ->where('item_code', $item['Matnr'])
                                                    ->first();                                    
                                    if ($check_product) {
                                      $matnrConcatenated .= ($matnrConcatenated ? ', ' : '') . $item['Matnr'];
                                    }
                                }
                              }
                              // Take the first item 
                              $firstItem = $group->first();
                              $firstItem['Matnr'] = $matnrConcatenated;
                              $firstItem['item_sub_groups'] = $item_sub_groups;   
                              return $firstItem;
                          });

                          $resultArray = $result->values()->toArray();
                        // print_r($resultArray); exit;
                        if($resultArray){
                          Promotion::where('customer', $customer_code)->where('status', 1)->where('created_at', '<', $twoHoursAgo)->update(array('status'=>0));
                          Customer::where('code', $customer_code)->update(array('promotion_updated_on'=>Carbon::now()));
                          
                          foreach ($resultArray as $result) { 

                              $encodedJson='';
                              $brand_names='';
                              if($result['Aktnr']=='Normal'){
                                $type=2; 
                                $low=1;
                                $high=99999;
                              }  
                              if($result['Aktnr']=='SLABPROMO'){ 
                                if($result['Krech']=='C'){
                                  $type=1;
                                }
                                if($result['Krech']=='A'){
                                  $type=2; 
                                } 
                                if($result['Refqty1']==0){
                                  $low=1;
                                }                                  
                                else{
                                  $low=$result['Refqty1']; 
                                }  
                                if($result['Refqty2'] < 1){
                                  $high=99999;
                                }                                  
                                else{
                                  $high=$result['Refqty2'];
                                }   
                              } 
                              if($result['Aktnr']=='CASHDISCOU'){
                                $type=5;
                                $low=1;                                                         
                                $high=99999;
                              }                           
                              if($low==0){
                                $low=1;
                              }  
                                $promotion_seq = promotionType::where('id', $type)->get('seq');       
                                if($promotion_seq)    
                                  $seq=$promotion_seq[0]->seq;
                                else
                                  $seq=0;  
                                if($result['Matnr']) {
                                  $matnrValues = explode(', ',$result['Matnr']);                              
                                  $encodedJson = json_encode($matnrValues, JSON_NUMERIC_CHECK);
                                }
                                else
                                $encodedJson=NULL;
                                
                                if($result['item_sub_groups']) { 
                                  $brand_names = '(' . implode(', ', $result['item_sub_groups']) . ')';
                                }
                                else
                                $brand_names=NULL;
                                
                                if($result['Datab'] !== '00.00.0000'){
                                  $from_date = Carbon::createFromFormat('d.m.Y', $result['Datab']);
                                  $from_date=$from_date->format('Y-m-d');                                
                                }
                                else
                                $from_date=NULL;
                                if($result['Datbi'] !== '00.00.0000'){
                                  $to_date = Carbon::createFromFormat('d.m.Y', $result['Datbi']);
                                  $to_date=$to_date->format('Y-m-d');
                                }
                                else
                                  $to_date=NULL;
                                if($encodedJson){
                                  Promotion::create([
                                    'from_date' => $from_date,
                                    'to_date' => $to_date,
                                    'customer' => $result['Kunnr'],
                                    'qual_group' => $encodedJson,
                                    'assign_group' =>$encodedJson,
                                    'range_basis'=>'QQ',
                                    'promo_value' => $result['Kbetr'],
                                    'type' => $type,
                                    'low' => $low,
                                    'high' => $high,
                                    'rep_range' => 0,
                                    'seq' => $seq,
                                    'status'=>1,
                                    'promo_type' => $result['Aktnr'],
                                    'sap_code' => $result['ErrDesc'],
                                    'brand_names' => $brand_names,                                  
                                    'created_at' => Carbon::now()->toDateTimeString(),
                                    'updated_at' => Carbon::now()->toDateTimeString(),
                                  ]);   
                                }  
                            }           
                            }
                          } 
                        }  
                      }
                    }
                  
                }
              }
        }  
      }
}
