<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\Jobs\Job;
use App\Models\User;
use App\Models\UserDetailsModel;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\Promotion;
use App\Models\PromotionType;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Http;
use App\Models\Product; 
use App\Models\ProductUomCustomerMappingModel;
use App\Models\Customer;


class DataMappingJobForNadec implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    
    protected $user, $user_branches ;

    /**
     * Create a new job instance.
     */
    public function __construct($user,$user_branches)
    {
        $this->user = $user;
        $this->user_branches=$user_branches;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        if (isset($this->user)) {
            $options = [];
            if (App::environment('local')) {
              $options = ['verify' => false];
            }
           
          //Data Mapping
          if(empty($user_branches)){
            $customer_codes = json_decode($this->user->branches);          
          }
          else{
            $customer_codes = $this->user_branches;           
          }
          $twoHoursAgo = Carbon::now()->subHours(2);   
          
          if(count($customer_codes) > 0){ 
            foreach($customer_codes as $customer_code){
              $promotions = Promotion::where('customer',  $customer_code)
              ->where('status',1)                                    
              ->orderBy('created_at', 'desc')
              ->first('created_at');
              $flag=0;
              if($promotions){                    
                $createdAt=$promotions['created_at'];
                if ($createdAt->lte($twoHoursAgo))
                $flag=1;
                else
                $flag=0;
              }
              else{
                $flag=1;
              }

              if ($flag==1 ) {  

                $url ='https://salesproapidev.azurewebsites.net/B2BItem/promo_detail/'.$customer_code;
              
                $response = Http::timeout(500)
                          ->withOptions($options)   
                          ->get($url, [
                                'headers' => [
                                    'Content-Type' => 'application/json',
                                ],
                            ]);  
                  if ($response->successful()) {
                  $results = $response->json();  

                  if(!empty($results)){                      

                  $url ='https://salesproapidev.azurewebsites.net/B2BItem/promo_group_detail/'.$customer_code;
              
                  $response = Http::timeout(500)
                              ->withOptions($options)   
                              ->get($url, [
                                    'headers' => [
                                        'Content-Type' => 'application/json',
                                    ],
                                ]);  
                    if ($response->successful()) {
                      $result_promo_details = $response->json();  
                    }  
                    $currentDate = Carbon::now();
                  
                    Promotion::where('customer', $customer_code)->where('status', 1)->where('created_at', '<', $twoHoursAgo)->update(array('status'=>0));
                    Customer::where('code', $customer_code)->update(array('promotion_updated_on'=>Carbon::now()));
                           
                          foreach ($results as $result) {                              
                            $qualificationGroup=$result['QualificationGroup'];
                            $assignmentGroup=$result['AssignmentGroup'];
                            $qualGroupProductIds=[];
                            $assignGroupProductIds=[];
                            $seq=0;
                            $type=0;
                            $special_price_status=0;
            
                                      foreach ($result_promo_details as $item) {
                                        //check for special price, if no special price then only add to promo
                                        $special_price_details=ProductUomCustomerMappingModel::where('customer', $customer_code)
                                                    ->where('product_id', $item['product_id'])
                                                    ->where('from_date', '<=', $currentDate)
                                                    ->where('to_date', '>=', $currentDate)
                                                    ->get('price');            
                                        if($special_price_details->isEmpty()){
                                          if ($item['type'] === "qual_group" && $item['ID'] === $qualificationGroup) {
                                            if (!in_array($item['product_id'], $qualGroupProductIds)) {                                               
                                              $qualGroupProductIds[] = $item['product_id'];
                                            }  
                                              
                                          } 
                                          elseif ($item['type'] === "assign_group" && $item['ID'] === $assignmentGroup) {
                                            if (!in_array($item['product_id'], $assignGroupProductIds)) {
                                              $assignGroupProductIds[] = $item['product_id'];
                                            }  
                                          }
                                        }
                                        else
                                        {
                                          $special_price_status=1;
                                        }                                       
                                    }

                                    
                            if($special_price_status==0 || !empty($qualGroupProductIds)){  
                              
                              
                                $qualGroupProductIds_encoded = json_encode($qualGroupProductIds, JSON_NUMERIC_CHECK);
                                $assignGroupProductIds_encoded = json_encode($assignGroupProductIds, JSON_NUMERIC_CHECK);
                            
                                if($result['PromotionTypeCode']=='Free Goods(Default)'){
                                  $type=3;                             
                                }  
                                if($result['PromotionTypeCode']=='Amount of line item'){
                                  $type=1;                             
                                } 
                                if($result['PromotionTypeCode']=='Amount of Invoice'){
                                  $type=4;                             
                                }                        
                                if($type>0){
                                  $promotion_seq = promotionType::where('id', $type)->get('seq');       
                                  if($promotion_seq)    
                                    $seq=$promotion_seq[0]->seq;
                                  else
                                    $seq=0;  
                                }
                                
                                  if($result['EndDate']){
                                    $to_date = $result['EndDate'];
                                  }
                                  else
                                    $to_date=NULL;
                                  
                                  if($result['RangeBasis']==1){
                                    $rangeBasis='QQ';
                                  }
                                  if($result['RangeBasis']==2){
                                    $rangeBasis='QA';  
                                  }                                 
                                  
                                  Promotion::create([
                                      'from_date' => NULL,
                                      'to_date' => $to_date,
                                      'customer' => $customer_code,
                                      'qual_group' => $qualGroupProductIds_encoded,
                                      'assign_group' =>$assignGroupProductIds_encoded,
                                      'range_basis'=>$rangeBasis,
                                      'promo_value' => $result['PromotionAmount'],
                                      'type' => $type,
                                      'low' => $result['RangeLow'],
                                      'high' => $result['RangeHigh'],
                                      'rep_range' => $result['RepeatingRange'],
                                      'seq' => $seq,
                                      'status'=>1,
                                      'promo_type' => $result['PromotionTypeCode'],
                                      'sap_code' => $result['PromoId'],
                                      'brand_names' => NULL,                                  
                                      'created_at' => Carbon::now()->toDateTimeString(),
                                      'updated_at' => Carbon::now()->toDateTimeString(),
                                      'qualification_group_id' => $qualificationGroup,
                                      'assignment_group_id' => $assignmentGroup,
                                      'promo' => $assignmentGroup,
                                    ]);  
                                  }    
                          }
                        } 
                      }  
                    }
                  }
                }
              }
            
    }
}