<?php

namespace App\Jobs;

use App\Models\CompanyDetail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Models\OrderItems;
use App\Models\Transaction;
use App\Models\OrderDetails;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Http;
use Illuminate\Queue\Jobs\Job;

class GetRootproOrderIdJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $order_details;

    /**
     * Create a new job instance.
     */
    public function __construct($order_details)
    {
        $this->order_details = $order_details;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        if (isset($this->order_details)) {
          $RootProPromoItemClass=[];
          $RootProOrderItemClass=[]; 
          $customer_id=$this->order_details->customer_id;

          $routeProToken = CompanyDetail::first()->rp_token;

          $order_item_details = OrderItems::where('order_id', '=', $this->order_details->id)
                                ->get(['product_id','Unit_Price','case_Price','qty','total_Price','vat','total_discount','total_amount','uom_quantity']);
          $transactions_details = Transaction::where('order_id', $this->order_details->id)         
                                ->leftJoin(
                                  'product',
                                  'product.item_code',
                                  '=',
                                  'transactions.product_id'
                                )
                                ->leftJoin(
                                  'promotions',
                                  function ($join) use ($customer_id) {
                                      $join->on('promotions.id', '=', 'transactions.promo_id')
                                           //->where('promotions.status', 1)
                                           ->where('promotions.customer', $customer_id);
                                  }
                                )
                                ->orderBy('transactions.id')
                                ->get(['promo_id','transactions.product_id','item_name','promo_type','discount','sap_code']);

                foreach($order_item_details as $order_items)  {              
                    $RootProOrderItemClass[]= [
                        "Order_id" => $this->order_details->id, 
                        "Product_id" => $order_items->product_id,
                        "Unit_price" =>NULL, // 
                        "CASE_Price" =>$order_items->Unit_Price, 
                        "Qty" => $order_items->uom_quantity, 
                        "Total_price" =>$order_items->total_Price,
                        "Vat" =>$order_items->vat,
                        "given_disc" =>$order_items->total_discount,
                        "Total_amount" =>$order_items->total_amount,
                      ];
                }

                foreach($transactions_details as $transaction_details)  {  
                  $RootProPromoItemClass[]=[
                      "promo_id"  => $transaction_details->promo_id,
                      "product_code"  => $transaction_details->product_id,
                      "product_name"  => $transaction_details->item_name,
                      "promo_type"  => $transaction_details->promo_type,
                      "promo_amount"  =>$transaction_details->discount,
                      "SAP_Code"  => $transaction_details->sap_code
                      ];
                }      

                $json = 
                [
                  "Order_id" => $this->order_details->id,
                  "Po_number" => $this->order_details->po_number,
                  "Created_by" => $this->order_details->created_by,
                  "Route_code" => $this->order_details->delivery_route_code,
                  "Route_name" => $this->order_details->delivery_route_name,
                  "Created_timestamp" => $this->order_details->created_timestamp,
                  "Order_date" => $this->order_details->order_date,
                  "Ship_to" => $this->order_details->ship_to,
                  "Sales_man" => $this->order_details->sales_man,
                  "Status" => $this->order_details->Status,
                  "Total_order_value" =>$this->order_details->total_order_value,
                  "Delivery_slot" => $this->order_details->delivery_slot,
                  "Remarks" => $this->order_details->remarks,
                  "Vat" =>$this->order_details->vat_amt,
                  "Net_amount" =>$this->order_details->net_amt,
                  "customercode" => $this->order_details->customer_id,
                  "Approved_time" => NULL,
                  "LoyaltyAmount" => $this->order_details->loyalty_discount,
                  "order_details" => $RootProOrderItemClass,
                  "promo_details" => $RootProPromoItemClass                
                ];


                // $jsonString = json_encode($json, JSON_PRETTY_PRINT);
                //                  echo $jsonString; exit;

                $options = [];
                if (App::environment('local')) {
                  $options = ['verify' => false];
                }
               
                $url = 'https://salesforce.mayar.com/GTAppTestCore/api/DashboardPostOrder/';   
                $headers = [
                  'Content-Type' => 'application/json',
                  'Authorization' => 'Bearer ' . $routeProToken,
                ];                
                              
                $response = Http::timeout(500)->withHeaders($headers)
                  ->withOptions($options)
                  ->post($url, $json);

                if ($response->successful()) { 
                    $data = $response->json();    
                  if($data['success']==true){   
                      $rp_order_id = $data['data']['orderID'];
                      OrderDetails::where('id',$this->order_details->id)->update(['rp_order_id' => $rp_order_id]);                 
                  }
                //var_dump($data); exit;
              
              }
            } 
          }
}