<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

use App\Models\OrderItems;
use App\Models\Transaction;
use App\Models\OrderDetails;
use App\Models\Orderstatus;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Http;
use Illuminate\Queue\Jobs\Job;

class GetRootproOrderIdJobForNadec implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $order_details;

    /**
     * Create a new job instance.
     */
    public function __construct($order_details)
    {
        $this->order_details = $order_details;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        if (isset($this->order_details)) {
            $RootProPromoItemClass=[];
            $RootProOrderItemClass=[]; 
            $customer_id=$this->order_details->customer_id;  

            $options = [];
            if (App::environment('local')) {
              $options = ['verify' => false];
            }

               // $orderStatus = Orderstatus::where('value', $this->order_details->Status)->first();
                
                $json = [];
                //if ($orderStatus) {
                    $json = [
                        "OrderNumber" => (string)$this->order_details->id,
                        "CustomerCode" => (string)$this->order_details->customer_id,
                        "OrderDate" => $this->order_details->order_date,
                        "OrderStartTime" => $this->order_details->created_at,
                        "DeliveryDate" => $this->order_details->tentative_delivery_date,
                        "TotalOrderAmount" => $this->order_details->total_order_value,
                        "TotalVATAmount" => $this->order_details->vat_amt,
                        "TotalDiscountAmount" => $this->order_details->total_discount ?? "0",
                        "TotalPromotionAmount" => $this->order_details->total_discount ?? "0",
                        //"OrderStatus" => $orderStatus->status, 
                        "OrderStatus" => (string)$this->order_details->Status, 
                        "PlannedDeliveryDate" => $this->order_details->tentative_delivery_date,
                    ];
                //}  
              //$jsonString = json_encode($json, JSON_PRETTY_PRINT);
              //echo $jsonString; exit;


                  $url = 'https://salesproapidev.azurewebsites.net/B2BItem/CreateB2BOrderHeader';
                  $headers = [
                    'Content-Type' => 'application/json',
                  ];

                  $response = Http::timeout(500)->withHeaders($headers) 
                    ->withOptions($options)                                    
                    ->post($url, $json);  

                  if ($response->successful()) {  
                      $data = $response->json();

                    if($data["Status"]=='success'){ 
                        $order_item_details = OrderItems::where('order_id', '=', $this->order_details->id)
                                  ->where('is_foc',0)
                                  ->get(['product_id','is_foc','uom','Unit_Price','case_Price','qty','total_Price','vat','total_discount','total_amount','uom_quantity','uom_price','vat_amt']);
            
                        $groupedOrderItems = $order_item_details->groupBy('product_id');

                        foreach ($groupedOrderItems as $product_id => $group) {
                                    $RootProOrderItemClass[]= 
                                      [
                                      "OrderNumber" => (string)$this->order_details->id, 
                                      "ItemCode" => (string)$product_id,
                                      "SalesQty" => (string)$group->sum('uom_quantity'),
                                      "SalesPrice" => (string)$group->first()->uom_price,
                                      "SalesVAT" =>$group->first()->vat, 
                                      "SalesVATAmount" =>(string)$group->sum('vat_amt'),
                                      "TotalAmount" => (string)$group->sum('total_amount'), 
                                      "UOM" => 'Pcs',
                                      "FOC" => (string)$group->first()->is_foc,
                                       ] ;                 
                                }
                                
                                // $jsonString = json_encode($RootProOrderItemClass, JSON_PRETTY_PRINT);
                                // echo $jsonString; exit;

                                $url = 'https://salesproapidev.azurewebsites.net/B2BItem/CreateB2BOrderDetails';
                                $headers = [
                                  'Content-Type' => 'application/json',
                                ];            
                                $response = Http::timeout(500)->withHeaders($headers)
                                  ->withOptions($options)                    
                                  ->post($url, $RootProOrderItemClass);
                             // echo $response; exit;    
                                if ($response->successful()) { 
                                    $data = $response->json();   
                                    if($data['Status']=="success"){                                     
                                              
                                        $transactions_details = Transaction::where('order_id', $this->order_details->id)         
                                            ->leftJoin(
                                                'product',
                                                'product.item_code',
                                                '=',
                                                'transactions.product_id'
                                            )
                                            ->join(
                                                'promotions',
                                                function ($join) use ($customer_id) {
                                                    $join->on('promotions.id', '=', 'transactions.promo_id')
                                                        //->where('promotions.status', 1)
                                                        ->where('promotions.customer', $customer_id);
                                                }
                                            )
                                            ->orderBy('transactions.id')
                                            ->get(['promo_id','transactions.product_id','item_name','promo_type','discount','sap_code']);
            
                                            foreach($transactions_details as $transaction_details)  {                                                 
                                                $RootProPromoItemClass[]=   
                                                        [
                                                        "OrderNumber" => (string)$this->order_details->id,
                                                        "ItemCode" => (string)$transaction_details->product_id,
                                                        "PromoCode" => (string)$transaction_details->sap_code,
                                                        "PromoAmount" => $transaction_details->discount,
                                                        "PromotionQty"=>0,
                                                        ];
                                            }   
                                            
                                          $foc_details = OrderItems::where('order_id', '=', $this->order_details->id)
                                                      ->where('is_foc',1)
                                                      ->join(
                                                          'product',
                                                          'product.item_code',
                                                          '=',
                                                          'order_items.product_id'
                                                      )
                                                      ->join(
                                                          'promotions',
                                                          function ($join) use ($customer_id) {
                                                              $join->on('promotions.id', '=', 'order_items.foc_promotion_id')
                                                                  //->where('promotions.status', 1)  
                                                                  ->where('promotions.customer', $customer_id);
                                                          }
                                                      )
                                                ->orderBy('order_items.id')
                                                ->get(['order_items.product_id','order_items.qty','sap_code']);
                
                                                foreach($foc_details as $foc_detail)  {                                                 
                                                    $RootProPromoItemClass[]=   
                                                            [
                                                            "OrderNumber" => (string)$this->order_details->id,
                                                            "ItemCode" => (string)$foc_detail->product_id,
                                                            "PromoCode" => (string)$foc_detail->sap_code,
                                                            "PromoAmount" => (string)0,
                                                            "PromotionQty"=>$foc_detail->qty,
                                                            ];
                                                }  

                                             //  $jsonString = json_encode($RootProPromoItemClass, JSON_PRETTY_PRINT);
                                             //  echo $jsonString; exit;

                                            $url = 'https://salesproapidev.azurewebsites.net/B2BItem/CreateB2BOrderPromoDetails';
                                            $headers = [
                                              'Content-Type' => 'application/json',
                                            ];            
                                            $response = Http::timeout(500)->withHeaders($headers)                    
                                              ->withOptions($options)
                                              ->post($url, $RootProPromoItemClass);
                                             
                                            if ($response->successful()) { 
                                                $data = $response->json();                                                    
                                                if($data['Status']=="success"){                                                    
                                                    //$rp_order_id = $data['data']['orderID'];
                                                    OrderDetails::where('id',$this->order_details->id)->update(['rp_order_id' => 1]);                 
  
                                                }
                                            }                                       
                                    }    
                                }   
                    }
                }
              } 
            }
    }