<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LoyaltySurvey extends Model
{
  use HasFactory;
  protected $table = 'loyalty_survey';

  public function LoyaltySurveyQuestions()
  {
    return $this->hasMany(LoyaltySurveyQuestion::class, 'survey_id')->where(
      'active',
      '=',
      '1'
    );
  }
  public function LoyaltySurveyResults($id)
  {
    return $this->has(LoyatySurveyResult::class, 'survey_id')->where(
      'customer',
      '=',
      $id
    );
  }
  public function loyaltySurveyResult()
{
    return $this->hasMany(LoyatySurveyResult::class, 'survey_id');
}
}
