<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LoyatySurveyResult extends Model
{
  use HasFactory;

  public function LoyaltySurveyAnswers()
  {
    return $this->hasMany(
      LoyaltySurveyResultAnswers::class,
      'survey_result_id'
    )->leftJoin(
      'loyalty_survey_questions',
      'loyalty_survey_result_answers.question_id',
      '=',
      'loyalty_survey_questions.id'
    )->select([
        'loyalty_survey_questions.active AS active', 
        'loyalty_survey_questions.answer_hints AS answer_hints',
        'loyalty_survey_questions.answer_type AS answer_type',
        'loyalty_survey_questions.points AS points',
        'loyalty_survey_questions.question AS question',
        'loyalty_survey_questions.questionDetails AS questionDetails',
        'loyalty_survey_questions.id AS id',
        'loyalty_survey_questions.survey_id AS survey_id',
        'loyalty_survey_questions.max_number_uploads AS max_number_uploads',
        'loyalty_survey_questions.auto_evaluate AS auto_evaluate',
        'loyalty_survey_result_answers.question_id AS question_id',
        'loyalty_survey_result_answers.answer AS answer',
        'loyalty_survey_result_answers.scored_points AS question_scored_points',
        'loyalty_survey_result_answers.survey_result_id AS survey_result_id',
      ]);
  }
  public function LoyaltySurveyAnswersWithReferenceAnswer()
  {
    return $this->hasMany(
      LoyaltySurveyResultAnswers::class,
      'survey_result_id'
    )->leftJoin(
      'loyalty_survey_questions',
      'loyalty_survey_result_answers.question_id',
      '=',
      'loyalty_survey_questions.id'
    )->select([
        'loyalty_survey_questions.active AS active',
        'loyalty_survey_questions.answer AS reference_answer',
        'loyalty_survey_questions.answer_hints AS answer_hints',
        'loyalty_survey_questions.answer_type AS answer_type',
        'loyalty_survey_questions.points AS points',
        'loyalty_survey_questions.question AS question',
        'loyalty_survey_questions.questionDetails AS questionDetails',
        'loyalty_survey_questions.id AS id',
        'loyalty_survey_questions.survey_id AS survey_id',        
        'loyalty_survey_questions.max_number_uploads AS max_number_uploads',
        'loyalty_survey_questions.auto_evaluate AS auto_evaluate',
        'loyalty_survey_result_answers.question_id AS question_id',
        'loyalty_survey_result_answers.answer AS answer',
        'loyalty_survey_result_answers.scored_points AS question_scored_points',
        'loyalty_survey_result_answers.survey_result_id AS survey_result_id',
      ]);
  }

}
