<?php

namespace App\Models;
use App\Models\OrderItems;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;
class OrderDetails extends Model
{
  use HasFactory, SoftDeletes;

  protected $table = 'order_details';
  protected $primaryKey = 'id';

  public function orderDetails()
  {


    $company_details = CompanyDetail::where('id', 1)            
                            ->first('company_shortcode');
                           
          if ($company_details) {  
             if($company_details->company_shortcode =='MAYAR'){   
              return $this->hasMany(OrderItems::class, 'order_id', 'id')
              ->join("product", "product.item_code", "=", "order_items.product_id")
              ->select([
                  'order_items.id',
                  'order_items.product_id',
                  'order_items.order_id',
                  'order_items.active',
                  'order_items.*',
                  'product.item_name AS item_name',
                  'product.upc AS upc',
                  'product.thumbnail_product_image AS product_image',
                   DB::raw('(order_items.total_Price - order_items.total_discount) as subtotal'),
              ]);
             } 
             if($company_details->company_shortcode =='NADEC'){
              return $this->hasMany(OrderItems::class, 'order_id', 'id')
              ->join("order_details", "order_items.order_id", "=", "order_details.id")
              ->join("customer", "customer.code", "=", "order_details.customer_id")
              ->join("product", function ($join) {
                  $join->on("product.item_code", "=", "order_items.product_id")
                      ->where("product.main_depot_name", "=", DB::raw("customer.depot_name"));
              })
              ->select([
                  'order_items.id',
                  'order_items.product_id',
                  'order_items.order_id',
                  'order_items.active',
                  'order_items.*',
                  'product.item_name AS item_name',
                  'product.upc AS upc',
                  'product.thumbnail_product_image AS product_image'
              ]);
             }
          }  


       
  }
  public function orderDetailsWithDepotCode()
  {
    return $this->hasMany(OrderItems::class, 'order_id', 'id')
    ->join("order_details", "order_items.order_id", "=", "order_details.id")
    ->join("customer_copy", "customer_copy.code", "=", "order_details.customer_id")
    ->join("product", function ($join) {
        $join->on("product.item_code", "=", "order_items.product_id")
            ->where("product.main_depot_name", "=", DB::raw("customer_copy.depot_name"));
    })
    ->select([
        'order_items.id',
        'order_items.product_id',
        'order_items.order_id',
        'order_items.active',
        'order_items.*',
        'product.item_name AS item_name',
        'product.upc AS upc',
        'product.thumbnail_product_image AS product_image'
    ]);
       
  }


  // public function orderDetails()
  // {
  // return $this->hasMany(OrderItems::class, 'order_id', 'id')
  // ->join("product", "product.item_code", "=", "order_items.product_id")
  // ->select([
  //     'order_items.id',
  //     'order_items.product_id',
  //     'order_items.order_id',
  //     'order_items.active',
  //     'product.upc',
  //     DB::raw('GROUP_CONCAT(order_items.direction) as direction'),
  //     DB::raw('GROUP_CONCAT(order_items.uom) as uom'),
  //     DB::raw('GROUP_CONCAT(order_items.Unit_Price) as Unit_Price'),
  //     DB::raw('GROUP_CONCAT(order_items.qty) as qty'),
  //     DB::raw('GROUP_CONCAT(order_items.total_Price) as total_Price'),
  //     DB::raw('GROUP_CONCAT(order_items.total_discount) as total_discount'),
  //     DB::raw('GROUP_CONCAT(order_items.remarks) as remarks'),
  //     DB::raw('GROUP_CONCAT(order_items.vat) as vat'),
  //     DB::raw('GROUP_CONCAT(order_items.vat_amt) as vat_amt'),
  //     DB::raw('GROUP_CONCAT(order_items.total_amount) as total_amount'),
  //     DB::raw('GROUP_CONCAT(order_items.created_by) as created_by'),
  //     DB::raw('GROUP_CONCAT(order_items.case_Price) as case_Price'),
  //     DB::raw('GROUP_CONCAT(order_items.is_foc) as is_foc'),
  //     DB::raw('GROUP_CONCAT(product.upc) as upc'),
  //     DB::raw('GROUP_CONCAT(order_items.foc_promotion_id) as foc_promotion_id'),
  //     DB::raw('GROUP_CONCAT(order_items.uom_quantity) as uom_quantity'),
  //     DB::raw('GROUP_CONCAT(order_items.uom_price) as uom_price'),
  //     DB::raw('GROUP_CONCAT(product.item_name) as item_name'),
  //     DB::raw('GROUP_CONCAT(product.thumbnail_product_image) as product_image')
  // ])
  // ->groupBy('order_items.id')
  // ->groupBy('order_items.product_id', 'order_items.order_id', 'order_items.active','product.upc');
 
// }   
  
 
}
