<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
  use HasFactory;
  protected $primaryKey = 'item_code';
  protected $table = 'product';
  protected $fillable = [
    'item_name',
    'item_code',
    'item_group',
    'item_sub_group',
    'detailed_desc_en',
    'detailed_desc_ar',
    'VAT',
    'upc',
    'active',
    'main_depot_name',
    'item_tax_group'
  ];

  public function ProductImage()
  {
    return $this->hasMany(ProductImage::class, 'product_id', 'item_code');
  }
  
}
