<?php 

namespace App\Services;

use App\Mail\OrderNotification;
use App\Models\Customer;
use App\Models\OrderDetails;
use App\Models\OrderItems;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;

class OrderNotificationService
{


    public function sendEmailtoUser($order_id)
    {
        $arraydata=[];
        $orderHeader = OrderDetails::where('rp_order_id', $order_id)->first();
        
        if (!is_null($orderHeader)) {

            $orderHeader->order_date = Carbon::parse($orderHeader->order_date)->format('d-m-Y');

            $orderHeader->loyalty_discount =number_format($orderHeader->loyalty_discount ,2);
            $orderHeader->total_order_value =number_format($orderHeader->total_order_value ,2);
            $orderHeader->vat_amt =number_format($orderHeader->vat_amt ,2);
            $orderHeader->net_amt =number_format($orderHeader->net_amt ,2);
            $orderHeader->total_discount =number_format($orderHeader->total_discount ,2);
            $orderHeader->tentative_delivery_date=Carbon::parse($orderHeader->tentative_delivery_date)->format('d-F-Y');

            $orderDetails = OrderItems::where('order_id', $orderHeader->id) ->join('product', 'order_items.product_id', '=', 'product.item_code')->get();
            $customerDetails =  Customer::where('CODE', $orderHeader->customer_id)->first();
            $userDetails =  User::where('id', $orderHeader->user_id)->first();
        }

        if (!is_null($orderHeader) && !is_null($customerDetails)) {

            $arraydata = array(
                'orderHeader' => $orderHeader,
                'orderDetail' =>  $orderDetails,
                'customerData' =>  $customerDetails,
                'user' =>  $userDetails
            );
            $msg='Your Order Confirmation: #'.$orderHeader->rp_order_id;

            Mail::to($userDetails->email)->send(new OrderNotification($msg, $arraydata));
       
        }
        // Process the result
    }

}